/*
 * Decompiled with CFR 0.152.
 */
package y.layout.tree;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import y.algo.Trees;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.WrongGraphStructure;
import y.geom.YDimension;
import y.geom.YPoint;
import y.layout.CanonicMultiStageLayouter;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.tree.if;

public class ARTreeLayouter
extends CanonicMultiStageLayouter {
    public static final Object RATIO = "y.layout.tree.ARTreeLayouter.RATIO";
    public static final Object ROOT_PLACEMENT = "y.layout.tree.ARTreeLayouter.ROOT_PLACEMENT";
    public static final Object PLACEMENT_TOP = "y.layout.tree.ARTreeLayouter.PLACEMENT_TOP";
    public static final Object PLACEMENT_CORNER = "y.layout.tree.ARTreeLayouter.PLACEMENT_CORNER";
    public static final Object PLACEMENT_CORNER_SIDE = "y.layout.tree.ARTreeLayouter.PLACEMENT_CORNER_SIDE";
    public static final Object PLACEMENT_CORNER_TOP = "y.layout.tree.ARTreeLayouter.PLACEMENT_CORNER_TOP";
    public static final Object ROUTING_POLICY = "y.layout.tree.ARTreeLayouter.ROUTING_POLICY";
    public static final Object ROUTING_HORIZONTAL = "y.layout.tree.ARTreeLayouter.ROUTING_HORIZONTAL";
    public static final Object ROUTING_VERTICAL = "y.layout.tree.ARTreeLayouter.ROUTING_VERTICAL";
    private NodeMap j7;
    private if j8;
    protected LayoutGraph graph;
    private double j9 = 10.0;
    private double kd = 10.0;
    private double kb = 5.0;
    private double j4 = 1.41;
    private boolean j5 = false;
    private Object ka = PLACEMENT_CORNER;
    private Object kc = ROUTING_HORIZONTAL;
    private double j6 = 20.0;

    public void setHorizontalSpace(double d2) {
        this.j9 = d2;
    }

    public double getHorizontalSpace() {
        return this.j9;
    }

    public void setVerticalSpace(double d2) {
        this.kd = d2;
    }

    public double getVerticalSpace() {
        return this.kd;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        if (!Trees.isTree(layoutGraph)) {
            throw new WrongGraphStructure("Graph is not a tree");
        }
        LayoutTool.resetPaths(layoutGraph);
        this.graph = layoutGraph;
        EdgeList edgeList = Trees.directTree(layoutGraph);
        this.j8 = new if(layoutGraph);
        Node node = this.j8.c();
        this.j7 = layoutGraph.createNodeMap();
        this.i(node);
        this.h(node);
        layoutGraph.disposeNodeMap(this.j7);
        while (!edgeList.isEmpty()) {
            LayoutTool.reverseEdgeLayout(layoutGraph.getLayout(edgeList.popEdge()));
        }
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return Trees.isTree(layoutGraph);
    }

    protected double getAspectRatio(Node node) {
        DataProvider dataProvider = this.graph.getDataProvider(RATIO);
        if (dataProvider == null) {
            return this.getAspectRatio();
        }
        Object object = dataProvider.get(node);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return this.getAspectRatio();
    }

    private _a i(Node node) {
        _a _a2 = new _a();
        this.j7.set(node, _a2);
        if (!this.j8.c(node)) {
            Object object;
            double d2 = 0.0;
            double d3 = 0.0;
            Object object2 = this.getRootPlacement(node);
            Object object3 = this.getRoutingPolicy(node);
            NodeCursor nodeCursor = node.successors();
            while (nodeCursor.ok()) {
                object = nodeCursor.node();
                _a _a3 = this.i((Node)object);
                nodeCursor.next();
            }
            object = null;
            object = this.a(node, this.getAspectRatio(node));
            if (PLACEMENT_TOP.equals(object2)) {
                _a2.a = this.graph.getHeight(node) + 2.0 * this.j6 + ((YDimension)object).getHeight();
                _a2.d = Math.max(this.graph.getWidth(node), ((YDimension)object).getWidth());
            } else {
                double d4 = this.graph.getWidth(node);
                double d5 = this.graph.getHeight(node);
                double d6 = Math.max(d4, ((YDimension)object).getWidth() + 2.0 * this.j6) * (d5 + ((YDimension)object).getHeight() + 2.0 * this.j6);
                double d7 = (d4 + 2.0 * this.j6 + ((YDimension)object).getWidth()) * Math.max(d5, ((YDimension)object).getHeight() + 2.0 * this.j6);
                double d8 = _a2.b > 1 || ROUTING_HORIZONTAL.equals(object3) ? 2.0 * this.j6 + ((YDimension)object).getHeight() : this.kd + ((YDimension)object).getHeight();
                double d9 = this.j6 < d4 ? Math.max(d4, ((YDimension)object).getWidth() + 2.0 * this.j6) : Math.max(d4, ((YDimension)object).getWidth() + this.j6 + d4);
                if (PLACEMENT_CORNER.equals(object2)) {
                    if (d6 < d7) {
                        d8 += d5;
                        d9 = this.j6 < d4 ? Math.max(d4, ((YDimension)object).getWidth() + 2.0 * this.j6) : Math.max(d4, ((YDimension)object).getWidth() + this.j6 + d4);
                    } else {
                        _a2.g = true;
                        d8 = Math.max(d8, d5);
                        d9 = d4 + ((YDimension)object).getWidth() + 2.0 * this.j6;
                    }
                } else if (PLACEMENT_CORNER_SIDE.equals(object2)) {
                    _a2.g = true;
                    d8 = Math.max(d8, d5);
                    d9 = d4 + ((YDimension)object).getWidth() + 2.0 * this.j6;
                } else {
                    d8 += d5;
                    d9 = this.j6 < d4 ? Math.max(d4, ((YDimension)object).getWidth() + 2.0 * this.j6) : Math.max(d4, ((YDimension)object).getWidth() + this.j6 + d4);
                }
                _a2.d = d9;
                _a2.a = d8;
            }
            _a2.c = object;
        } else {
            _a2.d = this.graph.getWidth(node);
            _a2.a = this.graph.getHeight(node);
        }
        return _a2;
    }

    private YDimension a(Node node, double d2) {
        int n;
        Object object;
        double d3 = this.j9;
        double d4 = this.kd;
        Object object2 = this.getRoutingPolicy(node);
        Rectangle2D[] rectangle2DArray = new Rectangle2D.Double[node.outDegree()];
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        int n2 = 0;
        if (ROUTING_HORIZONTAL.equals(object2)) {
            Object object3;
            Object object4;
            d4 += this.j6;
            object = node.successors();
            while (object.ok()) {
                object4 = object.node();
                object3 = (_a)this.j7.get(object4);
                rectangle2DArray[n2++] = new Rectangle2D.Double(0.0, 0.0, ((_a)object3).d + d3, ((_a)object3).a + d4);
                object.next();
            }
            n = LayoutTool.arrangeRectangleRows(rectangle2DArray, double_, d2, 1);
            n2 = 0;
            object4 = node.successors();
            while (object4.ok()) {
                object3 = object4.node();
                _a _a2 = (_a)this.j7.get(object3);
                Rectangle2D rectangle2D = rectangle2DArray[n2++];
                _a2.f = ((Rectangle2D.Double)rectangle2D).x;
                _a2.e = ((Rectangle2D.Double)rectangle2D).y;
                object4.next();
            }
        } else {
            Object object5;
            Object object6;
            d3 += this.j6;
            object = node.successors();
            while (object.ok()) {
                object6 = object.node();
                object5 = (_a)this.j7.get(object6);
                rectangle2DArray[n2++] = new Rectangle2D.Double(0.0, 0.0, ((_a)object5).a + d4, ((_a)object5).d + d3);
                object.next();
            }
            n = LayoutTool.arrangeRectangleRows(rectangle2DArray, double_, 1.0 / d2, 1);
            double_.setFrame(((RectangularShape)double_).getY(), ((RectangularShape)double_).getX(), ((RectangularShape)double_).getHeight(), ((RectangularShape)double_).getWidth());
            n2 = 0;
            object6 = node.successors();
            while (object6.ok()) {
                object5 = object6.node();
                _a _a3 = (_a)this.j7.get(object5);
                Rectangle2D rectangle2D = rectangle2DArray[n2++];
                _a3.f = ((Rectangle2D.Double)rectangle2D).y;
                _a3.e = ((Rectangle2D.Double)rectangle2D).x;
                object6.next();
            }
        }
        object = (_a)this.j7.get(node);
        ((_a)object).b = n;
        return new YDimension(((RectangularShape)double_).getWidth() - ((RectangularShape)double_).getX() - d3, ((RectangularShape)double_).getHeight() - ((RectangularShape)double_).getY() - d4);
    }

    private void h(Node node) {
        double d2;
        double d3;
        _a _a2 = (_a)this.j7.get(node);
        Object object = this.getRootPlacement(node);
        Object object2 = this.getRoutingPolicy(node);
        if (PLACEMENT_TOP.equals(object)) {
            d3 = this.graph.getY(node) + this.graph.getHeight(node) + 2.0 * this.j6;
            d2 = this.graph.getCenterX(node) - _a2.c.getWidth() / 2.0;
        } else {
            double d4 = this.graph.getWidth(node);
            if (_a2.g) {
                d3 = _a2.b > 1 || ROUTING_HORIZONTAL.equals(object2) ? this.graph.getY(node) + 2.0 * this.j6 : this.graph.getY(node) + this.kd;
                d2 = this.graph.getX(node) + d4 + 2.0 * this.j6;
            } else {
                d3 = _a2.b > 1 || ROUTING_HORIZONTAL.equals(object2) ? this.graph.getY(node) + this.graph.getHeight(node) + 2.0 * this.j6 : this.graph.getY(node) + this.graph.getHeight(node) + this.kd;
                d2 = this.j6 < d4 ? this.graph.getX(node) + 2.0 * this.j6 : this.graph.getX(node) + this.j6 + d4;
            }
        }
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Node node2 = edge.target();
            _a _a3 = (_a)this.j7.get(node2);
            this.graph.setLocation(node2, d2 + _a3.f, d3 + _a3.e);
            if (!this.j8.c(node2)) {
                this.h(node2);
            }
            EdgeLayout edgeLayout = this.graph.getLayout(edge);
            edgeLayout.clearPoints();
            this.createBends(edgeLayout, node, node2, object, object2);
            edgeCursor.next();
        }
    }

    protected void createBends(EdgeLayout edgeLayout, Node node, Node node2, Object object, Object object2) {
        _a _a2 = (_a)this.j7.get(node);
        double d2 = this.graph.getWidth(node);
        double d3 = this.graph.getHeight(node);
        if (PLACEMENT_TOP.equals(object)) {
            double d4 = this.graph.getCenterX(node);
            double d5 = this.graph.getY(node) + d3 + this.j6;
            edgeLayout.addPoint(d4, d5);
            if (ROUTING_HORIZONTAL.equals(object2)) {
                double d6 = this.graph.getY(node2) - this.j6;
                edgeLayout.addPoint(d4, d6);
                edgeLayout.addPoint(this.graph.getCenterX(node2), d6);
            } else {
                double d7 = this.graph.getCenterX(node2) < d4 ? this.graph.getX(node2) + this.graph.getWidth(node2) + this.j6 : this.graph.getX(node2) - this.j6;
                edgeLayout.addPoint(d7, d5);
                edgeLayout.addPoint(d7, this.graph.getCenterY(node2));
            }
        } else {
            double d8;
            double d9;
            if (_a2.g) {
                edgeLayout.setSourcePoint(new YPoint(0.0, -d3 / 2.0 + this.kb));
                d9 = this.graph.getX(node) + d2 + this.j6;
                d8 = this.graph.getY(node) + this.kb;
            } else {
                edgeLayout.setSourcePoint(new YPoint(-d2 / 2.0 + this.kb, 0.0));
                d9 = this.graph.getX(node) + this.kb;
                d8 = this.graph.getY(node) + d3 + this.j6;
            }
            edgeLayout.addPoint(d9, d8);
            if (ROUTING_HORIZONTAL.equals(object2)) {
                double d10 = this.graph.getY(node2) - this.j6;
                edgeLayout.addPoint(d9, d10);
                edgeLayout.addPoint(this.graph.getCenterX(node2), d10);
            } else {
                double d11 = this.graph.getX(node2) - this.j6;
                edgeLayout.addPoint(d11, d8);
                edgeLayout.addPoint(d11, this.graph.getCenterY(node2));
            }
        }
    }

    protected Object getRoutingPolicy(Object object) {
        DataProvider dataProvider = this.graph.getDataProvider(ROUTING_POLICY);
        if (dataProvider == null) {
            return this.getRoutingPolicy();
        }
        Object object2 = dataProvider.get(object);
        if (object2 != null) {
            return object2;
        }
        return this.getRoutingPolicy();
    }

    protected Object getRootPlacement(Object object) {
        DataProvider dataProvider = this.graph.getDataProvider(ROOT_PLACEMENT);
        if (dataProvider == null) {
            return this.getRootPlacement();
        }
        Object object2 = dataProvider.get(object);
        if (object2 != null) {
            return object2;
        }
        return this.getRootPlacement();
    }

    public double getAspectRatio() {
        return this.j4;
    }

    public Object getRootPlacement() {
        return this.ka;
    }

    public void setRootPlacement(Object object) {
        this.ka = object;
    }

    public Object getRoutingPolicy() {
        return this.kc;
    }

    public void setRoutingPolicy(Object object) {
        this.kc = object;
    }

    public double getBendDistance() {
        return this.j6;
    }

    public void setBendDistance(double d2) {
        this.j6 = d2;
    }

    public void setAspectRatio(double d2) {
        this.j4 = d2;
        this.j5 = true;
    }

    static final class _a {
        double d;
        double a;
        double f;
        double e;
        YDimension c;
        int b;
        boolean g;

        _a() {
        }
    }
}

