/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.io;

import com.nepxion.util.encoder.EncoderContext;
import com.nepxion.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class FileUtil {
    public static String readString(String filePath, boolean classLoader) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        return FileUtil.readString(filePath, EncoderContext.getIOCharset(), classLoader);
    }

    public static String readString(String filePath, String charset, boolean classLoader) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        InputStream inputStream = FileUtil.getInputStream(filePath, classLoader);
        return IOUtil.getString(inputStream, charset);
    }

    public static byte[] readBytes(InputStream inputStream, int length) throws IOException {
        int offset;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] bytes = new byte[length];
        int bytesRead = 0;
        try {
            for (offset = 0; offset < length; offset += bytesRead) {
                bytesRead = ((InputStream)bufferedInputStream).read(bytes, offset, bytes.length - offset);
                if (bytesRead != -1) continue;
                break;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
        if (offset != length) {
            throw new IOException("Only " + offset + " bytes read, " + length + " bytes expected");
        }
        return bytes;
    }

    public static byte[] readRemoteBytes(String httpURL) throws IOException, MalformedURLException {
        URL url = new URL(httpURL);
        URLConnection urlConnection = url.openConnection();
        int contentLength = urlConnection.getContentLength();
        if (contentLength == -1) {
            throw new IOException("Invalid bytes size");
        }
        InputStream inputStream = urlConnection.getInputStream();
        return FileUtil.readBytes(inputStream, contentLength);
    }

    public static int readRemoteBytesLength(String httpURL) throws IOException, MalformedURLException {
        URL url = new URL(httpURL);
        URLConnection urlConnection = url.openConnection();
        int contentLength = urlConnection.getContentLength();
        if (contentLength == -1) {
            throw new IOException("Invalid bytes size");
        }
        return contentLength;
    }

    public static void writeString(String text, String filePath) throws IOException, FileNotFoundException {
        byte[] bytes = text.trim().getBytes();
        FileUtil.writeBytes(bytes, filePath);
    }

    public static void writeBytes(byte[] bytes, String filePath) throws IOException, FileNotFoundException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filePath);
            ((OutputStream)outputStream).write(bytes);
            outputStream.flush();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public static InputStream getInputStream(String filePath, boolean classLoader) throws FileNotFoundException {
        InputStream inputStream = null;
        inputStream = classLoader ? FileUtil.class.getClassLoader().getResourceAsStream(filePath) : new FileInputStream(filePath);
        return inputStream;
    }

    public static InputStream getInputStream(URL codeBase, String filePath) throws IOException, MalformedURLException {
        URL url = new URL(codeBase + filePath);
        InputStream inputStream = url.openStream();
        return inputStream;
    }

    public static InputStream getInputStream(URL codeBase, String filePath, boolean classLoader) throws IOException, FileNotFoundException, MalformedURLException {
        InputStream inputStream = null;
        inputStream = codeBase != null ? FileUtil.getInputStream(codeBase, filePath) : FileUtil.getInputStream(filePath, classLoader);
        return inputStream;
    }

    public static File download(String httpURL, String filePath) throws IOException, FileNotFoundException {
        File file = new File(filePath);
        if (file.exists()) {
            if ((long)FileUtil.readRemoteBytesLength(httpURL) == FileUtil.getFileSize(file)) {
                return file;
            }
            file.delete();
        }
        byte[] bytes = FileUtil.readRemoteBytes(httpURL);
        FileUtil.writeBytes(bytes, filePath);
        return file;
    }

    public static long getFileSize(File file) throws IOException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        return ((InputStream)inputStream).available();
    }

    public static void readMap(InputStream inputStream, Map map, boolean clear) throws Exception {
        FileUtil.readMap(inputStream, map, clear, EncoderContext.getIOCharset());
    }

    public static void readMap(InputStream inputStream, Map map, boolean clear, String charset) throws Exception {
        if (clear && map.size() > 0) {
            map.clear();
        }
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, charset);
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                String key = line.substring(0, line.indexOf("=")).trim();
                String value = line.substring(line.indexOf("=") + 1).trim();
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static void writeMap(OutputStream outputStream, Map map) throws Exception {
        PrintWriter printWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            printWriter = new PrintWriter(outputStream, true);
            bufferedWriter = new BufferedWriter(printWriter);
            int index = 0;
            int size = map.size();
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                bufferedWriter.write(key.trim() + "=" + value.trim());
                if (index < size - 1) {
                    bufferedWriter.newLine();
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    public static String getProjectPath(Class clazz, String projectFolderName) {
        String path = clazz.getClassLoader().getResource("").getPath();
        path = path.substring(1);
        path = path.substring(0, path.indexOf(projectFolderName) + projectFolderName.length());
        return path;
    }

    public static String getResourcePath(Class clazz, String projectFolderName) {
        return FileUtil.getResourcePath(clazz, projectFolderName, "src");
    }

    public static String getResourcePath(Class clazz, String projectFolderName, String resourceFolderName) {
        String classPath = clazz.getName();
        classPath = classPath.replace('.', '/') + ".java";
        String resourcePath = clazz.getClassLoader().getResource("").getPath();
        resourcePath = resourcePath.substring(1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(projectFolderName) + projectFolderName.length());
        resourcePath = resourcePath + "/" + resourceFolderName + "/";
        String codePath = resourcePath + classPath;
        return codePath;
    }
}

