package com.freemud.springbootdemo.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: Swagger2
 * @Package com.freemud.order
 * @Description: Swagger2配置类
 * @author: junliang.li
 * @date: 2017/5/9 15:01
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Configuration
@EnableSwagger2
public class Swagger2 {

    @Value("${swagger_enable:}")
    String swaggerEnable;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .enable("true".equals(this.swaggerEnable))
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.freemud.springbootdemo.controller"))
                .paths(PathSelectors.any())
                .build();
    }
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("Demo RESTful APIs")
                .description("demo APIs")
                .termsOfServiceUrl("http://www.freemud.cn/")
                .version("1.0")
                .build();
    }
}
