package com.freemud.demo.service.impl;

import com.freemud.demo.dto.DictDataDto;
import com.freemud.demo.dto.DictTypeDto;
import com.freemud.demo.dto.PageData;
import com.freemud.demo.dto.PageReq;
import com.freemud.demo.cache.DictRedisCache;
import com.freemud.demo.mapper.TDictDataMapper;
import com.freemud.demo.mapper.TDictTypeMapper;
import com.freemud.demo.model.TDictData;
import com.freemud.demo.model.TDictType;
import com.freemud.demo.service.IDictTypeService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by chenwenshun on 2018/11/2.
 */
@Service
public class DictTypeServiceImpl implements IDictTypeService{

    @Autowired
    private TDictTypeMapper dictTypeMapper;

    @Autowired
    private TDictDataMapper dictDataMapper;

    @Autowired
    DictRedisCache dictRedisCache;

    @Override
    public TDictType loadDictById(long dictTypeId) {
        return null;
    }

    @Override
    public TDictType loadDictByCd(String dictTypeCd) {
        return null;
    }

    @Override
    public DictDataDto loadDictDataByCd(String dictTypeCd, String dictCd, boolean onlyEnable) {
        TDictData dictData = this.dictDataMapper.getDictDataByCd(dictTypeCd, dictCd);
        if (dictData == null){
            return null;
        }
        DictDataDto dictDataDto = new DictDataDto();
        BeanUtils.copyProperties(dictData, dictDataDto);
        if (onlyEnable ){
            if (!dictData.getEnableFlg()){
                return null;
            }
        }

        return dictDataDto;
    }


    @Override
    public TDictType saveDict(DictTypeDto dto) {
        return null;
    }

    @Override
    public void saveDatas(List<DictDataDto> dictDataDtos) {

    }

    @Override
    public void deleteDict(long dictTypeId) {

    }

    @Override
    public void deleteDictData(long dictDataId) {

    }

    @Override
    public PageData<DictTypeDto> findPageDict(PageReq pageReq) {
        Page<Long> page = PageHelper.startPage(pageReq.getPageNo(),pageReq.getPageSize())
                .doSelectPage(() -> {
                    this.dictTypeMapper.getIdsByTypeCdOrName(pageReq);
        });
        List<DictTypeDto> dictTypeDtoList = Lists.newArrayList();


        List<DictTypeDto> list = page.stream()
                .map(id -> {
                    DictTypeDto dictTypeDto = this.dictRedisCache.getCache(id,DictTypeDto.class);
                    return dictTypeDto;
                })
                .collect(Collectors.toList());

        return new PageData<DictTypeDto>(page.getTotal(), list);
    }

    @Override
    public List<DictDataDto> loadDatasByTypeCd(String dictTypeCd, boolean onlyEnable) {
        List<DictDataDto> dictDataDtos = Lists.newArrayList();
        List<TDictData> dictDataList = this.dictDataMapper.loadDatasByTypeCd(dictTypeCd);
        if (dictDataList.isEmpty()){
            return dictDataDtos;
        }
        if (onlyEnable){
            dictDataDtos = dictDataList.stream()
                    .filter(TDictData::getEnableFlg)
                    .map(d -> {
                        DictDataDto dictDataDto = new DictDataDto();
                        BeanUtils.copyProperties(d, dictDataDto);
                        return dictDataDto;
                    })
                    .collect(Collectors.toList());

        }else {
            dictDataDtos = dictDataList.stream()
                    .map(d -> {
                        DictDataDto dictDataDto = new DictDataDto();
                        BeanUtils.copyProperties(d, dictDataDto);
                        return dictDataDto;
                    })
                    .collect(Collectors.toList());
        }


        return dictDataDtos;
    }

    @Override
    public Map<String, String> loadDataMap(String dictTypeCd) {
        return null;
    }

}
