#ifndef PRINTERDOCUMENT_H
#define PRINTERDOCUMENT_H

#include <QObject>
#include <QStringList>
#include <QList>
class LineNode;

class PrintDocument : public QObject
{
    Q_OBJECT
public:
    explicit PrintDocument(QObject *parent = 0):QObject(parent),_index(0){}
    PrintDocument(const PrintDocument& p,QObject *parent = 0);
    PrintDocument &operator =(const PrintDocument& p);
    static PrintDocument ParseToDocument(const QByteArray& content,bool result,QString& error);
    static PrintDocument ParseToDocument(const QString& content, bool &result, QString& error);
    QList<LineNode*> GetNodeList()const;
    QList<int> GetProductNodeIndex() const;
public:

private:
    int _index;
    QList<LineNode*> _nodeList;
    QList<int> _productNodeIndexList;
signals:

public slots:
};

class LineNode : public QObject
{
    Q_OBJECT
public:
    explicit LineNode(const QString& line,QObject *parent=0);
    LineNode(const LineNode& p,QObject *parent = 0);
    LineNode &operator =(const LineNode& p);
    Q_PROPERTY(QString nodeName READ getNodeName WRITE setNodeName)
    Q_PROPERTY(QString text READ getText WRITE setText)
    Q_PROPERTY(QString style READ getStyle WRITE setStyle)
    Q_PROPERTY(QString content READ getContent WRITE setContent)
    Q_PROPERTY(int time READ getTime WRITE setTime)
    Q_PROPERTY(int printType READ getPrintType WRITE setPrintType)
    Q_PROPERTY(int fontType READ getFontType WRITE setFontType)
    Q_PROPERTY(int fontStyle READ getFontStyle WRITE setFontStyle)
    Q_PROPERTY(int width READ getWidth WRITE setWidth)
    Q_PROPERTY(int height READ getHeight WRITE setHeight)
    Q_PROPERTY(int codeType READ getCodeType WRITE setCodeType)
    Q_PROPERTY(int position READ getPosition WRITE setPosition)
    Q_PROPERTY(int leftMargin READ getLeftMargin WRITE setLeftMargin)

    QString nodeName;
    QString text;
    QString style;
    QString content;
    int time;
    int printType;
    int fontType;
    int fontStyle;
    int width;
    int height;
    int codeType;
    int position;
    int leftMargin;

    QString getNodeName()const{return nodeName;}
    void setNodeName(const QString& v){ nodeName = v;}
    QString getText()const{return text;}
    void setText(const QString& v){ text = v;}
    QString getStyle()const{return style;}
    void setStyle(const QString& v){ style = v;}
    QString getContent()const{return content;}
    void setContent(const QString& v){ content = v;}
    int getTime()const{return time;}
    void setTime(const int& v){ time = v;}
    int getPrintType()const{return printType;}
    void setPrintType(const int& v){ printType = v;}
    int getFontType()const{return fontType;}
    void setFontType(const int& v){ fontType = v;}
    int getFontStyle()const{return fontStyle;}
    void setFontStyle(const int& v){ fontStyle = v;}
    int getWidth()const{return width;}
    void setWidth(const int& v){ width = v;}
    int getHeight()const{return height;}
    void setHeight(const int& v){ height = v;}
    int getCodeType()const{return codeType;}
    void setCodeType(const int& v){ codeType = v;}
    int getPosition()const{return position;}
    void setPosition(const int& v){ position = v;}
    int getLeftMargin()const{return leftMargin;}
    void setLeftMargin(const int& v){ leftMargin = v;}

    bool ParseData(const QString& line);

};

#endif // PRINTERDOCUMENT_H
