#include "printDocument.h"
#include <QMetaProperty>
#include <QDebug>

PrintDocument::PrintDocument(const PrintDocument& p, QObject *parent):QObject(parent)
{
    _productNodeIndexList = p.GetProductNodeIndex();
    QList<LineNode*> list = p.GetNodeList();
    for(int i=0;i<list.size();i++)
    {
        LineNode *node = new LineNode(*list.at(i),this);
        this->_nodeList.append(node);
    }
}

PrintDocument& PrintDocument::operator =(const PrintDocument& p)
{
    qDeleteAll(_nodeList);
    _nodeList.clear();
    _productNodeIndexList = p.GetProductNodeIndex();
    QList<LineNode*> list = p.GetNodeList();
    for(int i=0;i<list.size();i++)
    {
        LineNode *node = new LineNode(*list.at(i),this);
        this->_nodeList.append(node);
    }
    return *this;
}

PrintDocument PrintDocument::ParseToDocument(const QByteArray &content, bool result, QString &error)
{
    PrintDocument doc;
    result = true;
    int indexForword=0,indexBack=0;
    while(indexBack!=(content.length()-1)&&indexBack!=-1&&indexForword!=-1)
    {
        indexForword = content.indexOf('<',0);
        indexBack = content.indexOf('>',0);
        if(indexBack!=-1&&indexForword!=-1)
        {
            QString printLine = content.mid(indexForword+1,indexBack-indexForword-2);
            LineNode *node = new LineNode(printLine,&doc);
            doc._nodeList.append(node);
        }
        else
        {
            result = false;
            error = "lock of '<' or '>'";
            return PrintDocument();
        }
    }
    return doc;
}

PrintDocument PrintDocument::ParseToDocument(const QString &content, bool &result, QString &error)
{
    PrintDocument doc;
    result = true;
    int indexForword=0,indexBack=0;
    while(indexBack!=(content.length()-1)&&indexBack!=-1&&indexForword!=-1)
    {
        indexForword = content.indexOf('<',indexBack);
        indexBack = content.indexOf('>',indexForword);
        if(indexBack!=-1&&indexForword!=-1)
        {
            QString printLine = content.mid(indexForword+1,indexBack-indexForword-1);
            LineNode *node = new LineNode(printLine,&doc);
            if(!node->nodeName.compare("product"))
            {
                doc._productNodeIndexList.append(doc._nodeList.size());
            }
            doc._nodeList.append(node);
        }
        else
        {
            result = false;
            error = "lock of '<' or '>'";
            return PrintDocument();
        }
    }
    return doc;
}

QList<LineNode *> PrintDocument::GetNodeList() const
{
    return this->_nodeList;
}

QList<int> PrintDocument::GetProductNodeIndex() const
{
    return this->_productNodeIndexList;
}


LineNode::LineNode(const QString &line, QObject *parent):QObject(parent)
{
    QStringList list = line.split('"');
    time = 0;
    int size = list.size();
    switch (size)
    {
    case 0:
        return;
    case 5:
    {
        QString timeStr=list.at(4);
        time = timeStr.toInt();
    }
    case 4:
        content = list.at(3);
    case 3:
        style = list.at(2);
    case 2:
        text = list.at(1);
    case 1:
        nodeName = list.at(0);
        break;
    default:
        break;
    }

    nodeName = list.at(0);
    if(nodeName.isEmpty())
    {
        return;
    }
    bool ok =false;
    printType = style.mid(0,1).toInt(&ok,16);
    fontType = style.mid(1,2).toInt(&ok,16);
    fontStyle = style.mid(3,4).toInt(&ok,16);
    width = style.mid(7,2).toInt(&ok,10);
    height = style.mid(9,3).toInt(&ok,10);
    codeType = style.mid(12,2).toInt(&ok,16);
    position = style.mid(14,1).toInt(&ok,16);
    leftMargin = style.mid(15,5).toInt(&ok,10);
}

LineNode::LineNode(const LineNode &p, QObject *parent):QObject(parent)
{
    const QMetaObject *m = p.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
}

LineNode& LineNode::operator=(const LineNode &p)
{
    const QMetaObject *m = p.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    return *this;
}

bool LineNode::ParseData(const QString &line)
{
    QStringList list = line.split('"');
    time = 0;
    int size = list.size();
    switch (size)
    {
    case 0:
        return false;
    case 5:
    {
        QString timeStr=list.at(4);
        time = timeStr.toInt();
    }
    case 4:
        content = list.at(3);
    case 3:
        style = list.at(2);
    case 2:
        text = list.at(1);
    case 1:
        nodeName = list.at(0);
        break;
    default:
        break;
    }
    nodeName = list.at(0);
    if(nodeName.isEmpty())
    {
        return false;
    }
    bool ok =false;
    printType = style.mid(0,1).toInt(&ok,16);
    fontType = style.mid(1,2).toInt(&ok,16);
    fontStyle = style.mid(3,4).toInt(&ok,16);
    width = style.mid(7,2).toInt(&ok,10);
    height = style.mid(9,3).toInt(&ok,10);
    codeType = style.mid(12,2).toInt(&ok,16);
    position = style.mid(14,1).toInt(&ok,16);
    leftMargin = style.mid(15,5).toInt(&ok,10);
}
