﻿#include "settingForm.h"
#include "ui_settingForm.h"
#include "preDefine.h"
#include "base/Config/configManger.h"
//#include <QPrinterInfo>
#include <QSound>
//#include "fmPrinter.h"

SettingForm::SettingForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingForm)
{
    ui->setupUi(this);

    // 初始化打印机选项
    QString printer = ConfigManger::GetInstance().GetPrinterName();
    //QStringList printerList = QPrinterInfo::availablePrinterNames();
//    for(int i=0; i<printerList.count(); i++)
//    {
//        QString name = printerList[i];
//        ui->settingCbxPrinter->addItem(name);
//        if(!name.compare(printer))
//        {
//            ui->settingCbxPrinter->setCurrentIndex(i);
//        }
//    }

    _Init();
}

SettingForm::~SettingForm()
{
    delete ui;
}

void SettingForm::_Init()
{
    setWindowFlags(windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    setModal(true);
}

//void SettingForm::on_settingCbxPrinter_currentIndexChanged(const QString &text)
//{

//}

void SettingForm::on_settingBtnPrintTest_clicked()
{
    QString testStr("这是一个测试页看到此此页说明打印正常!\r\n\r\n\r\n");
    //FmPrinter::GetInstance().TestPrint(ConfigManger::GetInstance().GetPrinterName(), testStr);
}

void SettingForm::on_settingBtnSoundTest_clicked()
{
    QSound::play(QString("%1/wav/msg.wav").arg(QApplication::applicationDirPath()));
}

void SettingForm::on_settingCbxPrinter_activated(const QString &text)
{
    ConfigManger::GetInstance().SetPrinterName(text);
}

void SettingForm::on_pushButton_save_clicked()
{
    QString confilename = qApp->applicationDirPath() + "/" + CONFIG_NAME;

    if(ui->radioButton_auto->isChecked())
        QSettings(confilename, QSettings::IniFormat).setValue(INI_AUTOCONFIRM, 1);
    else
        QSettings(confilename, QSettings::IniFormat).setValue(INI_AUTOCONFIRM, 0);

    qDebug() << "input : " << (ui->comboBox_time->currentIndex() + 1) * 12;

    QSettings(confilename, QSettings::IniFormat).setValue(INI_DELEORDERTIMER, (ui->comboBox_time->currentIndex() + 1) * 12);

    this->hide();
}

void SettingForm::on_pushButton_quit_clicked()
{
    this->hide();
}
