﻿#include <QDebug>
#include "prtsettingform.h"
#include "ui_prtsettingform.h"
#include "base/System/GetPrinters.h"

#include <QFile>

#include "model/orderObject.h"
#include "printlib.h"

#include "preDefine.h"

#include "QsLog.h"

#include <QSettings>

PrtSettingForm::PrtSettingForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PrtSettingForm)
{
    ui->setupUi(this);

    //setWindowFlags(windowFlags() | Qt::FramelessWindowHint);
    //setAttribute(Qt::WA_TranslucentBackground);
    setModal(true);

    Init();
}
/****************
 * data 输出参数
 * type 打印机类型
 * name 打印机名称
 * label_name 标签打印机名称
 * llabel_wigth 标签纸宽
 * labe_high 标签纸高
 * label_type 标签打印类型
****************/
void PrtSettingForm::GetData(char *data, QString type, QString lptname, QString usbname, QString ip, QString name, QString label_name, QString label_wigth, QString labe_high, QString label_type, QString prtwit,
                             QString comname, QString bdl, QString dat, QString control, QString stop, QString jy)
{
    std::string ini;
    //ini.append(config.value("Printer/Name").toString());
    if(!name.isEmpty())
        ini.append(name.toLocal8Bit().data());
    else
        ini.append("Gprinter");
    ini.append("|");
    //ini.append(config.value("Printer/printType").toString());

    QLOG_INFO() << type;

    if(!type.isEmpty())
        ini.append(type.toUtf8().data());
    else
        ini.append("4");

    qDebug() << "\r\n" << ini.data();

    ini.append("|");
    //ini.append(config.value("Printer/PaperWidth").toString());
    if(!prtwit.isEmpty())
        ini.append(prtwit.toUtf8().data());
    else
        ini.append("80");
    //ini.append("40");
    ini.append("|");
    //ini.append(config.value("Printer/levlel").toString());
    ini.append("All");
    ini.append("|");
    //ini.append(config.value("Printer/parallel").toString());
    if(!lptname.isEmpty())
        ini.append(lptname.toUtf8().data());
    else
        ini.append("LPT1");
    //ini.append("3");
    ini.append("|");
    //ini.append(config.value("Printer/type").toString());
    if(!type.isEmpty())
        ini.append(type.toUtf8().data());
    else
        ini.append("4");

    qDebug() << "\r\n" << ini.data();
    //ini.append("4");
    ini.append("|");
    //ini.append(config.value("Printer/usb").toString());
    if(!usbname.isEmpty())
        ini.append(usbname.toUtf8().data());
    else
        ini.append("BYUSB-0");
    //ini.append("BYUSB3");
    ini.append("|");
    //ini.append(config.value("Printer/IP").toString());
    if(label_name.isEmpty())
        ini.append(ip.toUtf8().data());
    else
        ini.append("127.0.0.1");

    ini.append("|");
    //ini.append( config.value("Printer/Printlabel").toString());
    //ini.append("Xprinter");
    //ini.append("Gprinter");
    if(!label_name.isEmpty())
        ini.append(label_name.toLocal8Bit().data());
    else
        ini.append("123314");
    //ini.append("BTP-L520(E)");
    ini.append("|");
    //ini.append( config.value("Printer/LogDays").toString());
    ini.append("3");
    ini.append("|");
    //ini.append( config.value("Printer/wigth").toString());
    if(!label_wigth.isEmpty())
        ini.append(label_wigth.toUtf8().data());
    else
        ini.append("40");
    //ini.append("40");
    ini.append("|");
    //ini.append( config.value("Printer/high").toString());
    if(!labe_high.isEmpty())
        ini.append(labe_high.toUtf8().data());
    else
        ini.append("28");
    //ini.append("30");
    ini.append("|");
    //ini.append( config.value("Printer/speed").toString());
    ini.append("3");
    ini.append("|");
    //ini.append( config.value("Printer/crow").toString());
    ini.append("1");
    ini.append("|");
    //ini.append( config.value("Printer/label_type").toString());
    if(!label_type.isEmpty())
        ini.append(label_type.toUtf8().data());
    else
        ini.append("1");
    //ini.append("1");
    ini.append("|");
    //ini.append( config.value("Printer/clabel_parallrow").toString());
    ini.append("1");
    ini.append("|");
    //ini.append( config.value("Printer/label_usb").toString());
    ini.append("1");
    ini.append("|");
    //ini.append( config.value("Printer/label_ip").toString());
    ini.append("1");
    ini.append("|");
    //ini.append( config.value("Printer/label_ip").toString());
    ini.append("4");
    ini.append("|");
    //------------------------------

    QString coms = comname;
    QString tmpname = "0";

    if(coms.size() > 3)
    {
        tmpname = coms.right(coms.size() - 3);
    }
    ini.append(tmpname.toUtf8().data());
    ini.append("|");
    ini.append(bdl.toUtf8().data());
    ini.append("|");
    ini.append(dat.toUtf8().data());
    ini.append("|");
    ini.append(stop.toUtf8().data());
    ini.append("|");
    ini.append(jy.toUtf8().data());
    ini.append("|");
    ini.append(control.toUtf8().data());
    ini.append("|");
    strcpy(data, ini.c_str());
}

void PrtSettingForm::Init()
{
    QStringList list;

    BOOL flag= GetPrinters::HasPrintersName(list);

    qDebug() << "*****************flag" << flag;
//    qDebug() << "#################list : " << list;

    ui->comboBox_name->clear();
    ui->comboBox_lab_name->clear();

    ui->radioButton_net->setChecked(true);

    for(int i = 0; i < list.size(); ++ i)
    {
        ui->comboBox_name->addItem(list[i]);
        ui->comboBox_lab_name->addItem(list[i]);
    }
}

PrtSettingForm::~PrtSettingForm()
{
    delete ui;
}

void PrtSettingForm::on_pushButton_test_clicked()
{
//    if(ui->comboBox_name->currentText().isEmpty() && ui->lineEdit_name->text().isEmpty())
//        return ;

    QString name;

    if(!ui->lineEdit_name->text().isEmpty())
        name = ui->lineEdit_name->text();
    else
        name = ui->comboBox_name->currentText();

    QFile file;

    if(ui->comboBox_width->currentText().toInt() > 56)
        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINT80_TEMPLET);
    else
        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINT_TEMPLET);

    QLOG_INFO() << "+++++++++++++++++++++++++++" << file.fileName();

    if(!file.open(QFile::ReadOnly))
    {
        QLOG_INFO() << "open failed : " << file.fileName();
        return ;
    }

    QString content = QString::fromUtf8(file.readAll());
    file.close();

    QLOG_INFO() << content;

    QString error;

    OrderObject order;

    order.store_name = QString("\xE9\x9D\x9E\xE7\xA0\x81\xE4\xB8\x8A\xE6\xB5\xB7\xE5\xB8\x82\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE6\xB5\x8B\xE8\xAF\x95\xE5\xBA\x97");
    order.order_index = 999;
    order.code = "123456789";

    char arr[2048] = {0};

    QString type = "4";

    if(ui->radioButton_dev->isChecked())
        type = "4";
    else if(ui->radioButton_com->isChecked())
        type = "0";
    else if(ui->radioButton_lpt->isChecked())
        type = "1";
    else if(ui->radioButton_usb->isChecked())
        type = "2";
    else
        type = "3";

    QString session = DEFAULT_SESSION_COMDEF;

    if(ui->comboBox_prt_type->currentIndex() == 0)
        session = DEFAULT_SESSION_COMDEF;
    else
        session = DEFAULT_SESSION_OTHERCOMDEF;

    QString filename = qApp->applicationDirPath() + "/" + PREINTER_CONSS;

    QLOG_DEBUG() << "printf file name : " << filename;

    if(QString("0").compare(type) == 0)
    {
        QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "Baudrate", ui->comboBox_com_btl->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "com", ui->lineEdit_com->text());
        QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "DataBits", ui->comboBox_com_suw->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "StopBits", ui->comboBox_com_stop->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "Parity", ui->comboBox_com_jy->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "FlowControl", ui->comboBox_com_control->currentText());
    }

    QString labtype;

    if(ui->comboBox_zlj->currentIndex() == 1)
        labtype = "2";
    else
        labtype = "1";

    QLOG_INFO() << type;

    GetData(arr, type, ui->lineEdit_lpt->text(), ui->lineEdit_usb->text(), ui->lineEdit_ip->text(), name, ui->lineEdit_lab_name->text(), ui->lineEdit_lab_widgh->text(),
            ui->lineEdit_lab_high->text(), labtype, ui->comboBox_width->currentText(),
            ui->lineEdit_com->text(), ui->comboBox_com_btl->currentText(), ui->comboBox_com_suw->currentText(),
            ui->comboBox_com_control->currentText(), ui->comboBox_com_stop->currentText(), ui->comboBox_com_jy->currentText());

    QLOG_INFO() << "prt info" << arr;

    if(PrintLib::GetInstance().DoTestPrint(QByteArray(arr), content, &order, error))
    {
        QLOG_INFO() << "print success";
    }
    else
    {
        QLOG_INFO() << "print failed : " << error;
    }
}

void PrtSettingForm::on_btn_lab_test_clicked()
{
    if(ui->comboBox_lab_name->currentText().isEmpty() && ui->lineEdit_lab_name->text().isEmpty())
        return ;

    QString labelname;

    if(!ui->lineEdit_lab_name->text().isEmpty())
        labelname = ui->lineEdit_lab_name->text();
    else
        labelname = ui->comboBox_lab_name->currentText();

    QString name;

    if(!ui->lineEdit_name->text().isEmpty())
        name = ui->lineEdit_name->text();
    else
        name = ui->comboBox_name->currentText();

    OrderObject order;

    char arr[2048] = {0};

    QString type = "4";

    if(ui->radioButton_dev->isChecked())
        type = "3";
    else
        type = "4";

    QString labtype;

    if(ui->comboBox_zlj->currentIndex() == 1)
        labtype = "0";
    else
        labtype = "1";


    GetData(arr, type, ui->lineEdit_lpt->text(), ui->lineEdit_usb->text(),ui->lineEdit_ip->text(), name, labelname, ui->lineEdit_lab_widgh->text(),
            ui->lineEdit_lab_high->text(), labtype, ui->comboBox_width->currentText(),
            ui->lineEdit_com->text(), ui->comboBox_com_btl->currentText(), ui->comboBox_com_suw->currentText(),
            ui->comboBox_com_control->currentText(), ui->comboBox_com_stop->currentText(), ui->comboBox_com_jy->currentText());

    QLOG_INFO() << "prt info" << arr;

    if(PrintLib::GetInstance().DoTestLabelPrint(QByteArray(arr), &order))
    {
        QLOG_INFO() << "print success";
    }
    else
    {
        QLOG_INFO() << "print failed : ";
    }
}

void PrtSettingForm::on_pushButton_save_clicked()
{
    QString session;

    if(ui->comboBox_prt_type->currentIndex() == 0)
        session = DEFAULT_PRINTF_MAIN_SESSION;
    else
        session = DEFAULT_PRINTF_OTHER_SESSION;

    QString name;

    if(!ui->lineEdit_name->text().isEmpty())
        name = ui->lineEdit_name->text();
    else
        name = ui->comboBox_name->currentText();

    QString type = "4";

    if(ui->radioButton_dev->isChecked())
        type = "4";
    else if(ui->radioButton_com->isChecked())
        type = "0";
    else if(ui->radioButton_lpt->isChecked())
        type = "1";
    else if(ui->radioButton_usb->isChecked())
        type = "2";
    else
        type = "3";

    QString filename = qApp->applicationDirPath() + "/" + PREINTER_CONSS;

    QString tmpsession = DEFAULT_SESSION_COMDEF;

    if(ui->comboBox_prt_type->currentIndex() == 0)
        tmpsession = DEFAULT_SESSION_COMDEF;
    else
        tmpsession = DEFAULT_SESSION_OTHERCOMDEF;

    if(QString("0").compare(type) == 0)
    {
        QSettings(filename, QSettings::IniFormat).setValue(tmpsession + "/" + "Baudrate", ui->comboBox_com_btl->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(tmpsession + "/" + "com", ui->lineEdit_com->text());
        QSettings(filename, QSettings::IniFormat).setValue(tmpsession + "/" + "DataBits", ui->comboBox_com_suw->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(tmpsession + "/" + "StopBits", ui->comboBox_com_stop->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(tmpsession + "/" + "Parity", ui->comboBox_com_jy->currentText());
        QSettings(filename, QSettings::IniFormat).setValue(tmpsession + "/" + "FlowControl", ui->comboBox_com_control->currentText());
    }

    QString Wigth = ui->comboBox_width->currentText();
    QString Ip = ui->lineEdit_ip->text();

    if(Ip.isEmpty())
        Ip = "127.0.0.1";

    QLOG_DEBUG() << "printf file name : " << filename;

    if(Wigth.isEmpty())
        return ;

    if(name.isEmpty())
        name = "test01" ;

    QString confilename = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    QString tmpconfilename = qApp->applicationDirPath() + "/" + PREINTER_NEED;

    if(ui->checkBox_dbprt->isChecked())
        QSettings(tmpconfilename, QSettings::IniFormat).setValue(INI_NEEDPTR, 1);
    else
        QSettings(tmpconfilename, QSettings::IniFormat).setValue(INI_NEEDPTR, 0);

    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "usb", ui->lineEdit_usb->text());
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "parallel", ui->lineEdit_lpt->text());
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "printType", type);
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "type", type);
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "IP", Ip);
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "Name", name);
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "PaperWidth", Wigth);
}

void PrtSettingForm::on_btn_lab_save_clicked()
{
    QString labelname;

    QString session = DEFAULT_PRINTF_MAIN_SESSION;

    if(!ui->lineEdit_lab_name->text().isEmpty())
        labelname = ui->lineEdit_lab_name->text();
    else
        labelname = ui->comboBox_lab_name->currentText();

    QString labtype;

    if(ui->comboBox_zlj->currentIndex() == 1)
        labtype = "0";
    else
        labtype = "1";

    QString filename = qApp->applicationDirPath() + "/" + PREINTER_CONSS;
    //QString confilename = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    QString tmpfilename = qApp->applicationDirPath() + "/" + PREINTER_NEED;

    if(ui->checkBox_needlabel->isChecked())
        QSettings(tmpfilename, QSettings::IniFormat).setValue(INI_NEEDLABEL, 1);
    else
        QSettings(tmpfilename, QSettings::IniFormat).setValue(INI_NEEDLABEL, 0);

    QString wigth = ui->lineEdit_lab_widgh->text();
    QString high = ui->lineEdit_lab_high->text();

    if(wigth.isEmpty() || labelname.isEmpty() || high.isEmpty())
        return ;

    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "Printlabel", labelname);
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "wigth", wigth);
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "high", high);
    QSettings(filename, QSettings::IniFormat).setValue(session + "/" + "labeltype", labtype);
}
