﻿#include "pickupform.h"
#include "ui_pickupform.h"
#include "model/posorderpool.h"
#include <QKeyEvent>
#include "QsLog.h"

PickUpForm::PickUpForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PickUpForm)
{
    ui->setupUi(this);

    setWindowFlags(windowFlags() | Qt::FramelessWindowHint);
    //setAttribute(Qt::WA_TranslucentBackground);
    setModal(true);
}

PickUpForm::~PickUpForm()
{
    delete ui;
}

void PickUpForm::Initshow()
{
    ui->widgethead->show();
    ui->widgetmsg->show();
    ui->widgetinput->show();
    ui->widgetok->hide();
    ui->widgetrlt->hide();

    ui->lineEditpickupcode->show();
    ui->lineEditpickupcode->clear();
    ui->labelpickupwar->hide();
    ui->labelpickupmsg->show();
    ui->labelpickuphead->setText(QString::fromLocal8Bit("扫码取餐"));
    ui->labelpickupmsg->setText(QString::fromLocal8Bit("请扫码用户取餐码"));

    ui->lineEditpickupcode->setFocus();

    this->show();
}

void PickUpForm::keyPressEvent(QKeyEvent *e)
{
    QLOG_DEBUG() << "*****************:" << e->key();

    if(e->key() == Qt::Key_Enter || e->key() == Qt::Key_Return)  //判断是否是回车键按下
    {
        if(ui->lineEditpickupcode->text().isEmpty())
        {
            ui->labelpickuprltmsg->setText(QString::fromLocal8Bit("取餐码不能为空"));
            return ;
        }

        int status = DefaultOrder, refund_status = DefaultOrder;
        bool oldorder;

        if(PosOrderPool::GetOrderStatus(ui->lineEditpickupcode->text(), status, refund_status, oldorder) && refund_status != CompleteRefundOrder && status != CancelOrder)
        {
            QLOG_DEBUG() << "*****************:" << status << refund_status;

            if(refund_status == ApplicationRefundOrder || refund_status == ApplicationPartialRefundOrder  || refund_status == RefusedOrder)
            {
                ui->widgetrlt->show();
                ui->labelpickuprltmsg->setText(QString::fromLocal8Bit("已申请退单的订单\r\n请先拒绝退单再取餐!"));
                return ;
            }

            if(status == NewOrder && !(refund_status == ApplicationRefundOrder || refund_status == ApplicationPartialRefundOrder))
            {
                ui->widgetrlt->show();
                ui->labelpickuprltmsg->setText(QString::fromLocal8Bit("新订单\r\n请先接单再取餐!"));
                return ;
            }

            if((status == CompleteOrder || status == ServiceOrder) && !(refund_status == ApplicationRefundOrder || refund_status == ApplicationPartialRefundOrder))
            {
                ui->labelpickupmsg->setText(QString::fromLocal8Bit("订单可能已经被拿走\r\n请确认取餐用户是否正确!"));
                ui->labelpickupwar->show();
                ui->widgetok->show();
                ui->widgetmsg->show();
                ui->labelpickupwar->show();
                ui->widgetrlt->hide();
                ui->widgetinput->hide();
                return ;
            }

            this->hide();
            emit showorderinfo(ui->lineEditpickupcode->text());
        }
        else
        {
            QLOG_DEBUG() << "*****************:" << status << refund_status;
            ui->widgetrlt->show();
            ui->labelpickuprltmsg->setText(QString::fromLocal8Bit("订单不存在"));
        }

        return ;
    }

    return QDialog::keyPressEvent(e);
}

void PickUpForm::on_btnpickupclose_clicked()
{
    this->hide();
}

void PickUpForm::on_btnpickupok_clicked()
{
    this->hide();
}
