﻿#ifndef PICKFORM_H
#define PICKFORM_H

#include <QDialog>
#include "Model/deliverObject.h"
#include "Model/cashierObject.h"

namespace Ui {
class PickForm;
}

class PickForm : public QDialog
{
    Q_OBJECT

public:
    explicit PickForm(QWidget *parent = 0);
    ~PickForm();
    /* 功能:设置配送员信息
     * 参数:[1]订单编号[2]配送员信息
     * 返回:NULL
     * */
    void SetDeliversInfo(const QString& orderId, const QList<DeliverObject>& delivers);
    /* 功能:设置收银员信息
     * 参数:[1]收银员信息
     * 返回:NULL
     * */
    void SetCashiersInfo(const QList<CashierObject>& cashiers);

private:
    Ui::PickForm *ui;
    // 对应的订单编号
    QString m_orderId;
    // 记录该窗口的类型[0配送员选取][1收银员选取]
    int m_formType;
    // 记录窗口的按钮指针
    QList<QPushButton*> m_numBtnList;
    // 记录选取的配送员信息
    DeliverObject m_deliverObj;
    // 记录选取的收银员信息
    CashierObject m_cashierObj;
    // 记录上次选中的按钮
    QPushButton *m_prevBtn;

    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();
    /* 功能:初始化按钮
     * 参数:NULL
     * 返回:NULL
     * */
    void _InitBtn();

private slots:
    /* 功能:处理数字按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void onNumBtnToggled(bool bChecked);
    /* 功能:处理确定点击
     * 参数:NULL
     * 返回:NULL
     * */
    void on_pickBtnOk_clicked();

signals:
    /* 功能:处理订单
     * 参数:[1]操作动作名[2]订单编号[3]配送员信息
     * 返回:NULL
     * */
    void processOrder(const QString& operation, const QString& orderId, const DeliverObject& deliverObj);
    /* 功能:更新收银员信息
     * 参数:[1]收银员信息
     * 返回:NULL
     * */
    void updateCashier(const CashierObject& cashierObj);
};

#endif // PICKFORM_H
