
#ifndef ORDERTYPEFORM_H
#define ORDERTYPEFORM_H

#include <QWidget>
#include <QTableWidget>

#include "model/posorderpool.h"

namespace Ui {
class OrderTypeForm;
}

class OrderTypeForm : public QWidget
{
    Q_OBJECT

public:
    explicit OrderTypeForm(QWidget *parent = 0);
    ~OrderTypeForm();

    void mousePressEvent(QMouseEvent *e);

    void InitShow(QString order_id, int order_status, int refund_status, int order_type);

    void InitChannelShow(QString order_id, int order_status, int refund_status, int order_type, QString channel, int driver_status);

    QString order_id() const;

    int order_status() const;

    int refund_status() const;

    int GetOrderStatus() const;

    int order_type() const;

    void SetNameStyle(int status);
signals:
    void showOrderInfo(QString orderid, bool cpt);

private:
    Ui::OrderTypeForm *ui;
    QString _order_id;
    int _order_status;
    int _refund_status;
    int _order_type;
    int _drive_status;

};

#endif // ORDERTYPEFORM_H
