#include "ordertypeform.h"
#include "ui_ordertypeform.h"
#include <QTableWidget>
#include <QMouseEvent>

#include "QsLog.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "preDefine.h"


OrderTypeForm::OrderTypeForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::OrderTypeForm)
{
    ui->setupUi(this);
    _order_id = "";
    _order_status = DefaultOrder;
    _refund_status = DefaultOrder;
    _order_type = DefaultOrderType;
    _drive_status = 0;
}

OrderTypeForm::~OrderTypeForm()
{
    delete ui;
}


void OrderTypeForm::mousePressEvent(QMouseEvent *e)
{
    if(e->buttons()&Qt::LeftButton)
    {
        emit showOrderInfo(_order_id, false);
        return ;
    }
    return QWidget::mousePressEvent(e);
}

void OrderTypeForm::InitShow(QString order_id, int order_status, int refund_status, int order_type)
{
    _order_id = order_id;
    _order_status = order_status;
    _refund_status = refund_status;
    _order_type = order_type;

    if(_order_type == AppointmentTakeout || _order_type == AppointmentDining || _order_type == AppointmentInvite)
    {
        ui->ordertypelabel_type->setStyleSheet("#ordertypelabel_type{ border-image: url(:yy.png)}");
    }

    int ordertype = GetOrderStatus();

    SetNameStyle(ordertype);

}

void OrderTypeForm::InitChannelShow(QString order_id, int order_status, int refund_status, int order_type, QString channel, int driver_status)
{
    _order_id = order_id;
    _order_status = order_status;
    _refund_status = refund_status;
    _order_type = order_type;
    _drive_status = driver_status;

//    if(_order_type == AppointmentTakeout || _order_type == AppointmentDining || _order_type == AppointmentInvite)
//    {
//        ui->ordertypelabel_type->setStyleSheet("#ordertypelabel_type{ border-image: url(:yy.png)}");
//    }

//    if(!(_order_status == CancelOrder || _order_status == ServiceOrder || _order_status == RefusedOrder ||
//            _order_status == CompleteRefundOrder || _order_status == CompleteOrder))
//    {

    int ordertype = GetOrderStatus();

    QLOG_DEBUG() << "InitChannelShow ordertype:" << ordertype << _drive_status;

     if(_drive_status == 1 &&
             !(ordertype == CancelOrder || ordertype == ServiceOrder || ordertype ==  RefusedOrder || ordertype ==  CompleteRefundOrder || ordertype ==  CompleteOrder))
     {
            ui->ordertypelabel_type->setStyleSheet("#ordertypelabel_type{ border-image: url(:driver.png)}");
     }
     else if(_drive_status == 7 &&
             !(ordertype == CancelOrder || ordertype == ServiceOrder || ordertype ==  RefusedOrder || ordertype ==  CompleteRefundOrder || ordertype ==  CompleteOrder))
     {
         ui->ordertypelabel_type->setStyleSheet("#ordertypelabel_type{ border-image: url(:error.png)}");
     }
     else
     {
         ui->ordertypelabel_type->setStyleSheet("#ordertypelabel_type{ border-image: url(:tabBtn_normal.png)}");
     }

    ui->ordertypelabel_name->setText(channel);
    ui->ordertypelabel_name->adjustSize();
}

void OrderTypeForm::SetNameStyle(int status)
{
    switch (status) {
    case NewOrder:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE6\x96\xB0\xE8\xAE\xA2\xE5\x8D\x95"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(236,67,56,1);border-radius:4px;color:rgba(236,67,56,1);}");
        break;
    case FirmOrder:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE5\x88\xB6\xE4\xBD\x9C\xE4\xB8\xAD"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(25,166,119,1);border-radius:4px;color:rgba(25,166,119,1);}");
        break;
    case CancelOrder:
    case CompleteRefundOrder:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE5\xB7\xB2\xE9\x80\x80\xE5\x8D\x95"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(170,170,170,1);border-radius:4px;color:rgba(170,170,170,1);}");
        break;
    case ApprovalRefundOrder:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE9\x80\x80\xE6\xAC\xBE\xE4\xB8\xAD"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(25,108,166,1);border-radius:4px;color:rgba(25,108,166,1);}");
        break;
    case DispatchingOrder:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE9\x85\x8D\xE9\x80\x81\xE4\xB8\xAD"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(25,108,166,1);border-radius:4px;color:rgba(25,108,166,1);}");
        break;
    case InDevelopment:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE5\xAE\x8C\xE6\x88\x90\xE4\xB8\xAD"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(25,108,166,1);border-radius:4px;color:rgba(25,108,166,1);}");
        break;
    case ApplicationRefundOrder:
    case ApplicationPartialRefundOrder:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE9\x9C\x80\xE9\x80\x80\xE5\x8D\x95"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(236,67,56,1);border-radius:4px;color:rgba(236,67,56,1);}");
        break;
    case CompleteOrder:
    case ServiceOrder:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE5\xB7\xB2\xE5\xAE\x8C\xE6\x88\x90"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(170,170,170,1);border-radius:4px;color:rgba(170,170,170,1);}");
        break;
    default:
        ui->ordertypelabel_name->setText(QString::fromUtf8("\xE6\x97\xA0\xE6\x95\x88\xE5\x8D\x95"));
        ui->ordertypelabel_name->setStyleSheet("#ordertypelabel_name{border:1px solid rgba(170,170,170,1);border-radius:4px;color:rgba(170,170,170,1);}");
        break;
    }
}

int OrderTypeForm::order_type() const
{
    return _order_type;
}

int OrderTypeForm::refund_status() const
{
    return _refund_status;
}

int OrderTypeForm::GetOrderStatus() const
{
    if(_refund_status == ApplicationRefundOrder ||
            _refund_status == ApplicationPartialRefundOrder ||
           _refund_status == CompleteRefundOrder ||
            _refund_status == ApprovalRefundOrder)
        return _refund_status;
    else
        return _order_status;
}

int OrderTypeForm::order_status() const
{
    return _order_status;
}

QString OrderTypeForm::order_id() const
{
    return _order_id;
}
