#ifndef ORDEROPTFORM_H
#define ORDEROPTFORM_H

#include <QWidget>

namespace Ui {
class OrderOptForm;
}

class OrderOptForm : public QWidget
{
    Q_OBJECT

public:
    explicit OrderOptForm(QWidget *parent = 0);
    ~OrderOptForm();
    void InitShow(QString order_id, int order_status, int refund_status, int order_type);
    int GetOrderStatus(int order_status, int refund_status);
    QString opt() const;

    QString order_id() const;

    int order_type() const;
    bool getOrderOptAndName(int status, int order_type, QString &optname, QString &name);

    bool getOrderOpt2AndName(int status, int order_type, QString &optname, QString &name);

signals:
    void OptOrder(QString order_id, QString opt_name);

private slots:
    void on_btn_orderopt_clicked();

    void on_btn_orderopt2_clicked();

private:
    Ui::OrderOptForm *ui;

    QString _opt;

    QString _opt2;

    QString _order_id;

    int _order_type;

    bool _is_valid;

};

#endif // ORDEROPTFORM_H
