#include "orderoptform.h"
#include "ui_orderoptform.h"
#include "model/posorderpool.h"
#include "preDefine.h"
#include "QsLog.h"

OrderOptForm::OrderOptForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::OrderOptForm)
{
    ui->setupUi(this);

    _is_valid = false;
}

int OrderOptForm::GetOrderStatus(int order_status, int refund_status)
{
    if(refund_status == ApplicationRefundOrder ||
            refund_status == ApplicationPartialRefundOrder ||
           refund_status == CompleteRefundOrder ||
            refund_status == ApprovalRefundOrder)
        return refund_status;
    else
        return order_status;
}

QString OrderOptForm::opt() const
{
    return _opt;
}

QString OrderOptForm::order_id() const
{
    return _order_id;
}

int OrderOptForm::order_type() const
{
    return _order_type;
}

void OrderOptForm::InitShow(QString order_id, int order_status, int refund_status, int order_type)
{
    _order_id = order_id;
    _order_type = order_type;

    ui->horizontalSpacer->changeSize(0, 10);
    ui->btn_orderopt2->hide();
    QLOG_DEBUG() << "OrderOptForm::InitShow" << order_status << refund_status <<order_id <<order_type;

    int status = GetOrderStatus(order_status, refund_status);
    QLOG_DEBUG() << status;

    QString name;

    _is_valid = getOrderOptAndName(status, order_type, _opt, name);

    if(!_is_valid)
    {
         ui->btn_orderopt->hide();
    }
    else
    {
        //解决第三方订单已完成申请退款不显示同意按钮的bug，因为已完成的订单，默认将最后的操作按钮隐藏，所以需要将它展示出来
        if(ui->btn_orderopt->isHidden())
            ui->btn_orderopt->show();
        ui->btn_orderopt->setText(name);
    }

//    QString name2;

//    bool flag = getOrderOpt2AndName(status, order_type, _opt2, name2);

//    if(!flag)
//    {
//         ui->btn_orderopt2->hide();
//    }
//    else
//    {
//        ui->btn_orderopt2->setText(name2);
//        ui->btn_orderopt2->show();
//        ui->horizontalSpacer->changeSize(6, 10);
//    }

}

bool OrderOptForm::getOrderOpt2AndName(int status, int order_type, QString &optname, QString &name)
{
    switch (status) {
    case ApplicationRefundOrder:
    case ApplicationPartialRefundOrder:
        optname = OPERATION_REFUSEREFUND;
        name = QString::fromUtf8("\xE6\x8B\x92\xE7\xBB\x9D");
        ui->btn_orderopt2->setStyleSheet("#btn_orderopt2{ background:rgb(236, 67, 56);border:1px solid rgb(236, 67, 56); }");
        return true;
    default:
        return false;
    }
    return false;
}

bool OrderOptForm::getOrderOptAndName(int status, int order_type, QString &optname, QString &name)
{
    switch (status) {
    case NewOrder:
        optname = OPERATION_GETDELIVERS;
//        name = QString::fromUtf8("\xE5\x88\xB6\xE4\xBD\x9C");\xE6\x8E\xA5\xE5\x8D\x95
        name = QString::fromUtf8("\xE6\x8E\xA5\xE5\x8D\x95");
        ui->btn_orderopt->setStyleSheet("#btn_orderopt{ background:rgba(25, 166, 119);border:1px solid rgb(25, 166, 119); }");
        return true;
    case FirmOrder:
        if(order_type == TimelyTakeout || order_type == AppointmentTakeout)
        {
            optname =  OPERATION_SENDOUT;
            name = QString::fromUtf8("\xE9\x80\x81\xE5\x87\xBA");
        }
        else
        {
            optname = OPERATION_MAKEOVER;
            name = QString::fromUtf8("\xE5\x81\x9A\xE5\xAE\x8C");
        }
        ui->btn_orderopt->setStyleSheet("#btn_orderopt{ background:rgb(25, 108, 166);border:1px solid rgb(25, 108, 166); }");
        return true;
    case CancelOrder:
        return false;
    case DispatchingOrder:
        optname = OPERATION_COMPLETE;
        name = QString::fromUtf8("\xE5\xAE\x8C\xE6\x88\x90");
        ui->btn_orderopt->setStyleSheet("#btn_orderopt{ background:rgb(236, 67, 56);border:1px solid rgb(236, 67, 56); }");
        return true;
    case InDevelopment:
        optname = OPERATION_COMPLETE;
        name = QString::fromUtf8("\xE5\xAE\x8C\xE6\x88\x90");
        ui->btn_orderopt->setStyleSheet("#btn_orderopt{ background:rgb(236, 67, 56);border:1px solid rgb(236, 67, 56); }");
        return true;
    case ServiceOrder:
        return false;
    case CompleteOrder:
        return false;
    case ApplicationRefundOrder:
        optname = OPERATION_REFUNDORDER;
        name = QString::fromUtf8("\xE5\x90\x8C\xE6\x84\x8F");
        ui->btn_orderopt->setStyleSheet("#btn_orderopt{ background:rgb(25, 166, 119);border:1px solid rgb(25, 166, 119); }");
        return true;
    case ApplicationPartialRefundOrder:
        optname = OPERATION_REFUNDORDER;
        name = QString::fromUtf8("\xE5\x90\x8C\xE6\x84\x8F");
        ui->btn_orderopt->setStyleSheet("#btn_orderopt{ background:rgb(25, 166, 119);border:1px solid rgb(25, 166, 119); }");
        return true;
    default:
        return false;
    }
    return false;
}

OrderOptForm::~OrderOptForm()
{
    delete ui;
}

void OrderOptForm::on_btn_orderopt_clicked()
{
    emit OptOrder(_order_id, _opt);
}

void OrderOptForm::on_btn_orderopt2_clicked()
{
    emit OptOrder(_order_id, _opt2);
}
