#include "newpickupform.h"
#include "ui_newpickupform.h"
#include <QKeyEvent>
#include "QsLog.h"
#include "model/posorderpool.h"

NewPickupForm::NewPickupForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::NewPickupForm)
{
    ui->setupUi(this);
}

NewPickupForm::~NewPickupForm()
{
    delete ui;
}

void NewPickupForm::Initshow()
{
    ui->newpickuplabel_msg->clear();
    ui->newpickupline_code->clear();
    ui->newpickupline_code->setFocus();
    this->show();
}

void NewPickupForm::keyPressEvent(QKeyEvent *e)
{
    QLOG_DEBUG() << "*****************:" << e->key();

    if(e->key() == Qt::Key_Enter || e->key() == Qt::Key_Return)  //判断是否是回车键按下
    {
        ui->newpickuplabel_msg->clear();
        findOrder();
        return ;
    }

    return QWidget::keyPressEvent(e);
}

void NewPickupForm::findOrder()
{
    if(ui->newpickupline_code->text().isEmpty())
    {
        ui->newpickuplabel_msg->setText(QString::fromUtf8("\xE5\x8F\x96\xE9\xA4\x90\xE7\xA0\x81\xE4\xB8\x8D\xE8\x83\xBD\xE4\xB8\xBA\xE7\xA9\xBA"));
        return ;
    }

    int status = DefaultOrder, refund_status = DefaultOrder;
    bool oldorder;

    if(PosOrderPool::GetOrderStatus(ui->newpickupline_code->text(), status, refund_status, oldorder) && refund_status != CompleteRefundOrder && status != CancelOrder)
    {
        QLOG_DEBUG() << "*****************:" << status << refund_status;

        if(refund_status == ApplicationRefundOrder || refund_status == ApplicationPartialRefundOrder)
        {
            ui->newpickuplabel_msg->setText(QString::fromUtf8("\xE5\xB7\xB2\xE7\x94\xB3\xE8\xAF\xB7\xE9\x80\x80\xE5\x8D\x95\xE7\x9A\x84\xE8\xAE\xA2\xE5\x8D\x95,\xE8\xAF\xB7\xE5\x85\x88\xE6\x8B\x92\xE7\xBB\x9D\xE9\x80\x80\xE5\x8D\x95\xE5\x86\x8D\xE5\x8F\x96\xE9\xA4\x90\x21"));
            return ;
        }

        if(status == NewOrder && !(refund_status == ApplicationRefundOrder || refund_status == ApplicationPartialRefundOrder))
        {
            ui->newpickuplabel_msg->setText(QString::fromUtf8("\xE6\x96\xB0\xE8\xAE\xA2\xE5\x8D\x95,\xE8\xAF\xB7\xE5\x85\x88\xE6\x8E\xA5\xE5\x8D\x95\xE5\x86\x8D\xE5\x8F\x96\xE9\xA4\x90\x21"));
            return ;
        }

        if((status == CompleteOrder || status == ServiceOrder) && !(refund_status == ApplicationRefundOrder || refund_status == ApplicationPartialRefundOrder))
        {
            ui->newpickuplabel_msg->setText(QString::fromUtf8("\xE8\xAE\xA2\xE5\x8D\x95\xE5\x8F\xAF\xE8\x83\xBD\xE5\xB7\xB2\xE7\xBB\x8F\xE8\xA2\xAB\xE6\x8B\xBF\xE8\xB5\xB0,\xE8\xAF\xB7\xE7\xA1\xAE\xE8\xAE\xA4\xE5\x8F\x96\xE9\xA4\x90\xE7\x94\xA8\xE6\x88\xB7\xE6\x98\xAF\xE5\x90\xA6\xE6\xAD\xA3\xE7\xA1\xAE\x21"));
            return ;
        }

        OrderObject order;

        if(PosOrderPool::GetOrderObject(ui->newpickupline_code->text(), order))
        {
            if(order.order_type == TimelyTakeout || order.order_type == AppointmentTakeout)
            {
                //this->hide();
                emit showOrderInfo(ui->newpickupline_code->text(), false);
            }
            else
            {
                //this->hide();
                emit showOrderInfo(ui->newpickupline_code->text(), true);
            }

            return ;
        }

        ui->newpickuplabel_msg->setText(QString::fromUtf8("\xE8\x8E\xB7\xE5\x8F\x96\xE8\xAE\xA2\xE5\x8D\x95\xE5\xA4\xB1\xE8\xB4\xA5"));
        return ;

    }
    else
    {
        QLOG_DEBUG() << "*****************:" << status << refund_status;
        ui->newpickuplabel_msg->setText(QString::fromUtf8("\xE8\xAE\xA2\xE5\x8D\x95\xE4\xB8\x8D\xE5\xAD\x98\xE5\x9C\xA8"));
    }
}

void NewPickupForm::onNumClicked()
{
    QPushButton *btn = (QPushButton*)sender();

    QString num = btn->property("number").toString();

    if(!num.isEmpty())
    {
        ui->newpickupline_code->setText(QString(ui->newpickupline_code->text()).append(num));
    }
}

void NewPickupForm::on_newpickupbtn_del_clicked()
{
    ui->newpickuplabel_msg->clear();
    QString text = ui->newpickupline_code->text();
    ui->newpickupline_code->setText(text.left(text.length()-1));
}

void NewPickupForm::on_newpickupbtn_ok_clicked()
{
    ui->newpickuplabel_msg->clear();
    findOrder();
}

void NewPickupForm::on_newpickupbtn_clean_clicked()
{
    ui->newpickuplabel_msg->clear();
    ui->newpickupline_code->clear();
}
