#ifndef NEWMAINFORM_H
#define NEWMAINFORM_H

#include <QApplication>
#include <QWidget>
#include <QPushButton>
#include <QSettings>
#include <QSet>
#include <QString>
#include <QMap>
#include <QVector>
#include <QVariantMap>
#include <QListWidget>
#include <QTableWidgetItem>
#include <QButtonGroup>

#include "preDefine.h"
#include "model/posorderpool.h"
#include "view/mainbtn.h"
#include "view/alertForm.h"
#include "view/sysTray.h"
#include "view/padForm.h"
#include "view/newdetailform.h"
#include "view/prttypeform.h"
#include "view/newpickupform.h"
#include "view/newchangeshiftsform.h"


#define MAIN_ORDER  "order"
#define MAIN_REFUND "refund"
#define MAIN_SET    "set"
#define MAIN_SCAN   "scan"
#define MAIN_SHIFT  "shifts"

#define SET_PRT_DV  "dv"
#define SET_PRT_COM  "com"
#define SET_PRT_LPT  "lpt"
#define SET_PRT_NET  "net"

#define ORDER_TYPE_AUTO     "auto"
#define ORDER_TYPE_SELF     "self"
#define ORDER_TYPE_TIMEOUT  "timeout"

#define TYPE_NEEDREFUND     0
#define TYPE_REFUNDED       1
#define TYPE_ALL            2
#define TYPE_NEW            3
#define TYPE_MAKE           4
#define TYPE_SEND           5
#define TYPE_NAKEOVER       6
#define TYPE_OVER           7
#define TYPE_FUTURE         8

typedef struct
{
    int order_status;
    int refund_status;
} Order_Index;

namespace Ui {
class NewMainForm;
}

class NewMainForm : public QWidget
{
    Q_OBJECT

public:
    explicit NewMainForm(QWidget *parent = 0);
    ~NewMainForm();

    bool event(QEvent *e);

    void FullShow();

    void MyShow();
public slots:
    void OptOrder(QString orderid, QString optname);
    void onSetCurrentTime();
    void onSerachclicked();
    void onNumClicked(const QString &num);
    void onNumDelete();
    void onSearchResultItemClicked(QListWidgetItem *item);
    void onMainTableItemClicked(QTableWidgetItem *item);
    void onSerachOrder(const QString &key);
    void onPrtTypeChanged(int type);
    void onPickUpGetOrder(QString orderid, bool flag);
private slots:
    void on_newmainbtn_clicked();

    void on_classifybtn_clicked();

    void on_PrtSet_toggled(bool checked);

    void on_newmaincombx_prttype_currentIndexChanged(int index);

    void on_newmaintbwgt_tabBarClicked(int index);

    void on_newmainbtn_prtsave_clicked();

    void on_newmainbtn_prtadd_clicked();

    void on_newmainbtn_prtdel_clicked();

    void on_newmaincombx_name_currentIndexChanged(int index);

    void on_newmainvtn_ordersave_clicked();

    void on_newmainbtn_down_clicked();

    void on_newmainbtn_up_clicked();

    void on_newmainbtn_jump_clicked();

    void on_newmainbtn_hide_clicked();

    void on_newmainbtn_findclean_clicked();

    void on_newmainbtn_prttest_clicked();

    void on_userlab_logoutBtn_clicked();

private:
    Ui::NewMainForm *ui;
    //
    QSet<MainBtn *> _main_btn;
    //打印界面集合
    QSet<QWidget *> _prtsetting_widget;
    //分类器集合
    QSet<QPushButton *> _classify_set;
    //选中的分类
    QPushButton * _curr_check_btn;
    //订单索引
    QMap<QString, Order_Index> _order_indexs;
    //
    QVariantMap _storeinfo;
    //当前总页数
    int _curr_page_num;
    //当前页数
    int _curr_page;
    // 通知窗口
    AlertForm *_alertForm;
    // 时间定时器
    QTimer _timeTimer;
    // 置顶计数器
    int _raiseIndex;
    // 托盘图标
    SysTray m_tray;
    // 数字键盘窗口
    PadForm *_padForm;
    // 搜索结果窗口
    QListWidget *_resultForm;
    //打印机类型窗口
    PrtTypeForm *_prttypeForm;
    // 订单详情页面
    NewDetailForm *_detailForm;
    //打印类型
    QButtonGroup _btnGroup;
    //当前选中打印机类型
    int _prttype;
    //扫码取餐界面
    NewPickupForm *_pickform;

    //交接班打印界面
    NewChangeShiftsForm *_shiftform;

    //当前选中显示界面的类型
    int _type; //0是订单管理界面，1是退单管理界面

private:
    void InitOrderWidget(QString type);
    void InitSetWidget();
    void InitWidget(QString type);
    void InitClassify();
    void SetChecked(QPushButton *btn);
    void UpdateTableWidget(OrderObject &orderObject);
    void DeleteTableWidget(QString orderid);
    //初始化设置界面
    void InitSettingWidget(QString type);
    //初始化订单界面
    void InitOrderSetting();
    //初始化打印机界面
    void InitPrtSetting();
    //初始化用户设置界面
    void InitUserSetting();
    void InitPrtSettingWidget();
    void SettingWidgetWithConf(int prttype, QVariantMap &map);
    void InitPrtList();
    bool GetPrtConfig(QString &prtconfig);
    void getOrderChannelName(OrderObject *order, QString &channelname);
    void InsertTableWidget(OrderObject &orderObject);
    void GetOrderStatus(OrderObject &order, int &order_status);
    void InitTableWidget();
    bool ClassifyOrder(QString type);
    void ClassifyOrderWithOrderStatus(int order_status);
    void InitPageNum();
    void InitMainBtn();
    void SetMainBtnCheck(MainBtn *wgt);
    void ClassifyOrderWithOrderType();
    void onShowAlert(AlertForm::Type type, const QString &msg);
    void onSetStoreInfo(const QString &storeId);
    void onSetCashierInfo(const QString &cashierInfo);
    void onSetNetStatus(const QString &netstatus);
    void onHideAlert();
    void DoGetPrtSetting(QString curr);

    //更新界面的档口选择
    void onSetStalls(QVariantMap &map);
    void GetStallsText(QString stallsid, QString stallsname, QString &text);
    bool GetContext(QString &context);
    void InitScanWidget();
    void InitShiftWidget();
};

class NewMainFormDataProcess
{
public:
    friend class NewMainForm;

    static bool GetOrderInde(OrderObject &order, Order_Index &order_index)
    {
        order_index.order_status = order.status;
        order_index.refund_status = order.refund_status;
    }

private:
    static void SetOrderConfig(QString autoconf, QString timeout)
    {
        QString path = QString("%1/config.ini").arg(qApp->applicationDirPath());
        QSettings config(path, QSettings::IniFormat);
        config.setValue(INI_AUTOCONFIRM, autoconf);
        config.setValue(INI_DELEORDERTIMER, timeout);
    }

    static void SetOtherPrintNum(int prt_num)
    {
        QString path = QString("%1/needprt.ini").arg(qApp->applicationDirPath());
        QSettings config(path, QSettings::IniFormat);
        config.setValue("all/needothernum", prt_num);
    }

    static void SetPrintIniWithInde(int index, QMap<QString, QString> &map)
    {
        QString section = "Printer";
        QString comsection = "COMDEF";

        if(index == 2)
        {
             section = "OtherPrinter";
             comsection = "OTHERCOMDEF";
        }

        if(index > 2)
        {
            section = QString("OtherPrinter") + QString::number(index - 2 + 1);
            comsection = QString("OTHERCOMDEF") + QString::number(index - 2 + 1);
        }

        SetPrintIni(section, comsection, map);

    }

    static void SetPrintIni(QString section, QString comsection, QMap<QString, QString> &map)
    {  
        QString path = QString("%1/printer.ini").arg(qApp->applicationDirPath());
        QSettings config(path, QSettings::IniFormat);

        QMap<QString, QString>::iterator it;

        for (it = map.begin();it != map.end(); ++it)
        {
            if(map["type"].compare("0") == 0 || it.key().compare("type",Qt::CaseInsensitive) != 0)
                config.setValue(QString(comsection) + "/" + it.key(), it.value());
            config.setValue(QString(section) + "/" + it.key(), it.value());
        }
    }
};

#endif // NEWMAINFORM_H
