#ifndef NEWLOGINFORM_H
#define NEWLOGINFORM_H

#include <QDialog>
#include <QVariantMap>

#include "clickedLineEdit.h"
#include "alertForm.h"

namespace Ui {
class NewLoginForm;
}

class NewLoginForm : public QDialog
{
    Q_OBJECT

public:
    explicit NewLoginForm(QWidget *parent = 0);
    ~NewLoginForm();

    void showfull();

    virtual bool event(QEvent *e);
    void keyPressEvent(QKeyEvent *e);

    void onShowAlert(AlertForm::Type type, const QString &msg);
    void onHideAlert();
signals:
    void showfloat();
    void showmainform();
    void login(QVariantMap storeinfo);
    void focusChanged(QWidget* oldWidget, QWidget* widget);
    void nowFocus(QWidget* widget);

public slots:
    void GetCurrLineEdit();
    //bool eventFilter(QObject *watched, QEvent *e);
private slots:
    void on_pushButton_login_2_clicked();
    void number_btn_click();
    void SetStoreInfo();
    void on_pushButton_close_clicked();

private:
    Ui::NewLoginForm *ui;

    ClickedLineEdit *_curr_lineedit;

    bool is_login;

    // 通知窗口
    AlertForm *m_alertForm;

    //自动登录标志位
    int m_autologin;

    //记住密码标志位
    int m_rememberPwd;

    //是否需要软键盘标志位
    int m_softkeyboard;
};

#endif // NEWLOGINFORM_H
