﻿#include "newloginform.h"
#include "ui_newloginform.h"

#include "event/posevent.h"
#include "event/fmapplication.h"

#include "preDefine.h"
#include "view/frminput.h"

#include <QDebug>
#include <QVariantMap>
#include <QSettings>
#include <QDateTime>

#include <QsLog.h>

NewLoginForm::NewLoginForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NewLoginForm)
{
    ui->setupUi(this);

    is_login = false;

    ui->label_logotitle_2->setText(QString::fromLocal8Bit("非码SaaS点餐小程序门店管理"));

    //输入框中进行正则表达式的过滤
    QRegExp rx("^[A-Za-z0-9]+$");
    QRegExpValidator *pRevalidotor = new QRegExpValidator(rx, this);
    ui->lineEdit_partnerid_2->setValidator(pRevalidotor);
    ui->lineEdit_storeid_2->setValidator(pRevalidotor);
    ui->lineEdit_account_2->setValidator(pRevalidotor);
    ui->lineEdit_pwd_2->setValidator(pRevalidotor);

    frmInput::Instance()->Init("control", "black", 10, 10);

    connect(ui->lineEdit_account_2, &ClickedLineEdit::clicked, this, &NewLoginForm::GetCurrLineEdit);
    connect(ui->lineEdit_partnerid_2, &ClickedLineEdit::clicked, this, &NewLoginForm::GetCurrLineEdit);
    connect(ui->lineEdit_pwd_2, &ClickedLineEdit::clicked, this, &NewLoginForm::GetCurrLineEdit);
//    connect(ui->lineEdit_posno_2, &ClickedLineEdit::clicked, this, &NewLoginForm::GetCurrLineEdit);
    connect(ui->lineEdit_storeid_2, &ClickedLineEdit::clicked, this, &NewLoginForm::GetCurrLineEdit);

//    connect(ui->pushButton_10, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_11, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_12, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_13, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_14, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_15, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_16, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_17, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_18, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_19, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_clear_2, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
//    connect(ui->pushButton_del_2, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);

    connect(ui->pushButton_num0, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num1, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num2, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num3, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num4, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num5, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num6, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num7, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num8, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_num9, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_clearBtn, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(ui->pushButton_delBtn, &QPushButton::clicked, this, &NewLoginForm::number_btn_click);
    connect(this, &NewLoginForm::focusChanged, frmInput::Instance(),&frmInput::focusChanged);
    connect(this, &NewLoginForm::nowFocus, frmInput::Instance(),&frmInput::nowFocus);

    _curr_lineedit = ui->lineEdit_partnerid_2;
    _curr_lineedit->setFocus();

    //frmInput::Instance()->focusChanged(this, _curr_lineedit);

    setWindowFlags(Qt::FramelessWindowHint);


    m_alertForm = new AlertForm(this);

    QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    m_autologin = QSettings(configfile, QSettings::IniFormat).value(INI_AUTOLOGIN, 0).toInt();
    m_rememberPwd = QSettings(configfile, QSettings::IniFormat).value(INI_REMEMBERPWD, 0).toInt();
    m_softkeyboard = QSettings(configfile, QSettings::IniFormat).value(INI_SOFTKEYBOARD, 0).toInt();

    if(m_autologin)
        ui->checkBox_2->setChecked(true);
    if(m_rememberPwd)
        ui->checkBox_rememberPwd->setChecked(true);
    if(m_softkeyboard)
        emit nowFocus(ui->lineEdit_partnerid_2);

    FMApplication::subscibeEvent(this, PosEvent::s_login_status);
    FMApplication::subscibeEvent(this, PosEvent::s_opt_status);
    FMApplication::subscibeEvent(this, PosEvent::s_show_login);

    ui->lineEdit_partnerid_2->installEventFilter(this);
    ui->lineEdit_account_2->installEventFilter(this);
    ui->lineEdit_pwd_2->installEventFilter(this);
    ui->lineEdit_storeid_2->installEventFilter(this);
}

void NewLoginForm::onHideAlert()
{
    m_alertForm->hide();
}

void NewLoginForm::onShowAlert(AlertForm::Type type, const QString &msg)
{

    if(this->isVisible())
    {
        m_alertForm->SetContent(type, msg);
        m_alertForm->show();
    }
}

NewLoginForm::~NewLoginForm()
{
    delete ui;
}

void NewLoginForm::SetStoreInfo()
{
    QString configfile = qApp->applicationDirPath() + "/" + STOREINFO_NAME;

    QString storeid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_STOREID).toString();
    QString partnerid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_PARNETID).toString();
    QString userid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_USERID).toString();
    QString pwd = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_PWD).toString();
//    QString stationid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_STATIONIID).toString();

    if(storeid.isEmpty() || partnerid.isEmpty() || userid.isEmpty() || pwd.isEmpty() /*|| stationid.isEmpty()*/)
        return ;

    ui->lineEdit_partnerid_2->setText(partnerid);
    ui->lineEdit_storeid_2->setText(storeid);
//    ui->lineEdit_posno_2->setText(stationid);
    ui->lineEdit_account_2->setText(userid);

    if(ui->checkBox_rememberPwd->isChecked())
        ui->lineEdit_pwd_2->setText(pwd);
}

void NewLoginForm::showfull()
{
    if(!is_login)
    {
        SetStoreInfo();
        this->showFullScreen();
        if(m_autologin == 1)
            on_pushButton_login_2_clicked();
        return ;
    }

    this->hide();
    //emit showmainform();
    DEFAULTPOSTEVENT(PosEvent::s_show_mainform, "");
}

bool NewLoginForm::event(QEvent *e)
{

    if(e->type() == PosEvent::s_opt_status)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_ORDERSTATUS) && value[EVENT_KEY_ORDERSTATUS].toInt() == 0)
        {
            if(!this->isHidden())
                onShowAlert(AlertForm::LOADING, value[EVENT_KEY_MSG].toString());
            return true;
        }

        if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == false)
        {
            QLOG_INFO() << value[EVENT_KEY_MSG].toString();
            if(!this->isHidden())
                onShowAlert(AlertForm::ERROR, value[EVENT_KEY_MSG].toString());
        }
        else if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == true)
        {
            if(!this->isHidden())
                onShowAlert(AlertForm::SUCCESS, value[EVENT_KEY_MSG].toString());
        }
        return true;
    }

    if(e->type() == PosEvent::s_show_login)
    {
        this->showfull();
        return true;
    }

    if(e->type() == PosEvent::s_login_status)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == false)
        {
            QLOG_INFO() << value[EVENT_KEY_MSG].toString();
            if(!this->isHidden())
                onShowAlert(AlertForm::ERROR, value[EVENT_KEY_MSG].toString());
        }
        else if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == true)
        {
            this->hide();
            onHideAlert();
            is_login = true;
            //emit showmainform();
            DEFAULTPOSTEVENT(PosEvent::s_show_mainform, "");
        }
        return true;
    }

    return QDialog::event(e);
}

void NewLoginForm::keyPressEvent(QKeyEvent *e)
{
    QLOG_DEBUG() << "*****************:" << e->key();
    if(e->key() == Qt::Key_Enter || e->key() == Qt::Key_Return) {
        on_pushButton_login_2_clicked();
        return;
    }
    return QWidget::keyPressEvent(e);
}

void NewLoginForm::GetCurrLineEdit()
{
    if(m_softkeyboard)
    {
//        emit focusChanged(_curr_lineedit, qobject_cast<ClickedLineEdit*>(sender()));
        //发送焦点在哪个位置的行编辑器的信号
        emit nowFocus(qobject_cast<ClickedLineEdit*>(sender()));
    }

    qDebug() << qobject_cast<ClickedLineEdit*>(sender());
    qDebug() << _curr_lineedit;
    _curr_lineedit = qobject_cast<ClickedLineEdit*>(sender());
}

//bool NewLoginForm::eventFilter(QObject *watched, QEvent *e)
//{
//    if(watched == ui->lineEdit_partnerid_2)
//    {
//        if(e->type() == QEvent::FocusIn)
//        {
//            frmInput::Instance()->Init("control", "black", 10, 10);
//            return true;
//        }
//    }
//    return QWidget::eventFilter(watched,e);
//}

void NewLoginForm::on_pushButton_login_2_clicked()
{
    QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    if(ui->checkBox_2->isChecked())
        QSettings(configfile, QSettings::IniFormat).setValue(INI_AUTOLOGIN, 1);
    else
        QSettings(configfile, QSettings::IniFormat).setValue(INI_AUTOLOGIN, 0);

    if(ui->checkBox_rememberPwd->isChecked())
        QSettings(configfile, QSettings::IniFormat).setValue(INI_REMEMBERPWD, 1);
    else
        QSettings(configfile, QSettings::IniFormat).setValue(INI_REMEMBERPWD, 0);
    QLOG_DEBUG() << "configfile" << configfile;

    QVariantMap map;

    if(ui->lineEdit_pwd_2->text().isEmpty())
    {
        onShowAlert(AlertForm::ERROR, QString::fromLocal8Bit("商户号/门店号/POS编号/账号/密码均不能为空"));
        return;
    }

    if(ui->lineEdit_account_2->text().isEmpty() ||
       ui->lineEdit_pwd_2->text().isEmpty() ||
       ui->lineEdit_partnerid_2->text().isEmpty() ||
       /*ui->lineEdit_posno_2->text().isEmpty() ||*/
       ui->lineEdit_storeid_2->text().isEmpty() )
    {
        onShowAlert(AlertForm::ERROR, QString::fromLocal8Bit("商户号/门店号/POS编号/账号/密码均不能为空"));
        return ;
    }



    map.insert(JSON_STOREID, ui->lineEdit_storeid_2->text());
//    map.insert(JSON_STATIONID, ui->lineEdit_posno_2->text());
    map.insert(JSON_KEY_USERID, ui->lineEdit_account_2->text());
    map.insert(JSON_KEY_PWD, ui->lineEdit_pwd_2->text());
    map.insert(JSON_KEY_PARTNERID, ui->lineEdit_partnerid_2->text());

    QSettings *configIniRead = new QSettings(configfile, QSettings::IniFormat);
    QString loginTime = configIniRead->value("base/loginTime").toString();
    QDateTime loginDateTime = QDateTime::fromString(loginTime, "yyyy-MM-dd hh:mm");
    int i_loginDateTime = loginDateTime.toTime_t();

    QDateTime currentTime = QDateTime::currentDateTime();
    int i_currentTime = currentTime.toTime_t();

    if(loginTime == "") {
        configIniRead->setValue("base/loginTime", QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm"));
    } else {
        if(currentTime.toString("yyyy-MM-dd") == loginDateTime.toString("yyyy-MM-dd")) {

        } else {
            configIniRead->setValue("base/loginTime", QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm"));
        }
    }

    map.insert(JSON_KEY_TIMESTAMP, QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm"));

    POSTEVENTTYPE(PosEvent::s_login_storeinfo, map, QVariantMap);
}

void NewLoginForm::number_btn_click()
{
    QPushButton *btn = qobject_cast<QPushButton*>(sender());

//    if(btn == ui->pushButton_clear_2)
    if(btn == ui->pushButton_clearBtn)
    {
//        _curr_lineedit->clear();
        //将清空按钮换成软键盘按钮
       if(m_softkeyboard)
       {
           emit focusChanged(ui->lineEdit_partnerid_2, ui->lineEdit_pwd_2);
       }
    }
//    else if(btn == ui->pushButton_del_2)
    else if(btn == ui->pushButton_delBtn)
    {
        QString text = _curr_lineedit->text();

        _curr_lineedit->setText(text.left(text.size() - 1));

    }
    else
    {
        _curr_lineedit->setText(_curr_lineedit->text() + btn->property("number").toString());
    }
}


void NewLoginForm::on_pushButton_close_clicked()
{
    this->hide();
    //emit showfloat();
    DEFAULTPOSTEVENT(PosEvent::s_show_float, "");
    frmInput::Instance()->hide();
}

