#ifndef NEWFLOATFORM_H
#define NEWFLOATFORM_H

#include <QDialog>
#include <QMouseEvent>
#include <QTimer>
#include <QSize>
#include <QPropertyAnimation>
#include <QSound>

namespace Ui {
class NewFloatForm;
}

class NewFloatForm : public QDialog
{
    Q_OBJECT

public:
    explicit NewFloatForm(QWidget *parent = 0);
    ~NewFloatForm();

    virtual bool event(QEvent *e);
protected:
    void mouseMoveEvent(QMouseEvent * event);
    void mousePressEvent(QMouseEvent * event);
    void mouseReleaseEvent(QMouseEvent * event);

private:
    QSize desktopSize;
    Ui::NewFloatForm *ui;
    // 记录左键按下去后是否移动过
    bool m_bMouseMove;
    // 记录左键是否按下去
    bool m_bMousePress;
    // 拖动前鼠标坐标
    QPoint m_lastMousePos;
    // 此次拖动一共移动的距离
    QPoint m_absMove;
    // 记录正常状态图片的大小
    QSize m_imgNormalSize;
    // 记录提示状态图片的大小
    QSize m_imgRemindSize;
    // 记录是否正在提示
    bool m_bReminding;
    // 闪烁动画
    QPropertyAnimation m_animation;
    // 记录音频文件
    QString m_remindWav;
    // 声音的间隔
    int m_wavPlayInterval;
    // 置顶定时器
    QTimer m_raiseTimer;
    QTimer m_remindTimer;
    //长按悬浮框计时定时器
    QTimer m_clickTimer;
    //计时1s加1
    int m_num;
    // 是否登录成功
    bool m_is_login;
    //停止标识
    bool m_play_flag;
    //
    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();
    /* 功能:界面展示
     * 参数:[1] -1界面展示; 0新订单; 1新退单
     * 返回:NULL
     * */
    void InitWidget(int flag = -1);
private slots:
    /* 功能:闪烁
     * 参数:NULL
     * 返回:NULL
     * */
    void _Blink();
    /* 功能:声音
     * 参数:NULL
     * 返回:NULL
     * */
    void _PlayWav();
    //udp广播声音播控
    void _UdpRadio(QString songName, int type, int time);
    //悬浮框大小自适应不同屏幕分辨率
    void resetGrid(QDialog *widget,double factorx,double factory);

    void OnUpdate();

signals:
    /* 功能:通知主窗口显示
     * 参数:NULL
     * 返回:NULL
     * */
    void showMainForm();

public slots:
    /* 功能:开启提示
     * 参数:[1]提示类型 0新订单1申请退款
     * 返回:NULL
     * */
    void onStartRemind(int type);
    /* 功能:关闭提示
     * 参数:NULL
     * 返回:NULL
     * */
    void onStopRemind();
    /* 功能:显示窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void onShow();
};

#endif // NEWFLOATFORM_H
