﻿#include "newfloatform.h"
#include "ui_newfloatform.h"
#include <QPixmap>
#include "base/config/configManger.h"
#include "preDefine.h"
#include "QsLog.h"
#include <QProcess>
#include <QThread>
#include <QHostInfo>
#include <QUdpSocket>
#include <QByteArray>
#include <QJsonObject>
#include <QJsonDocument>
#include <QDesktopWidget>
#include <QPoint>

#include "event/fmapplication.h"
#include "event/posevent.h"
#include "model/posorderpool.h"


extern QThread  workThread;

NewFloatForm::NewFloatForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NewFloatForm)
{
    ui->setupUi(this);

    m_is_login = false;

    FMApplication::subscibeEvent(this, PosEvent::s_change_order);
    FMApplication::subscibeEvent(this, PosEvent::s_show_float);
    FMApplication::subscibeEvent(this, PosEvent::s_delete_order);
    FMApplication::subscibeEvent(this, PosEvent::s_login_status);
    FMApplication::subscibeEvent(this, PosEvent::s_network_outtime);
    FMApplication::subscibeEvent(this, PosEvent::s_pickuporder_remind);
    FMApplication::subscibeEvent(this, PosEvent::s_driver_cancel_order);
	FMApplication::subscibeEvent(this, PosEvent::s_hide_float);

    m_bReminding = false;

    m_num = 0;

    QPixmap imgNormal(":loginlogin.png");
    m_imgNormalSize = imgNormal.size();
    QPixmap imgRemind(":loginlogin.png");
    m_imgRemindSize = imgRemind.size();

    m_animation.setTargetObject(this);
    m_animation.setPropertyName("windowOpacity");
    m_animation.setDuration(ConfigManger::GetInstance().GetBlinkInterval());
    m_animation.setEasingCurve(QEasingCurve::InOutSine);
    m_raiseTimer.setInterval(2000);
    connect(&m_raiseTimer, &QTimer::timeout, this, &NewFloatForm::raise);
    connect(&m_clickTimer, &QTimer::timeout, this, &NewFloatForm::OnUpdate);
//    desktopSize= QApplication::desktop()->screenGeometry().size();
//    desktopSize-= QSize(144, 48);

    //界面数据初始化
    ui->label_front_newnum->setText("0");
    ui->label_back_newnum->setText("0");
    ui->label_front_refundnum->setText("0");
    ui->label_back_refundnum->setText("0");

    //设置拖动图层透明度
    ui->widget_touch->setWindowOpacity(0.1);

    _Init();
}

NewFloatForm::~NewFloatForm()
{
    delete ui;
}

void NewFloatForm::InitWidget(int flag)
{
    if(flag == -1)
    {
        if(m_is_login)
        {
            ui->widget_base_frame->show();
            ui->widget_back_login->hide();
            ui->widget_front_login->hide();
            ui->widget_back_synshow->hide();
            ui->widget_front_synshow->hide();

        }
        else
        {
            ui->widget_base_frame->show();
            ui->widget_front_login->hide();
            ui->widget_back_login->hide();
            ui->widget_front_synshow->hide();
            ui->widget_back_synshow->hide();
        }
        return ;
    }
}

bool NewFloatForm::event(QEvent *e)
{
    if(e->type() == PosEvent::s_change_order)
    {
        QString orderid;

        GETEVENTINFO(orderid,e,QString);

        int refundstatus, orderstatus, ordertype;
        bool oldorder;

        int tk_new = 0, tk_make = 0, tk_send = 0, tk_refund = 0;
        int self_new = 0, self_make = 0, self_refund = 0;

        PosOrderPool::GetOrderNum(tk_new, tk_make, tk_send, tk_refund, self_new, self_make, self_refund);

        QLOG_DEBUG() << "tk_new" << tk_new << "tk_make" << tk_make << "tk_send" << tk_send << "self_new" << self_new << "self_make" << self_make;
        QLOG_DEBUG() << "tk_refund" << tk_refund << "self_refund" << self_refund;

        ui->label_back_newnum->setText(QString::number(tk_new + self_new + tk_make + self_make));
        ui->label_back_refundnum->setText(QString::number(self_refund + tk_refund));

        ui->label_front_newnum->setText(QString::number(tk_new + self_new + tk_make + self_make));
        ui->label_front_refundnum->setText(QString::number(self_refund + tk_refund));

        if(!PosOrderPool::GetOrderStatusAndOrderType(orderid, orderstatus, refundstatus, ordertype, oldorder))
            return true;
        //预约单不在提醒
        if(ordertype == AppointmentTakeout || ordertype == AppointmentDining || ordertype == AppointmentInvite)
            return true;

        QLOG_DEBUG() << "input : " << orderid << orderstatus << refundstatus << oldorder;

        QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
        QString autoconf = QSettings(configfile, QSettings::IniFormat).value(INI_AUTOCONFIRM, "0").toString();

        if(!oldorder && ((orderstatus == NewOrder && autoconf.toInt() == 0) || (orderstatus == FirmOrder && autoconf.toInt() == 1)) &&
                refundstatus != ApplicationRefundOrder && refundstatus != ApplicationPartialRefundOrder && refundstatus != RefusingRefundOrder)
        {
            //m_play_flag = false;
//            if(ui->widget_back_synshow->isHidden())
//                ui->widget_back_synshow->show();
            onStartRemind(0);
            return true;
        }

        if((refundstatus == ApplicationRefundOrder || refundstatus == ApplicationPartialRefundOrder))
        {
            //m_play_flag = false;
//            if(ui->widget_back_synshow->isHidden())
//                ui->widget_back_synshow->show();
            onStartRemind(1);
            return true;
        }

        return true;
     }

     if(e->type() == PosEvent::s_show_float)
     {
         this->onShow();
         return true;
     }

     if(e->type() == PosEvent::s_network_outtime)
     {
//        if(!this->isHidden())
//        {
        QVariantMap value;
        GETEVENTINFO(value,e,QVariantMap);
        if(value.contains(EVENT_KEY_NETWORKSTATUS) && value[EVENT_KEY_NETWORKSTATUS].toBool() == true)
        {
            this->onStopRemind();
        }
        else
        {
            //m_play_flag = true;
//            if(ui->widget_back_synshow->isHidden())
//                ui->widget_back_synshow->show();
//            QSize tmpdesktopSize= QApplication::desktop()->screenGeometry().size();
//            tmpdesktopSize-= QSize(ui->widget_base->width(), ui->widget_base->height());
            QLOG_DEBUG() << "table show1------------------------------" ;
//            if(ui->widget_back_synshow->isHidden() && m_is_login && ui->widget_front_synshow->isHidden())
//            {
//                QLOG_DEBUG() << "table show2------------------------------" ;
//                if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
//                {
//                    QLOG_DEBUG() << "table show3------------------------------" ;
//                    ui->widget_front_synshow->show();
//                } else {
//                    QLOG_DEBUG() << "table show4------------------------------" ;
//                    ui->widget_back_synshow->show();
//                }
//                if(!ui->widget_base_frame->isHidden())
//                    ui->widget_base_frame->hide();
//            }
//            else if(!ui->widget_back_synshow->isHidden() && m_is_login)
//            {
//                QLOG_DEBUG() << "table show5------------------------------" ;
////                ui->widget_back_synshow->hide();
//                if(ui->widget_base_frame->isHidden())
//                    ui->widget_base_frame->show();
//            } else if(!ui->widget_front_synshow->isHidden() && m_is_login) {
//                QLOG_DEBUG() << "table show6------------------------------" ;
////                ui->widget_front_synshow->hide();
//                if(ui->widget_base_frame->isHidden())
//                    ui->widget_base_frame->show();
//            }

            onStartRemind(2);
        }
//        }

        return true;
     }

     if(e->type() == PosEvent::s_delete_order)
     {
         int tk_new = 0, tk_make = 0, tk_send = 0, tk_refund = 0;
         int self_new = 0, self_make = 0, self_refund = 0;

         PosOrderPool::GetOrderNum(tk_new, tk_make, tk_send, tk_refund, self_new, self_make, self_refund);

         QLOG_DEBUG() << "tk_new" << tk_new << "tk_make" << tk_make << "tk_send" << tk_send << "self_new" << self_new << "self_make" << self_make;
         QLOG_DEBUG() << "tk_refund" << tk_refund << "self_refund" << self_refund;

         ui->label_back_newnum->setText(QString::number(tk_new + self_new + tk_make + self_make));
         ui->label_back_refundnum->setText(QString::number(self_refund + tk_refund));

         ui->label_front_newnum->setText(QString::number(tk_new + self_new + tk_make + self_make));
         ui->label_front_refundnum->setText(QString::number(self_refund + tk_refund));

         return true;
     }

     if(e->type() == PosEvent::s_login_status)
     {
         QVariantMap value;

         GETEVENTINFO(value,e,QVariantMap);

         if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == true)
         {
             m_is_login = true;
         }
         return true;
     }
     //预约单提醒
     if(e->type() == PosEvent::s_pickuporder_remind)
     {
         QString orderid;

         GETEVENTINFO(orderid,e,QString);

         QLOG_DEBUG() << "pickuporderremind : " << orderid;

         //m_play_flag = false;
//         if(ui->widget_back_synshow->isHidden())
//             ui->widget_back_synshow->show();
         onStartRemind(0);
         return true;
     }

     if(e->type() == PosEvent::s_driver_cancel_order)
     {
         onStartRemind(3);
         return true;
     }
	 if(e->type() == PosEvent::s_hide_float)
     {
         QLOG_INFO() << "rpa hide float form";
         this->hide();
         return true;
     }

    return QWidget::event(e);
}

void NewFloatForm::mouseMoveEvent(QMouseEvent *event)
{
    if ((event->buttons()==Qt::LeftButton) && m_bMousePress)
    {
        QSize tmpdesktopSize= QApplication::desktop()->screenGeometry().size();
        if(!m_is_login)
            tmpdesktopSize-= QSize(ui->widget_base->width(), ui->widget_base->height());
        else
            tmpdesktopSize-= QSize(this->width(), this->height());


        QPoint moveAmount = event->globalPos() - m_lastMousePos;
        m_absMove += moveAmount;
        int x=0,y=0;
        x=pos().x()+moveAmount.x();
        y=pos().y()+moveAmount.y();
        qDebug() << "----------------------1010------------------"  <<pos().x() << pos().y() << x << y;

        if(ui->widget_back_synshow->isHidden()) {
            if(x>tmpdesktopSize.width()+ui->widget_base->width()){x=tmpdesktopSize.width()+ui->widget_base->width();}
        } else {
            if(x>tmpdesktopSize.width()){x=tmpdesktopSize.width();}
        }

        if(!ui->widget_front_synshow->isHidden()) {
            if(x<0){x=0;}
        } else {
            if(x<-ui->widget_base->width()){x=-ui->widget_base->width();}
        }

        if(y>tmpdesktopSize.height()){y=tmpdesktopSize.height();}
        if(y<0){y=0;}
        move(x,y);
        m_lastMousePos = event->globalPos();
        m_bMouseMove = true;
    }
    m_clickTimer.stop();
    m_num = 0;
}

void NewFloatForm::mousePressEvent(QMouseEvent *event)
{
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = true;
        m_lastMousePos = event->globalPos();
        m_absMove = QPoint(0,0);
        m_clickTimer.start(200);
    }
}

void NewFloatForm::mouseReleaseEvent(QMouseEvent *event)
{
    qDebug() << "-------------2020------------------" << event->globalPos() << pos();
    QSize tmpdesktopSize= QApplication::desktop()->screenGeometry().size();
    tmpdesktopSize-= QSize(ui->widget_base->width(), ui->widget_base->height());
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = false;
    }

    int x = m_absMove.x();
    int y = m_absMove.y();

    if(!m_bMouseMove || (((x>-10)&&(x<10))&&((y>-10)&&(y<10))))
    {
        //qDebug() << "x:" << event->x() << "y:" << event->y();
        qDebug() << "-----------------30---------------------------" <<m_num;

        if(event->x() > (ui->widget_base->width())*2 || !m_is_login || event->x() < ui->widget_base->width())
        {
            hide();
            m_raiseTimer.stop();

            if(m_bReminding)
            {
                this->onStopRemind();
            }
            DEFAULTPOSTEVENT(PosEvent::s_show_login, "");
        }
        else if(m_num > 0)
        {
            hide();
            m_raiseTimer.stop();


            if(m_bReminding)
            {
                this->onStopRemind();
            }
            DEFAULTPOSTEVENT(PosEvent::s_show_pickup, "");

        }
        else
        {
            if(ui->widget_back_synshow->isHidden() && m_is_login && ui->widget_front_synshow->isHidden())
            {
                if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
                {
                    ui->widget_front_synshow->show();
                } else {
                    ui->widget_back_synshow->show();
                }
                if(!ui->widget_base_frame->isHidden())
                    ui->widget_base_frame->hide();
            }
            else if(!ui->widget_back_synshow->isHidden() && m_is_login)
            {
                ui->widget_back_synshow->hide();
                if(ui->widget_base_frame->isHidden())
                    ui->widget_base_frame->show();
            } else if(!ui->widget_front_synshow->isHidden() && m_is_login) {
                ui->widget_front_synshow->hide();
                if(ui->widget_base_frame->isHidden())
                    ui->widget_base_frame->show();
            }
        }
        m_clickTimer.stop();
        m_num = 0;
    }

    m_bMouseMove = false;
    ConfigManger::GetInstance().setFloatInitPostion(this->pos());
}

void NewFloatForm::_Init()
{
    QSize tmpdesktopSize= QApplication::desktop()->screenGeometry().size();

    if(!m_is_login)
        tmpdesktopSize-= QSize(ui->widget_base->width(), ui->widget_base->height());
    else
        tmpdesktopSize-= QSize(this->width(), this->height());

    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint | Qt::Tool);
    setAttribute(Qt::WA_TranslucentBackground);

//    setFixedSize(m_imgNormalSize);
//    setStyleSheet("#floatWdg{ border-image: url(:float_normal.png); }");

    move(ConfigManger::GetInstance().GetFloatInitPostion());

    QPoint pos=ConfigManger::GetInstance().GetFloatInitPostion();

    if(pos.x()<0)
    {
        pos.setX(0);
    }
    if(pos.y()<0)
    {
        pos.setY(0);
    }
    if(pos.x()>tmpdesktopSize.width())
    {
        pos.setX(tmpdesktopSize.width());
    }
    if(pos.y()>tmpdesktopSize.height())
    {
        pos.setY(tmpdesktopSize.height());
    }
    move(pos);

    int currentScreenWid = tmpdesktopSize.width();
    int currentScreenHei  = tmpdesktopSize.height();
    double factoryx = currentScreenWid/800.0;
    double factoryy = currentScreenHei/600.0;

    qDebug() << "******************************9090*************************" <<currentScreenWid <<  currentScreenHei << factoryx << factoryy;
//    resetGrid(this,factoryx,factoryy);
}

void NewFloatForm::_Blink()
{
    QSize tmpdesktopSize= QApplication::desktop()->screenGeometry().size();
    tmpdesktopSize-= QSize(ui->widget_base->width(), ui->widget_base->height());
    QEventLoop loop;
    connect(&m_animation, &QPropertyAnimation::finished, &loop, &QEventLoop::quit);
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();
//    this->setFixedSize(m_imgRemindSize);
    //ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_remind.png)}");
    //ui->widget_login->show();

    qDebug() << pos().x()  << "pppp" << tmpdesktopSize.width() - 2*(ui->widget_base->width()) << tmpdesktopSize;

    if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
    {
        qDebug() <<"table show21------------------------------";
        ui->widget_base_frame->hide();
        ui->widget_front_synshow->hide();
        ui->widget_back_synshow->hide();
        ui->widget_front_login->show();
    } else {
        qDebug() <<"table show22------------------------------";
        ui->widget_base_frame->hide();
        ui->widget_back_synshow->hide();
        ui->widget_front_synshow->hide();
        ui->widget_back_login->show();
    }


    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();
//    this->setFixedSize(m_imgNormalSize);
    //ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_normal.png)}");

    if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
    {
        qDebug() <<"table show23------------------------------";
        ui->widget_base_frame->hide();
        ui->widget_front_synshow->show();
        ui->widget_back_synshow->hide();
        ui->widget_front_login->hide();
    } else {
        qDebug() <<"table show24------------------------------";
        ui->widget_base_frame->hide();
        ui->widget_back_synshow->show();
        ui->widget_front_synshow->hide();
        ui->widget_back_login->hide();
    }

//    ui->widget_base->hide();
//    ui->widget_back_synshow->show();
//    ui->widget_back_login->hide();
    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();

    if(m_bReminding)
    {
        QTimer::singleShot(ConfigManger::GetInstance().GetBlinkInterval(), this, &NewFloatForm::_Blink);
    }
}

void NewFloatForm::_PlayWav()
{
    //if(m_play_flag == false && m_bReminding == true)
        QSound::play(m_remindWav);
    if(m_bReminding)
    {
        QTimer::singleShot(m_wavPlayInterval, this, &NewFloatForm::_PlayWav);
    }
}

void NewFloatForm::_UdpRadio(QString songName, int type,int time)
{
    QJsonObject json;
    json.insert("reqType",type);
    json.insert("sound_name",songName);
    json.insert("time",time);
    static QString ipAddress;
    if(ipAddress.isEmpty())
    {
        QHostInfo info = QHostInfo::fromName(QHostInfo::localHostName());
        foreach(QHostAddress address,info.addresses())
        {
            if(address.protocol() == QAbstractSocket::IPv4Protocol)
            {
                ipAddress=address.toString();
            }
        }
    }
    int port=ConfigManger::GetInstance().GetUdpPort();
    QHostAddress mcast_addr(ipAddress.replace(10,3,ConfigManger::GetInstance().GetUdpUrl()));
    QLOG_INFO()<<"udp info"<<mcast_addr<<port<<QJsonDocument(json).toJson(QJsonDocument::Compact);
    QUdpSocket udp_socket;
    //udp_socket.writeDatagram(QJsonDocument(json).toJson(QJsonDocument::Compact), mcast_addr, port);
    udp_socket.writeDatagram(QJsonDocument(json).toJson(QJsonDocument::Compact), QHostAddress::Broadcast, port);
    udp_socket.waitForBytesWritten();
    udp_socket.close();
    qDebug()<<__FUNCTION__;
}

void NewFloatForm::onStartRemind(int type)
{
    QSize tmpdesktopSize= QApplication::desktop()->screenGeometry().size();
    tmpdesktopSize-= QSize(ui->widget_base->width(), ui->widget_base->height());
    switch(type)
    {
    case 0:
        m_remindWav = QString("%1/wav/msg.wav").arg(QApplication::applicationDirPath());
        // 加上音频的时长
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_NEWORDERTIME;
        if(ui->widget_back_synshow->isHidden() && m_is_login && ui->widget_front_synshow->isHidden())
        {
            if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
            {
                ui->widget_front_synshow->show();
                ui->label_front_newmsg->setText(QString::fromLocal8Bit("     新订单"));
            } else {
                ui->widget_back_synshow->show();
                ui->label_back_newmsg->setText(QString::fromLocal8Bit("  新订单"));
            }
            if(!ui->widget_base_frame->isHidden())
                ui->widget_base_frame->hide();
        }
        else if(!ui->widget_back_synshow->isHidden() && m_is_login)
        {
//            ui->widget_back_synshow->hide();
            ui->label_back_newmsg->setText(QString::fromLocal8Bit("  新订单"));
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        } else if(!ui->widget_front_synshow->isHidden() && m_is_login) {
//            ui->widget_front_synshow->hide();
            ui->label_front_newmsg->setText(QString::fromLocal8Bit("     新订单"));
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        }
//        ui->label_back_newmsg->setText(QString::fromLocal8Bit("新订单"));
        break;
    case 1:
        m_remindWav = QString("%1/wav/msg1.wav").arg(QApplication::applicationDirPath());
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_REFUNDORDERTIME;
        if(ui->widget_back_synshow->isHidden() && m_is_login && ui->widget_front_synshow->isHidden())
        {
            if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
            {
                ui->widget_front_synshow->show();
                ui->label_front_newmsg->setText(QString::fromLocal8Bit("     新退单"));
            } else {
                ui->widget_back_synshow->show();
                ui->label_back_newmsg->setText(QString::fromLocal8Bit("  新退单"));
            }
            if(!ui->widget_base_frame->isHidden())
                ui->widget_base_frame->hide();
        }
        else if(!ui->widget_back_synshow->isHidden() && m_is_login)
        {
//            ui->widget_back_synshow->hide();
            ui->label_back_newmsg->setText(QString::fromLocal8Bit("  新退单"));
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        } else if(!ui->widget_front_synshow->isHidden() && m_is_login) {
//            ui->widget_front_synshow->hide();
            ui->label_front_newmsg->setText(QString::fromLocal8Bit("     新退单"));
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        }
//        ui->label_back_newmsg->setText(QString::fromLocal8Bit("新退单"));
        break;
    case 2:
        m_remindWav = QString("%1/wav/msg2.wav").arg(QApplication::applicationDirPath());
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_REFUNDORDERTIME;
        if(ui->widget_back_synshow->isHidden() && /*m_is_login &&*/ ui->widget_front_synshow->isHidden())
        {
            if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
            {
                ui->widget_front_synshow->show();
                ui->label_front_newmsg->setText(QString::fromLocal8Bit("网络异常"));
            } else {
                ui->widget_back_synshow->show();
                ui->label_back_newmsg->setText(QString::fromLocal8Bit("网络异常"));
            }
            if(!ui->widget_base_frame->isHidden())
                ui->widget_base_frame->hide();
        }
        else if(!ui->widget_back_synshow->isHidden() /*&& m_is_login*/)
        {
//            ui->widget_back_synshow->hide();
            ui->label_back_newmsg->setText(QString::fromLocal8Bit("网络异常"));
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        } else if(!ui->widget_front_synshow->isHidden() /*&& m_is_login*/) {
//            ui->widget_front_synshow->hide();
            ui->label_front_newmsg->setText(QString::fromLocal8Bit("网络异常"));
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        }
//        ui->label_back_newmsg->setText(QString::fromLocal8Bit("网络异常"));
    case 3:
        if(ui->widget_back_synshow->isHidden() && m_is_login && ui->widget_front_synshow->isHidden())
        {
            if(pos().x() > tmpdesktopSize.width() - 2*(ui->widget_base->width()))
            {
                ui->widget_front_synshow->show();
                ui->label_front_newmsg->setText(QString::fromLocal8Bit("骑手取消订单"));
                ui->label_front_newmsg->setWordWrap(true);
            } else {
                ui->widget_back_synshow->show();
                ui->label_back_newmsg->setText(QString::fromLocal8Bit("骑手取消订单"));
                ui->label_back_newmsg->setWordWrap(true);
            }
            if(!ui->widget_base_frame->isHidden())
                ui->widget_base_frame->hide();
        }
        else if(!ui->widget_back_synshow->isHidden() && m_is_login)
        {
//            ui->widget_back_synshow->hide();
            ui->label_back_newmsg->setText(QString::fromLocal8Bit("骑手取消订单"));
            ui->label_back_newmsg->setWordWrap(true);
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        } else if(!ui->widget_front_synshow->isHidden() && m_is_login) {
//            ui->widget_front_synshow->hide();
            ui->label_front_newmsg->setText(QString::fromLocal8Bit("骑手取消订单"));
            ui->label_front_newmsg->setWordWrap(true);
            if(ui->widget_base_frame->isHidden())
                ui->widget_base_frame->show();
        }
    }

    if(m_bReminding)
    {
        return;
    }else
    {
       m_bReminding = true;
    }

    if(m_remindTimer.isActive())
        m_remindTimer.stop();
    if(this->isHidden())
        m_remindTimer.start(1*1000);
    else
        m_remindTimer.start(7*24*60*60*1000);
    m_remindTimer.setSingleShot(true);
    connect(&m_remindTimer, &QTimer::timeout, this, &NewFloatForm::onStopRemind);
    _Blink();
    _PlayWav();
}

void NewFloatForm::onStopRemind()
{
    m_bReminding = false;
    //m_play_flag = false;
}

void NewFloatForm::onShow()
{
    InitWidget();
    show();
    m_raiseTimer.start();
}

void NewFloatForm::resetGrid(QDialog *widget, double factorx, double factory)

{
    int widgetX = widget->x();
    int widgetY = widget->y();
    int widgetWid = widget->width();
    int widgetHei = widget->height();
    int nWidgetWid = (int)(widgetWid*factorx);
    int nWidgetHei = (int)(widgetHei*factory);
    qDebug() << "----------------------------------------9090-----------------------" << widgetX << widgetY << nWidgetWid << nWidgetHei;
//    this->setGeometry(0,0,nWidgetWid,nWidgetHei);
//    ui->widget_base->setGeometry(widgetX,widgetY+ui->widget_base->width(),nWidgetWid*(48/144.0),nWidgetHei);
//    ui->widget_back_login->setGeometry(0,0,nWidgetWid,nWidgetHei);
//    ui->widget_back_synshow->setGeometry(0,0,nWidgetWid,nWidgetHei);
//    ui->widget_touch->setGeometry(0,0,nWidgetWid,nWidgetHei);
//    widget->setFixedSize(nWidgetWid,nWidgetHei);
    this->setFixedSize(nWidgetWid,nWidgetHei);
    ui->widget_base_frame->setFixedSize(nWidgetWid,nWidgetHei);
    ui->widget_back_login->setFixedSize(nWidgetWid,nWidgetHei);
    ui->widget_back_synshow->setFixedSize(nWidgetWid,nWidgetHei);
    ui->widget_front_login->setFixedSize(nWidgetWid,nWidgetHei);
    ui->widget_front_synshow->setFixedSize(nWidgetWid,nWidgetHei);
    ui->widget_touch->setFixedSize(nWidgetWid,nWidgetHei);

    //设置label字体大小l

    ui->label_back_new->setStyleSheet(QString("#label_back_new{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_back_newnum->setStyleSheet(QString("#label_back_newnum{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_front_new->setStyleSheet(QString("#label_front_new{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_front_newnum->setStyleSheet(QString("#label_front_newnum{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_back_refund->setStyleSheet(QString("#label_back_refund{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_back_refundnum->setStyleSheet(QString("#label_back_refundnum{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_front_refund->setStyleSheet(QString("#label_front_refund{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_front_refundnum->setStyleSheet(QString("#label_front_refundnum{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_back_newmsg->setStyleSheet(QString("#label_back_newmsg{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
    ui->label_front_newmsg->setStyleSheet(QString("#label_front_newmsg{font-size:%1px;}").arg(QString::number((int)(10*factorx))));
}

void NewFloatForm::OnUpdate()
{
    m_num++;
}
