#ifndef NEWCHANGESHIFTSFORM_H
#define NEWCHANGESHIFTSFORM_H

#include <QWidget>
#include <QVariantMap>
#include <QUrl>
#include <QDateTime>

#include "preDefine.h"
#include "base/Arithmetic/cretopt.h"
#include "model/orderObject.h"

#define ADVANCEORDER 0

namespace Ui {
class NewChangeShiftsForm;
}

class NewChangeShiftsForm : public QWidget
{
    Q_OBJECT

public:
    explicit NewChangeShiftsForm(QWidget *parent = 0);
    ~NewChangeShiftsForm();

    virtual bool event(QEvent *e);

    void Initshow();

    bool GetShift(const QJsonObject &requestJson, QJsonObject &recvJson, QString url, QString &error, QByteArray contentype);

    bool PraseRecvJson(QJsonObject &recvJson);

    bool Print();

    void DoPrint(const QString &prtname, const QVariantMap config, bool &flag);

private slots:
    void on_prtBtn_clicked();

private:
    Ui::NewChangeShiftsForm *ui;

    QVariantMap m_storeinfo;

    QString _url;

    QJsonObject _order;

};



class GetShiftDataProcess
{
public:
    friend class NewChangeShiftsForm;
private:
    static bool getAction(int REQ, QString &action)
    {
#ifndef USE_QAACTION
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("saas.order.dailySettlement");
                return true;
            default:
                return false;
        }
#else
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("qasaas.order.dailySettlement");
                return true;
            default:
                return false;
        }
#endif
    }

    static bool getAccess_Token(QString &access_toekn)
    {
        access_toekn = DEFAULT_ACCESS_TOKEN;
        return true;
    }

    static bool getVer(QString &ver)
    {
        ver = "1";
        return true;
    }

    static bool getRealUrl(int reqtype, const QJsonObject &json, const QString &url, QString &realurl)
    {

        QString action, access_token, ver, sign;

        if(!GetShiftDataProcess::requestGetRSASign(reqtype, json, sign, action, access_token, ver))
            return false;

        QString tmpurl = url;

        realurl = tmpurl.arg(action, access_token, ver, sign);

        return true;
    }

    static bool requestGetRSASign(int reqtype, const QJsonObject &json, QString &sign, QString &action, QString &access_token, QString &ver)
    {
        QJsonObject tmpjson;

        if(!GetShiftDataProcess::getAction(reqtype, action) ||
            !GetShiftDataProcess::getAccess_Token(access_token) ||
                !GetShiftDataProcess::getVer(ver))
            return false;

        GetShiftDataProcess::getComplateJson(action, access_token, ver, json, tmpjson);
        return CretOperate::GetSign(tmpjson, sign);
    }

    static void getComplateJson(QString action, QString access_token, QString ver, const QJsonObject &json, QJsonObject &complatejson)
    {
        complatejson = json;

        complatejson.insert(JSON_KEY_ACTION, action);
        complatejson.insert(JSON_KEY_ACCESS_TOKEN, access_token);
        complatejson.insert(JSON_KEY_VER, ver);
    }

    static bool getShiftOptRequest(QJsonObject &data, QVariantMap &map)
    {
        data.insert(JSON_KEY_PARTNERID, map[JSON_KEY_PARTNERID].toString());
        data.insert(JSON_STOREID, map[JSON_STOREID].toString());
        data.insert(JSON_SEARCHSTARTDATE, map[JSON_KEY_TIMESTAMP].toString());
//        data.insert(JSON_SEARCHSTARTDATE, QString("2019-03-01 00:00"));
        data.insert(JSON_SEARCHENDDATE, QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm"));
        return true;
    }

};

#endif // NEWCHANGESHIFTSFORM_H
