﻿#include "newchangeshiftsform.h"
#include "ui_newchangeshiftsform.h"
#include <QDateTime>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QUrl>
#include <QTimer>
#include <QSettings>
#include <QApplication>
#include <QJsonArray>
#include <QJsonObject>

#include "event/fmapplication.h"
#include "event/posevent.h"
#include "QsLog.h"
#include "preDefine.h"
#include "model/posprtpool.h"
#include "newprintlib.h"

NewChangeShiftsForm::NewChangeShiftsForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::NewChangeShiftsForm)
{
    ui->setupUi(this);
    FMApplication::subscibeEvent(this, PosEvent::s_login_storeinfo);
    QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    _url = QSettings(configfile, QSettings::IniFormat).value(INI_GETSERVER).toString();
    _order = QJsonObject();
}

NewChangeShiftsForm::~NewChangeShiftsForm()
{
    delete ui;
}

bool NewChangeShiftsForm::event(QEvent *e)
{
    if(e->type() == PosEvent::s_login_storeinfo)
    {
        QVariantMap map;

        GETEVENTINFO(map,e,QVariantMap);

        m_storeinfo = map;

        return true;
    }

     return QWidget::event(e);
}

void NewChangeShiftsForm::Initshow()
{
    QLOG_DEBUG() << "NewChangeShiftsForm::Initshow()";
    ui->label_shiftName_str->setText(m_storeinfo[JSON_KEY_USERID].toString());
//    QDateTime time = QDateTime::fromString(m_storeinfo[JSON_KEY_TIMESTAMP].toString(), "yyyy-MM-dd hh:mm");

//    QLOG_DEBUG() << "TIME:" << m_storeinfo[JSON_KEY_TIMESTAMP].toString() << time << QDateTime::currentDateTime().toString("yyyy-MM-dd");

    QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;

    QSettings *configIni = new QSettings(configfile, QSettings::IniFormat);

    QString loginTime = configIni->value("base/loginTime").toString();


//    if(time.toString("yyyy-MM-dd") != QDateTime::currentDateTime().toString("yyyy-MM-dd")) {
//        ui->label_shiftTime_str->setText(QDateTime::currentDateTime().toString("yyyy-MM-dd") + QString(" 00:00"));
//        m_storeinfo[JSON_KEY_TIMESTAMP] = QString(QDateTime::currentDateTime().toString("yyyy-MM-dd") + QString(" 00:00"));
//    } else {
//        ui->label_shiftTime_str->setText(time.toString("yyyy-MM-dd hh:mm"));
//        m_storeinfo[JSON_KEY_TIMESTAMP] = QString(time.toString("yyyy-MM-dd hh:mm"));
//    }

    QString date = loginTime.section(" ",0,0);

    if(date != QDateTime::currentDateTime().toString("yyyy-MM-dd")) {
        configIni->setValue("base/loginTime",QString(QDateTime::currentDateTime().toString("yyyy-MM-dd") + QString(" 00:00")));
        ui->label_shiftTime_str->setText(QDateTime::currentDateTime().toString("yyyy-MM-dd") + QString(" 00:00"));
        m_storeinfo[JSON_KEY_TIMESTAMP] = QString(QDateTime::currentDateTime().toString("yyyy-MM-dd") + QString(" 00:00"));
    } else {
         ui->label_shiftTime_str->setText(loginTime);
         m_storeinfo[JSON_KEY_TIMESTAMP] = loginTime;
    }

    ui->label_timeTo_str->setText(QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm"));
    this->show();
}

bool NewChangeShiftsForm::GetShift(const QJsonObject &requestJson, QJsonObject &recvJson, QString url, QString &error, QByteArray contentype = QByteArray("text/json"))
{
    QNetworkAccessManager m_networkManger;

    if(QNetworkAccessManager::Accessible != m_networkManger.networkAccessible())
    {
        m_networkManger.setNetworkAccessible(QNetworkAccessManager::Accessible);
    }

    QNetworkRequest networkRequest;
    networkRequest.setUrl(url);
    networkRequest.setRawHeader("Content-Type",contentype);

    QByteArray sendArray = QJsonDocument(requestJson).toJson(QJsonDocument::Compact);
    QEventLoop eventLoop;
    QNetworkReply *reply = m_networkManger.post(networkRequest , sendArray);
    connect(&m_networkManger, SIGNAL(networkAccessibleChanged(QNetworkAccessManager::NetworkAccessibility)), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(finished()), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)), &eventLoop, SLOT(quit()));
    // 加用定时器防止网络出现异常长时间不返回导致的阻塞
    QTimer::singleShot(JSON_LOGIN_TIMEOUT, &eventLoop, &QEventLoop::quit);
    eventLoop.exec();

   if(reply->error() != QNetworkReply::NoError)
   {
       error = reply->errorString();
       return false;
   }

   QByteArray recvArray = reply->readAll();
   if(recvArray.size() == 0)
   {
       error = "nothing recved";
       return false;
   }
   recvJson = QJsonDocument::fromJson(recvArray).object();
   qDebug() << recvJson;
   reply->deleteLater();

   return true;
}

bool NewChangeShiftsForm::Print()
{
    QLOG_DEBUG() << "NewChangeShiftsForm::Print()";
    QStringList prtlist = PosPrtPool::prtlist();

    bool flag = false;

    foreach (auto v, prtlist) {
        int prttype;

        QVariantMap map;

        if(!PosPrtPool::GetPrtType(v, prttype))
        {
            QLOG_ERROR() << "orderprintwork::Print::PosPrtPool::GetPrtType failed";
            return false;
        }

        if(!PosPrtPool::GetPrtConfig(v, map))
        {
            QLOG_ERROR() << "orderprintwork::Print::PosPrtPool::GetPrtConfig failed";
            return false;
        }


        switch (prttype) {
        case 0:
            DoPrint(v, map, flag);
            QLOG_DEBUG()  << "DoPrint" << flag;
            break;
        default:
            break;
        }

        if(flag == false)
            break;
    }
    if(!flag) {
        QLOG_DEBUG() << "print failed : ";

        QVariantMap tmpmap;

        tmpmap.insert(EVENT_KEY_STATUS, false);
        tmpmap.insert(EVENT_KEY_MSG, QString("").append(QString::fromUtf8("\x20\xE6\x89\x93\xE5\x8D\xB0\xE5\xA4\xB1\xE8\xB4\xA5")));

        POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);
        return false;
    } else {
        QLOG_DEBUG() << "print success : ";

        QVariantMap tmpmap;

        tmpmap.insert(EVENT_KEY_STATUS, true);
        tmpmap.insert(EVENT_KEY_MSG, QString("").append(QString::fromUtf8("\xE6\x89\x93\xE5\x8D\xB0\xE6\x88\x90\xE5\x8A\x9F")));

        POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);
        return true;
    }

}

void NewChangeShiftsForm::DoPrint(const QString &prtname, const QVariantMap config, bool &flag)
{
    QLOG_DEBUG() << "NewChangeShiftsForm::DoPrint";
    QString strconfig;
    QString contextfile;
    OrderObject order;

    order.FromJson(QJsonObject());
    QString current = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss");
    order._orderObject.insert("prt_time", current);
    order._orderObject.insert("prt_name", m_storeinfo[JSON_KEY_USERID].toString());

    QLOG_DEBUG() << "_order:" << _order;
    QJsonObject tmpobj = _order["result"].toObject();
    QLOG_DEBUG() << "tmpobj:" << tmpobj["order_amount"].toInt() << tmpobj["order_totality"].toInt();
    order._orderObject.insert("productList", tmpobj["productList"].toArray());
    order._orderObject.insert("orderAmount", tmpobj["order_amount"].toInt());
    order._orderObject.insert("orderTotality", tmpobj["order_totality"].toInt());
    order._orderObject.insert("refundOrderAmount", tmpobj["refund_order_amount"].toInt());
    order._orderObject.insert("refundOrderTotality", tmpobj["refund_order_totality"].toInt());
    order._orderObject.insert("couponAmount", tmpobj["couponAmount"].toInt());
    order._orderObject.insert("couponOrderTotality", tmpobj["couponOrderTotality"].toInt());
    order._orderObject.insert("search_start_time", tmpobj["search_start_date"].toString());
    order._orderObject.insert("search_end_time", tmpobj["search_end_date"].toString());
    order._orderObject.insert("package_fee", tmpobj["package_fee"].toInt());
    order._orderObject.insert("send_fee", tmpobj["send_fee"].toInt());

    QLOG_DEBUG() << "NewChangeShiftsForm::DoPrint" << prtname << config;

    QJsonObject json = QJsonObject::fromVariantMap(config);

    strconfig = QString(QJsonDocument(json).toJson(QJsonDocument::Compact));

    QString paperWidth = "";
    if(json.contains(PRT_CONF_PAPERWIDTH)) {
        paperWidth = json[PRT_CONF_PAPERWIDTH].toString();
    }

    int width = paperWidth.toInt();
    if(width > 56)
    {
        contextfile = QApplication::applicationDirPath() + "/dayBill80.xml";
    }
    else
    {
        contextfile = QApplication::applicationDirPath() + "/dayBill56.xml";
    }

    QFile file(contextfile);

    if(!file.open(QFile::ReadOnly))
    {
        QLOG_ERROR() << "Not found : " << contextfile;
    }

    QByteArray tmpcontext = file.readAll();
    QString context = QString::fromUtf8(tmpcontext);
    file.close();

    QLOG_DEBUG() << "NewChangeShiftsForm::DoPrint XML : " << tmpcontext.data();

    flag = NewPrintLib::GetInstance().DoPrint(strconfig, context, &order, width);

    QLOG_DEBUG() << "NewPrintLib::GetInstance flag : " << flag;
}



void NewChangeShiftsForm::on_prtBtn_clicked()
{

    QVariantMap smap;
    smap.insert(EVENT_KEY_ORDERSTATUS, 0);
    smap.insert(EVENT_KEY_MSG, QString::fromLocal8Bit("通讯中..."));
    POSTEVENTTYPE(PosEvent::s_opt_status,smap,QVariantMap);

    QJsonObject json, recvjson;
    QString realurl;
    QString error;

    if(!GetShiftDataProcess::getShiftOptRequest(json, m_storeinfo))
    {
        QLOG_ERROR() << "getShiftOptRequest failed";
        return;
    }

    QLOG_INFO() << "getShiftOptRequest request json : " << json;

    if(!GetShiftDataProcess::getRealUrl(ADVANCEORDER, json, _url, realurl))
    {
        QLOG_ERROR() << "GetShiftDataProcess getRealUrl failed";
        QVariantMap tmpmap;

        tmpmap.insert(EVENT_KEY_STATUS, false);
        tmpmap.insert(EVENT_KEY_MSG, QString::fromLocal8Bit("获取请求链接失败"));

        POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);
        return;
    }

    QLOG_INFO() << "GetShiftDataProcess request url :" << realurl;

    if(!GetShift(json, recvjson, realurl, error))
    {
        QLOG_ERROR() << "GetShift failed : " << error;
        QVariantMap tmpmap;

        tmpmap.insert(EVENT_KEY_STATUS, false);
        tmpmap.insert(EVENT_KEY_MSG, QString::fromLocal8Bit("网络错误").append(error));

        POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);
        return;
    }

    QLOG_INFO() << "GetShift return json : " << recvjson;

    _order = recvjson;

    bool flag = Print();

    QLOG_DEBUG() << "NewChangeShiftsForm::flag:" << flag;
    if(flag) {

        QString dateTime = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm");

        QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;

        QSettings *configIni = new QSettings(configfile, QSettings::IniFormat);

        configIni->setValue("base/loginTime", dateTime);

        //优化交接班打印，打印按钮点击之后，将下次打印开始时间置为当前时间
        m_storeinfo[JSON_KEY_TIMESTAMP] = dateTime;

        ui->label_shiftTime_str->setText(dateTime);

        ui->label_timeTo_str->setText(QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm"));
    }

    return;
}
