#include "mainbtn.h"
#include "ui_mainbtn.h"

#include <QMouseEvent>

#include <qDebug>
#include "event/posevent.h"
#include "event/fmapplication.h"
#include "model/posorderpool.h"

#include "QsLog.h"

MainBtn::MainBtn(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::MainBtn)
{
    ui->setupUi(this);
    _checked = false;

    FMApplication::subscibeEvent(this, PosEvent::s_change_order);
    FMApplication::subscibeEvent(this, PosEvent::s_delete_order);
}

MainBtn::~MainBtn()
{
    delete ui;
}

void MainBtn::setChecked(bool check)
{
    _checked = check;

    QString type =  this->property("type").toString();

    QLOG_DEBUG() << "====" << type << ";" << check << _type;

    if(type.compare("order",Qt::CaseInsensitive) == 0)
    {
        if(check)
        {

            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(255,255,255,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:orders_on.png)}");
            _info = QString::fromUtf8("\xE8\xAE\xA2\xE5\x8D\x95\xE7\xAE\xA1\xE7\x90\x86");
        }
        else
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(125,139,153,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:orders_off.png)}");
        }
        return ;
    }

    if(type.compare("refund",Qt::CaseInsensitive) == 0)
    {
        if(check)
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(255,255,255,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:refund_on.png)}");
            _info = QString::fromUtf8("\xE9\x80\x80\xE5\x8D\x95");
        }
        else
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(125,139,153,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:refund_off.png)}");
        }
        return ;
    }

    if(type.compare("set",Qt::CaseInsensitive) == 0)
    {
        if(check)
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(255,255,255,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:setting_on.png)}");
            _info = QString::fromUtf8("\xE8\xAE\xBE\xE7\xBD\xAE");
        }
        else
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(125,139,153,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:setting_off.png)}");
        }
        return ;
    }

    if(type.compare("scan",Qt::CaseInsensitive) == 0)
    {
        QLOG_DEBUG() << "*scan" << type;
        QLOG_DEBUG() << "*check" << check;

        if(check)
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(255,255,255,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:scan_on.png)}");
            _info = QString::fromUtf8("\xE6\x89\xAB\xE7\xA0\x81\xE5\x8F\x96\xE9\xA4\x90");
            QLOG_DEBUG() << "*scan" << _info;
        }
        else
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(125,139,153,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:scan_off.png)}");
        }
        return ;
    }

    if(type.compare("shifts",Qt::CaseInsensitive) == 0)
    {
        QLOG_DEBUG() << "*shifts" << type;
        QLOG_DEBUG() << "*check" << check;

        if(check)
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(255,255,255,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:shift_on.png)}");
            _info = QString::fromUtf8("\xE4\xBA\xA4\xE6\x8E\xA5\xE7\x8F\xAD");
            QLOG_DEBUG() << "*shifts" << _info;
        }
        else
        {
            ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(125,139,153,1)}");
            ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:shift_off.png)}");
        }
        return ;
    }
}

void MainBtn::mousePressEvent(QMouseEvent *e)
{
    if(e->buttons()&Qt::LeftButton)
    {
        emit clicked();
        return ;
    }
    return QWidget::mousePressEvent(e);
}

void MainBtn::SetText(QString data, QString type)
{
    _type = type;

    QLOG_DEBUG() << "*type" << _type;
    QLOG_DEBUG() << "*data" << data;

    ui->mainbtnlabel_name->setText(data);

    ui->mainbtnlabel_name->setStyleSheet("#mainbtnlabel_name{color:rgba(255,255,255,1)}");

    if(type.compare("order",Qt::CaseInsensitive) == 0)
    {
        ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:orders_off.png)}");
        return ;
    }

    if(type.compare("refund",Qt::CaseInsensitive) == 0)
    {
        ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:refund_off.png)}");
        return ;
    }

    if(type.compare("set",Qt::CaseInsensitive) == 0)
    {
        ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:setting_off.png)}");
        return ;
    }

    if(type.compare("scan",Qt::CaseInsensitive) == 0)
    {
        ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:scan_off.png)}");
        return ;
    }

    if(type.compare("shifts",Qt::CaseInsensitive) == 0)
    {
        ui->mainbtnlabel_lg->setStyleSheet("#mainbtnlabel_lg{ border-image: url(:scan_off.png)}");
        return ;
    }
}

QString MainBtn::getMainBtnType() const
{
    return _type;
}

QString MainBtn::info() const
{
    return _info;
}

//bool MainBtn::event(QEvent *e)
//{
//    if(e->type() == PosEvent::s_change_order)
//    {
//        QLOG_DEBUG() << "MainBtn PosEvent::s_change_order:";
//        QString orderid;

//        GETEVENTINFO(orderid,e,QString);

//        int tk_new = 0, tk_make = 0, tk_send = 0, tk_refund = 0;
//        int self_new = 0, self_make = 0, self_refund = 0;

//        PosOrderPool::GetOrderNum(tk_new, tk_make, tk_send, tk_refund, self_new, self_make, self_refund);

//        QLOG_DEBUG() << "tk_new" << tk_new << "tk_make" << tk_make << "tk_send" << tk_send << "self_new" << self_new << "self_make" << self_make;
//        QLOG_DEBUG() << "tk_refund" << tk_refund << "self_refund" << self_refund;

//        if(_type.compare("refund",Qt::CaseInsensitive) == 0)
//        {
//            _info = QString::fromUtf8("\xE9\x80\x80\xE5\x8D\x95") + QString("(%1)").arg(QString::number(tk_refund + self_refund));
//        }

//        return true;
//    }

//    if(e->type() == PosEvent::s_delete_order)
//    {
//        QLOG_DEBUG() << "MainBtn PosEvent::s_delete_order:";
//        int tk_new = 0, tk_make = 0, tk_send = 0, tk_refund = 0;
//        int self_new = 0, self_make = 0, self_refund = 0;

//        PosOrderPool::GetOrderNum(tk_new, tk_make, tk_send, tk_refund, self_new, self_make, self_refund);

//        QLOG_DEBUG() << "tk_new" << tk_new << "tk_make" << tk_make << "tk_send" << tk_send << "self_new" << self_new << "self_make" << self_make;
//        QLOG_DEBUG() << "tk_refund" << tk_refund << "self_refund" << self_refund;

//        if(_type.compare("refund",Qt::CaseInsensitive) == 0)
//        {
//            _info = QString::fromUtf8("\xE9\x80\x80\xE5\x8D\x95") + QString("(%1)").arg(QString::number(tk_refund + self_refund));
//        }

//        return true;
//    }

//    return QWidget::event(e);
//}
