﻿#ifndef MAINFORM_H
#define MAINFORM_H

#include <QDialog>
#include <QTableWidget>
#include "alertForm.h"
#include "Model/orderObject.h"
#include "Model/deliverObject.h"
#include "pickForm.h"
#include "settingForm.h"
#include <QTimer>
#include "view/sysTray.h"
#include "padForm.h"
#include <QListWidget>
#include "view/RejectForm.h"
#include "view/detailForm.h"
#include "view/prtsettingform.h"
#include "view/pickupform.h"

namespace Ui {
class MainForm;
}

class MainForm : public QWidget
{
    Q_OBJECT

public:
    explicit MainForm(QWidget *parent = 0);
    ~MainForm();

    /* 功能:自定义的显示函数
     * 参数:NULL
     * 返回:NULL
     * */
    void MyShow();

    virtual bool event(QEvent *e);
private:
    Ui::MainForm *ui;
    // 时间定时器
    QTimer m_timeTimer;

    // 记录上一次选中的表单和按钮
    QPushButton *m_prevBtn;
    QTableWidget *m_prevTable;

    QVariantMap m_storeinfo;
    // 所有的表
    QList<QTableWidget*> m_tableList;
    // 订单对应的表
    QMap<QString, QTableWidget *> m_order_table_map;
    // 通知窗口
    AlertForm *m_alertForm;
    //扫码取餐窗口
    PickUpForm *m_pickupForm;
    // 人员选择窗口
    PickForm *m_pickForm;
    //打印设置窗口
    PrtSettingForm *m_prtForm;
    // 设置窗口
    SettingForm *m_settingForm;
    // 订单详情窗口
    DetailForm *m_detailForm;
    // 数字键盘窗口
    PadForm *m_padForm;
    // 搜索结果窗口
    QListWidget *m_resultForm;

    //退单理由选择窗口
    RejectForm *m_rejectForm;
    //日结窗口
    //DailyReportForm *m_dailyReportForm;

    // 当前选中的表
    QTableWidget *m_currentTable;

    // 置顶计数器
    int m_raiseIndex;

    // 托盘图标
    SysTray m_tray;
    // 订单号长度
    int m_orderIdSize;

    /* 功能:还原按钮和表
     * 参数:NULL
     * 返回:NULL
     * */
    void _RevertBtnTable();
    /* 功能:控制Table的排序
     * 参数:[1]是否开启排序
     * 返回:NULL
     * */
    void _SetTablesSortEnable(bool bEnable);
    /* 功能:根据订单状态获取对应的Tab按钮
     * 参数:[1]订单状态
     * 返回:对应的Tab按钮
     * */
    QPushButton *_GetTabBtn(QTableWidget *view);
    /* 功能:删除订单数据
     * 参数:[1]订单编号
     * 返回：
     * */
    void deleteOrderItem(QString orderid);
    /* 功能:获取订单操作和操作名称
     * 参数:[1]订单[2]操作名称[3]按钮名称
     * 返回：
     * */
    bool getOrderOptAndName(OrderObject *order, QString &optname, QString &name);
    /* 功能:获取订单渠道名称
     * 参数:[1]订单[2]渠道名称
     * 返回：
     * */
    void getOrderChannelName(OrderObject *order, QString &channelname);
    /* 功能:获取订单所在table页和按钮
     * 参数:[1]订单[2]table页[3]按钮
     * 返回：
     * */
    void getTableAndBtn(OrderObject *order, QTableWidget *&tab, QPushButton *&btn);
signals:
    /* 功能:处理订单
     * 参数:[1]操作动作名[2]订单编号[3]配送员信息
     * 返回:NULL
     * */
    void processOrder(const QString& operation, const QString& orderId, const DeliverObject& deliverObj);
    /* 功能:通知悬浮窗显示
     * 参数:NULL
     * 返回:NULL
     * */
    void showFloatForm();
    /* 功能:通知悬浮窗开始提示
     * 参数:[1]提示类型 0新订单1退款申请
     * 返回:NULL
     * */
    void startRemind(int type);
    /* 功能:通知悬浮窗停止提示
     * 参数:NULL
     * 返回:NULL
     * */
    void stopRemind();
    /* 功能:获取订单详情
     * 参数:NULL
     * 返回:NULL
     * */
    void getOrderDetails(const QString& orderId);
    /* 功能:启动流程线程启动
     * 参数:NULL
     * 返回:NULL
     * */
    void flowStart();
    /* 功能:退款相关操作
     * 参数:[1]订单号[2]理由[3]退款类型
     * 返回:NULL
     * */
    void processRejectOrder(const QString& orderId,const int& reasonCode,const QString& reason,const int& reasontype);
private slots:
    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();
    /* 功能:设置当前时间
     * 参数:NULL
     * 返回:NULL
     * */
    void onSetCurrentTime();
    /* 功能:Tab页按钮点击对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onMainTabBtnClicked();
    /* 功能:Tab页按钮点击对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onMainProcBtnClicked();
    /* 功能:设置按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnSet_clicked();
    /* 功能:隐藏按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnHide_clicked();
    /* 功能:上翻按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnUp_clicked();
    /* 功能:下翻按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnDown_clicked();
    /* 功能:点击订单对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onMainTableItemClicked(QTableWidgetItem *item);
    /* 功能:点击搜索对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainEdtSearch_clicked();
    /* 功能:键盘数字点击处理
     * 参数:NULL
     * 返回:NULL
     * */
    void onNumClicked(const QString& num);
    /* 功能:键盘数字删除处理
     * 参数:NULL
     * 返回:NULL
     * */
    void onNumDelete();
    /* 功能:点击搜索结果订单对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onSearchResultItemClicked(QListWidgetItem * item);
    /* 功能:打印的相关功能设置
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnPrt_clicked();
    /* 功能:扫码取餐相关功能设置
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnpickup_clicked();
    /* 功能:扫码取餐相关功能设置
     * 参数:NULL
     * 返回:NULL
     * */
    void show_Detail_PickUpCode(QString pickupid);
public slots:
    /* 功能:隐藏通知窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void onSerachOrder(const QString &key);
    /* 功能:隐藏通知窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void onHideAlert();
    /* 功能:显示通知窗口
     * 参数:[1]窗口类型[2]显示信息
     * 返回:NULL
     * */
    void onShowAlert(AlertForm::Type type, const QString& msg);
    /* 功能:设置门店信息
     * 参数:[1]门店编号
     * 返回:NULL
     * */
    void onSetStoreInfo(const QString& storeId);
    /* 功能:设置收银员信息
     * 参数:[1]收银员编号
     * 返回:NULL
     * */
    void onSetCashierInfo(const QString& cashierInfo);
    /* 功能:设置门店营业状态
     * 参数:[1]营业状态
     * 返回:NULL
     * */
    void onSetOpeStatus(const QString& status);
    /* 功能:设置门店网络状态
     * 参数:[1]网络状态
     * 返回:NULL
     * */
    void onSetNetStatus(const QString& status);
    /* 功能:更改订单列表信息
     * 参数:[1]订单对象[2]旧订单的状态
     * 返回:NULL
     * */
    void onChangeOrderStatus(OrderObject *orderObject);
    /* 功能:显示配送员选择窗口
     * 参数:[1]订单编号[2]配送员信息
     * 返回:NULL
     * */
    void onShowDeliverPickForm(const QString& orderId, const QList<DeliverObject>& delivers);
    /* 功能:显示订单详情
     * 参数:[1]订单对象
     * 返回:NULL
     * */
    void onShowOrderDetails(OrderObject* orderObject);
    /* 功能:显示订单搜索结果
     * 参数:[1]订单搜索结果
     * 返回:NULL
     * */
    void onShowSearchOrderResult(const QMap<QString, QString> &orderIdList);
//    /* 功能:订单状态改变尝试删除订单
//     * 参数:[1]订单编号
//     * 返回:NULL
//     * */
//    void tryDeleteOrder(QString orderid);

    //void onOrderClear(const QString& orderId,const int& oldstatus);
    void onEntryResult(OrderObject* orderObject,int type);
};

#endif // MAINFORM_H
