﻿#include "mainForm.h"
#include "QsLog.h"
#include "ui_mainForm.h"
#include "preDefine.h"
#include "QsLog.h"
#include <QList>
#include <QMap>
#include <QProcess>
#include <QThread>
#include <QDateTime>

#include <QDesktopWidget>

#include "base/Config/configManger.h"
#include "event/posevent.h"
#include "event/fmapplication.h"
#include "model/posorderpool.h"

extern QThread  workThread;

MainForm::MainForm(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::MainForm)
{
    ui->setupUi(this);

    // 初始化成员变量
    m_prevBtn = NULL;
    m_prevTable = NULL;
    m_tableList.append(ui->mainTableNew);
    m_tableList.append(ui->mainTableMake);
    m_tableList.append(ui->mainTableSend);
    m_tableList.append(ui->mainTableRefund);
    m_tableList.append(ui->mainTableFinsh);
    m_tableList.append(ui->mainTableOther);
    m_tableList.append(ui->mainTableMakeOver);

    connect(&m_timeTimer, &QTimer::timeout, this, &MainForm::onSetCurrentTime);
    connect(ui->mainEdtSearch, &ClickedLineEdit::textChanged, this, &MainForm::onSerachOrder);

    //订阅事件
    FMApplication::subscibeEvent(this, PosEvent::s_login_status);
    FMApplication::subscibeEvent(this, PosEvent::s_opt_status);
    FMApplication::subscibeEvent(this, PosEvent::s_change_order);
    FMApplication::subscibeEvent(this, PosEvent::s_get_order_status);
    FMApplication::subscibeEvent(this, PosEvent::s_delete_order);
    FMApplication::subscibeEvent(this, PosEvent::s_login_storeinfo);
    FMApplication::subscibeEvent(this, PosEvent::s_show_mainform);
    FMApplication::subscibeEvent(this, PosEvent::s_hide_mainform);
    //FMApplication::subscibeEvent(this, PosEvent::s_network_outtime);


    // 初始化界面
    _Init();

    // 开启时间定时器
    m_raiseIndex = 0;
    m_timeTimer.start(1000);
    emit flowStart();
}

MainForm::~MainForm()
{
    delete ui;
}

void MainForm::MyShow()
{
    this->show();
    //this->showFullScreen();
    //this->move(600, 800);
    this->hide();

    m_alertForm = new AlertForm(this);
    m_pickForm = new PickForm(this);
    m_pickupForm = new PickUpForm(this);
    m_prtForm = new PrtSettingForm(this);
    m_settingForm = new SettingForm(this);
    m_rejectForm = new RejectForm(this);
    m_detailForm = new DetailForm(this);

    connect(m_detailForm, &DetailForm::showAlert, this, &MainForm::onShowAlert);
    connect(m_pickupForm, &PickUpForm::showorderinfo, this, &MainForm::show_Detail_PickUpCode);

    m_padForm = new PadForm(this);
    m_padForm->move(pos().x()+width()-300, pos().y()+height()-438);
    m_padForm->hide();
    connect(m_padForm, &PadForm::numClicked, this, &MainForm::onNumClicked);
    connect(m_padForm, &PadForm::numDelete, this, &MainForm::onNumDelete);
    connect(m_padForm, &PadForm::numClear, ui->mainEdtSearch, &ClickedLineEdit::clear);
    m_resultForm = new QListWidget(this);
    m_resultForm->setObjectName("mainListWdg0");
    m_resultForm->setFixedSize(340, 200);
    m_resultForm->move(70, ui->mainFrmSearch->pos().y()-190);
    m_resultForm->hide();
    connect(m_resultForm, &QListWidget::itemClicked, this, &MainForm::onSearchResultItemClicked);
}

bool MainForm::event(QEvent *e)
{
    if(e->type() == PosEvent::s_change_order)
    {
        QString orderid;

        GETEVENTINFO(orderid,e,QString);

        OrderObject order;

        if(!PosOrderPool::GetOrderObject(orderid, order))
            return true;

        onChangeOrderStatus(&order);

        return true;
    }

    if(e->type() == PosEvent::s_login_storeinfo)
    {
        QVariantMap map;

        GETEVENTINFO(map, e, QVariantMap);

        m_storeinfo = map;

        return true;
    }

    if(e->type() == PosEvent::s_show_mainform)
    {
        this->show();
        //this->move(600, 800);
        //this->showFullScreen();
        return true;
    }

    if(e->type() == PosEvent::s_hide_mainform)
    {
        this->hide();
        return true;
    }

    if(e->type() == PosEvent::s_delete_order)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_ORDERID) && value.contains(EVENT_KEY_ORDERSTATUS))
                    deleteOrderItem(value[EVENT_KEY_ORDERID].toString());
        return true;
    }

    if(e->type() == PosEvent::s_opt_status)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_ORDERSTATUS) && value[EVENT_KEY_ORDERSTATUS].toInt() == 0)
        {
            if(!this->isHidden())
                onShowAlert(AlertForm::LOADING, value[EVENT_KEY_MSG].toString());
            return true;
        }

        if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == false)
        {
            QLOG_INFO() << value[EVENT_KEY_MSG].toString();
            if(!this->isHidden())
                onShowAlert(AlertForm::ERROR, value[EVENT_KEY_MSG].toString());
        }
        else if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == true)
        {
            if(!this->isHidden())
                onShowAlert(AlertForm::SUCCESS, value[EVENT_KEY_MSG].toString());
        }
        return true;
    }

    if(e->type() == PosEvent::s_login_status)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == false)
        {
            QLOG_INFO() << value[EVENT_KEY_MSG].toString();
            onSetOpeStatus(QString::fromLocal8Bit("未登录"));
        }
        else if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == true)
        {
            onSetStoreInfo(m_storeinfo[JSON_STOREID].toString());
            onSetCashierInfo(m_storeinfo[JSON_STATIONID].toString());
            onSetOpeStatus(QString::fromLocal8Bit("登陆成功"));
            onSetNetStatus(QString::fromLocal8Bit("正常"));
        }
        return true;
    }

    if(e->type() == PosEvent::s_network_outtime)
    {
        QVariantMap value;
        GETEVENTINFO(value,e,QVariantMap);
        if(value.contains(EVENT_KEY_NETWORKSTATUS) && value[EVENT_KEY_NETWORKSTATUS].toBool() == true)
        {
            onSetNetStatus(QString::fromLocal8Bit("网络正常"));
        }else{
            QLOG_INFO() << "STATIC: EVENT_KEY_NETWORKSTATUS:false";
            onSetNetStatus(QString("<font color='#ff0000'>%1</font>").arg(QString::fromLocal8Bit("网络异常")));
            onShowAlert(AlertForm::ERROR, QString::fromLocal8Bit("网络异常,请检查网络链接!"));
        }
        return true;
    }
    return QWidget::event(e);
}

void MainForm::_Init()
{

    this->setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint);
    //this->showFullScreen();
    // 显示托盘
    m_tray.show();

    //ui->mainBtnDayReport->hide();

    // 设置任务栏图标和标题
    setWindowIcon(QIcon(":fm.ico"));

    // 初始化文字
    ui->mainLabStoreid->setText(QString::fromLocal8Bit(UI_STOREID));
    ui->mainLabVersion->setText(APP_VERSION);

    // 初始化表
    int scales6[] = {3, 4, 2, 3, 3, 3};
    int scales5[] = {3, 6, 2, 3, 3};
    int tableWidth = this->width() - 75;
    foreach(QTableWidget *table, m_tableList)
    {
        table->hide();
        if(table == ui->mainTableFinsh ||
           table == ui->mainTableOther)
        {
            for(int i=0; i<5; i++)
            {
                table->setColumnWidth(i, tableWidth*scales5[i]/21);
            }
        }else
        {
            for(int i=0; i<6; i++)
            {
                table->setColumnWidth(i, tableWidth*scales6[i]/21);
            }
        }
        table->horizontalHeader()->setSectionResizeMode(QHeaderView::Fixed);
        table->horizontalHeader()->setFixedHeight(30);
    }

    // 默认选中【新订单】
    ui->mainTableNew->show();
    ui->mainBtnNew->setChecked(true);
    ui->mainBtnNew->setEnabled(false);
    m_prevBtn = ui->mainBtnNew;
    m_prevTable = ui->mainTableNew;
    m_currentTable = ui->mainTableNew;
    ui->mainTableFinsh->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->mainTableMake->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->mainTableMakeOver->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->mainTableNew->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->mainTableOther->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->mainTableRefund->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->mainTableSend->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
}

void MainForm::onSetCurrentTime()
{
    if(m_raiseIndex++>10)
    {
       m_raiseIndex=0;
       raise();
    }
    ui->mainSlabTime->setText(QDateTime::currentDateTime().toString(QString::fromLocal8Bit("yyyy年MM月dd日 hh:mm:ss")));
}

void MainForm::onMainTabBtnClicked()
{
    _RevertBtnTable();
    QPushButton *btn = (QPushButton*)sender();
    m_currentTable = findChild<QTableWidget*>(btn->property("tableName").toString());

    m_currentTable->show();
    btn->setChecked(true);
    btn->setEnabled(false);

    m_prevBtn = btn;
    m_prevTable = m_currentTable;
}

void MainForm::onMainProcBtnClicked()
{
    QPushButton *pBtn = (QPushButton*)sender();
    QVariantMap value;

    value.insert(EVENT_KEY_ORDERID, pBtn->property("orderId").toString());
    value.insert(EVENT_KEY_STATUS, pBtn->property("operation").toString());

    POSTEVENTTYPE(PosEvent::s_opt_order,value,QVariantMap);
}

void MainForm::on_mainBtnSet_clicked()
{
    m_settingForm->show();
}

void MainForm::on_mainBtnHide_clicked()
{
    hide();
    ui->mainEdtSearch->clear();
    m_padForm->hide();
    //showFloatForm();
    DEFAULTPOSTEVENT(PosEvent::s_show_float, "");
}

void MainForm::onShowOrderDetails(OrderObject *orderObject)
{
    //m_detailForm->InitData(orderObject);
    //m_detailForm->show();
    //detailForm->show();
}

void MainForm::onShowSearchOrderResult(const QMap<QString,QString>& orderIdList)
{

    if(orderIdList.isEmpty())
    {
        m_resultForm->hide();
        return;
    }
    m_resultForm->clear();
    QMap<QString,QString>::const_iterator order;
    for(order=orderIdList.begin(); order!=orderIdList.end(); order++)
    {
        QListWidgetItem* item=new QListWidgetItem();
        item->setText(order.key()+"  "+order.value());
        m_resultForm->addItem(item);
    }
    m_resultForm->show();
}

void MainForm::_RevertBtnTable()
{
    m_prevBtn->setChecked(false);
    m_prevBtn->setEnabled(true);
    m_prevTable->hide();
}

void MainForm::_SetTablesSortEnable(bool bEnable)
{
    foreach (QTableWidget *table, m_tableList)
    {
        table->setSortingEnabled(bEnable);
    }
}

void MainForm::getTableAndBtn(OrderObject *order, QTableWidget* &tab, QPushButton* &btn)
{
    int status;

    if(order->refund_status == ApplicationRefundOrder ||
            order->refund_status == ApplicationPartialRefundOrder ||
            order->refund_status == CompleteRefundOrder)
        status = order->refund_status;
    else
        status = order->status;

    switch(status)
    {
    case NewOrder:
        btn = ui->mainBtnNew;
        tab = ui->mainTableNew;
        break;
    case FirmOrder:
        btn = ui->mainBtnMake;
        tab = ui->mainTableMake;
        break;
    case DispatchingOrder:
        btn = ui->mainBtnSend;
        tab = ui->mainTableSend;
        break;
    case InDevelopment:
        btn = ui->mainBtnMakeOver;
        tab = ui->mainTableMakeOver;
        break;
    case ServiceOrder:
    case CompleteOrder:
        btn = ui->mainBtnFinsh;
        tab = ui->mainTableFinsh;
        break;
    case ApplicationRefundOrder:
    case ApplicationPartialRefundOrder:
        btn = ui->mainBtnRefund;
        tab = ui->mainTableRefund;
        break;
    default:
        btn = ui->mainBtnOther;
        tab = ui->mainTableOther;
        break;
    }
}

QPushButton *MainForm::_GetTabBtn(QTableWidget *tab)
{
    if(tab == ui->mainTableFinsh)
        return ui->mainBtnFinsh;
    else if(tab == ui->mainTableMake)
        return ui->mainBtnMake;
    else if(tab == ui->mainTableMakeOver)
        return ui->mainBtnMakeOver;
    else if(tab == ui->mainTableNew)
        return ui->mainBtnNew;
    else if(tab == ui->mainTableRefund)
        return ui->mainBtnRefund;
    else if(tab == ui->mainTableSend)
        return ui->mainBtnSend;
    else
        return ui->mainBtnOther;
}

void MainForm::onHideAlert()
{
    m_alertForm->hide();
}

void MainForm::onShowAlert(AlertForm::Type type, const QString &msg)
{

    if(this->isVisible())
    {
        m_alertForm->SetContent(type, msg);
        m_alertForm->show();
    }
}

void MainForm::onSetStoreInfo(const QString &storeId)
{
    QString store_id=storeId;

    QLOG_DEBUG() << store_id << storeId;

    ui->mainLabStoreid->setText(store_id);
}

void MainForm::onSetCashierInfo(const QString &cashierInfo)
{
    ui->mainLabCashier->setText(cashierInfo);
}

void MainForm::onSetOpeStatus(const QString &status)
{
    ui->mainLabOpeStatus->setText(status);
}

void MainForm::onSetNetStatus(const QString &status)
{
    ui->mainLabNetStatus->setText(status);
}

void MainForm::deleteOrderItem(QString orderid)
{
    _SetTablesSortEnable(false);
    if(m_order_table_map.contains(orderid))
    {
        QTableWidget *table = m_order_table_map[orderid];
        QPushButton *tabBtn = _GetTabBtn(table);

        for(int i=0; i<table->rowCount(); i++)
        {
            if(!table->item(i, 1)->text().compare(orderid))
            {
                table->removeRow(i);
                QString btnText(tabBtn->property("name").toString());
                btnText = QString("%1\n%2").arg(table->rowCount()).arg(btnText);
                tabBtn->setText(btnText);
            }
        }
    }
    _SetTablesSortEnable(true);
}

bool MainForm::getOrderOptAndName(OrderObject *order, QString &optname, QString &name)
{
    int status;

    if(order->refund_status == ApplicationRefundOrder ||
            order->refund_status == ApplicationPartialRefundOrder ||
            order->refund_status == CompleteRefundOrder)
        status = order->refund_status;
    else
        status = order->status;

    switch (status) {
    case NewOrder:
        optname = OPERATION_GETDELIVERS;
        name = QString::fromLocal8Bit(OPERATIONNAME_GETDELIVERS);
        return true;
    case FirmOrder:
        if(order->order_type == TimelyTakeout || order->order_type == AppointmentTakeout)
        {
            optname =  OPERATION_SENDOUT;
            name = QString::fromLocal8Bit(OPERATIONNAME_SENDOUT);
        }
        else
        {
            optname = OPERATION_MAKEOVER;
            name = QString::fromLocal8Bit(OPERATIONNAME_MAKEOVER);
        }
        return true;
    case CancelOrder:
        return false;
    case DispatchingOrder:
        optname = OPERATION_COMPLETE;
        name = QString::fromLocal8Bit(OPERATIONNAME_COMPLETE);
        return true;
    case InDevelopment:
        optname = OPERATION_COMPLETE;
        name = QString::fromLocal8Bit(OPERATIONNAME_COMPLETE);
        return true;
    case ServiceOrder:
    case CompleteOrder:
        return false;
    case ApplicationRefundOrder:
    case ApplicationPartialRefundOrder:
        optname = OPERATION_REFUNDORDER;
        name = QString::fromLocal8Bit(OPERATIONNAME_AGREE);
        return true;
    default:
        return false;
    }
}

void MainForm::getOrderChannelName(OrderObject *order, QString &channelname)
{
    if(QString("saas").compare(order->channel, Qt::CaseInsensitive) == 0 &&
            (order->order_type == TimelyTakeout || order->order_type == AppointmentTakeout))
        channelname = QString::fromLocal8Bit("外卖");
    else if(QString("saas").compare(order->channel, Qt::CaseInsensitive) == 0 &&
            (order->order_type == TimelyDining || order->order_type == AppointmentDining))
        channelname = QString::fromLocal8Bit("堂吃");
    else if(QString("saas").compare(order->channel, Qt::CaseInsensitive) == 0 &&
            (order->order_type == TimelyInvite || order->order_type == AppointmentInvite))
        channelname = QString::fromLocal8Bit("自提");
    else
        channelname = order->channel_name;
}

void MainForm::onChangeOrderStatus(OrderObject *orderObject)
{
    QString orderid = orderObject->order_id;
    QPushButton *tabBtn = NULL;
    QTableWidget *table = NULL;
    QString tmpchannel;
    QString optname;
    QString name;
    bool flag = false;

    //删除订单
    deleteOrderItem(orderid);

    //获取订单table页
    getTableAndBtn(orderObject, table, tabBtn);

    //获取渠道名称
    getOrderChannelName(orderObject, tmpchannel);

    //获取主界面操作按钮名称和类型
    flag = getOrderOptAndName(orderObject, optname, name);

    //插入新订单
    m_order_table_map.insert(orderObject->order_id, table);

    _SetTablesSortEnable(false);
    table->insertRow(0);
    QTableWidgetItem *item0 = new QTableWidgetItem(QString::number(orderObject->order_index)+"#"+tmpchannel);
    item0->setTextAlignment(Qt::AlignCenter);
    table->setItem(0, 0, item0);  // 渠道
    QTableWidgetItem *item1 = new QTableWidgetItem(orderObject->order_id);
    item1->setTextAlignment(Qt::AlignCenter);
    table->setItem(0, 1, item1);  // 订单ID
    QTableWidgetItem *item2 = new QTableWidgetItem(QString::number(orderObject->shop_fee/100.0));
    item2->setTextAlignment(Qt::AlignCenter);
    table->setItem(0, 2, item2);  // 金额
    QTableWidgetItem *item3 = new QTableWidgetItem(orderObject->customer);
    item3->setTextAlignment(Qt::AlignCenter);
    table->setItem(0, 3, item3);  // 姓名
    QTableWidgetItem *item4 = new QTableWidgetItem(orderObject->phone);
    item4->setTextAlignment(Qt::AlignCenter);
    table->setItem(0, 4, item4);  // 联系方式
    QTableWidgetItem *item5 = new QTableWidgetItem(QDateTime::fromTime_t(orderObject->create_time).toString("MM-dd hh:mm"));
    item5->setTextAlignment(Qt::AlignCenter);
    table->setItem(0, 5, item5);  // 下单时间
    if(table != ui->mainTableFinsh && table != ui->mainTableOther)
    {
        QWidget *pWdg = new QWidget(table);
        QHBoxLayout *hLayout = new QHBoxLayout(pWdg);
        QPushButton * pBtn = new QPushButton(pWdg);
        pBtn->setFixedSize(70, 30);
        pBtn->setFocusPolicy(Qt::NoFocus);
        pBtn->setObjectName("mainProcBtn");
        pBtn->setProperty("orderId", orderObject->order_id);
        pBtn->setProperty("ordertype", orderObject->order_type);
        pBtn->setProperty("operation", optname);
        pBtn->setText(name);
        hLayout->addWidget(pBtn);
        hLayout->setMargin(0);
        pWdg->setLayout(hLayout);
        table->setCellWidget(0, 6, pWdg);   // 操作按钮
        connect(pBtn, &QPushButton::clicked, this, &MainForm::onMainProcBtnClicked);
    }

    QString btnText = QString("%1\n%2").arg(table->rowCount()).arg(tabBtn->property("name").toString());
    tabBtn->setText(btnText);
    _SetTablesSortEnable(true);
    //table->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
}

void MainForm::onShowDeliverPickForm(const QString &orderId, const QList<DeliverObject> &delivers)
{
    m_pickForm->SetDeliversInfo(orderId, delivers);
    m_pickForm->show();
}

void MainForm::on_mainBtnUp_clicked()
{
    m_currentTable->scrollToTop();
}

void MainForm::on_mainBtnDown_clicked()
{
    m_currentTable->scrollToBottom();
}

void MainForm::onMainTableItemClicked(QTableWidgetItem *item)
{
    QString orderId = ((QTableWidget*)sender())->item(item->row(), 1)->text();

    OrderObject order;

    if(!PosOrderPool::GetOrderObject(orderId, order))
        return ;

    onHideAlert();
    m_detailForm->InitData(&order);
    m_detailForm->show();

}

void MainForm::on_mainEdtSearch_clicked()
{
    m_padForm->show();
}

void MainForm::onNumClicked(const QString &num)
{
    ui->mainEdtSearch->setText(ui->mainEdtSearch->text().append(num));
}

void MainForm::onNumDelete()
{
    QString text = ui->mainEdtSearch->text();
    ui->mainEdtSearch->setText(text.left(text.length()-1));
}

void MainForm::onSearchResultItemClicked(QListWidgetItem *item)
{
    ui->mainEdtSearch->clear();
    m_padForm->hide();
    m_resultForm->hide();
    QString str=item->text();

    QLOG_DEBUG() << "mainForm input 0" << str;

    str=str.mid(4);

    QLOG_DEBUG() << "mainForm input 1" << str;

    QString y = "  ";
    str=str.mid(0,str.indexOf(y));

    QLOG_DEBUG() << "mainForm input 2" << str;
    //emit getOrderDetails(str);

    OrderObject order;
    if(!PosOrderPool::GetOrderObject(str, order))
        return ;

    onHideAlert();
    m_detailForm->InitData(&order);
    m_detailForm->show();
}
void MainForm::onEntryResult(OrderObject *orderObject, int type)
{
    _SetTablesSortEnable(false);
    QTableWidget *table = NULL;
    QPushButton *tabBtn = NULL;

    getTableAndBtn(orderObject, table, tabBtn);

    int rowcount=table->rowCount();
    for(int i=0;i<rowcount;i++)
    {
        if(table->item(i,1)->text()==orderObject->order_id)
        {
            if(type==0)
            {
                table->item(i,0)->setTextColor(QColor(255,0,0));
                table->item(i,1)->setTextColor(QColor(255,0,0));
                table->item(i,2)->setTextColor(QColor(255,0,0));
                table->item(i,3)->setTextColor(QColor(255,0,0));
                table->item(i,4)->setTextColor(QColor(255,0,0));
                table->item(i,5)->setTextColor(QColor(255,0,0));
                table->item(i,6)->setTextColor(QColor(255,0,0));
                break;
            }
            if(type==1)
            {
                table->item(i,0)->setTextColor(QColor(98, 98, 98));
                table->item(i,1)->setTextColor(QColor(98, 98, 98));
                table->item(i,2)->setTextColor(QColor(98, 98, 98));
                table->item(i,3)->setTextColor(QColor(98, 98, 98));
                table->item(i,4)->setTextColor(QColor(98, 98, 98));
                table->item(i,5)->setTextColor(QColor(98, 98, 98));
                table->item(i,6)->setTextColor(QColor(98, 98, 98));
                break;
            }
        }
    }
    _SetTablesSortEnable(true);
}

void MainForm::on_mainBtnPrt_clicked()
{
    m_prtForm->show();
}

void MainForm::onSerachOrder(const QString &key)
{
    if(key.isEmpty())
    {
        m_resultForm->hide();
        return;
    }

    QMap<QString, QString> map;

    m_resultForm->clear();
    if(PosOrderPool::GetSearchOrder(key, map))
    {
        QMap<QString,QString>::const_iterator order;
        for(order=map.begin(); order!=map.end(); order++)
        {
            QListWidgetItem* item=new QListWidgetItem();
            item->setText(QString::fromLocal8Bit("订单号:") + order.key() + QString::fromLocal8Bit("  手机号:") + order.value());
            m_resultForm->addItem(item);
        }
        m_resultForm->show();
    }
}

void MainForm::on_mainBtnpickup_clicked()
{
    this->m_pickupForm->Initshow();
}

void MainForm::show_Detail_PickUpCode(QString pickupid)
{
    OrderObject order;
    PosOrderPool::GetOrderObject(pickupid, order);
    m_detailForm->InitData(&order, true);
    m_detailForm->show();
}
