#ifndef LOGINFORM_H
#define LOGINFORM_H

#include <QDialog>
#include <QVariantMap>

#include "clickedLineEdit.h"
#include "alertForm.h"

namespace Ui {
class LoginForm;
}

class LoginForm : public QDialog
{
    Q_OBJECT

public:
    explicit LoginForm(QWidget *parent = 0);
    ~LoginForm();

    void showfull();

    virtual bool event(QEvent *e);

    void onShowAlert(AlertForm::Type type, const QString &msg);
    void onHideAlert();
signals:
    void showfloat();
    void showmainform();
    void login(QVariantMap storeinfo);

public slots:
    void GetCurrLineEdit();

private slots:
    void on_pushButton_login_clicked();
    void number_btn_click();

    void on_pushButton_close_clicked();

    void SetStoreInfo();
private:
    Ui::LoginForm *ui;

    ClickedLineEdit *_curr_lineedit;

    bool is_login;

    // 通知窗口
    AlertForm *m_alertForm;
};

#endif // LOGINFORM_H
