﻿#include "loginform.h"
#include "ui_loginform.h"

#include "event/posevent.h"
#include "event/fmapplication.h"

#include "preDefine.h"

#include <QDebug>
#include <QVariantMap>
#include <QSettings>


#include <QsLog.h>

LoginForm::LoginForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LoginForm)
{
    ui->setupUi(this);

    is_login = false;

    ui->label_logotitle->setText(QString::fromLocal8Bit("非码SaaS点餐小程序门店管理"));

    connect(ui->lineEdit_account, &ClickedLineEdit::clicked, this, &LoginForm::GetCurrLineEdit);
    connect(ui->lineEdit_partnerid, &ClickedLineEdit::clicked, this, &LoginForm::GetCurrLineEdit);
    connect(ui->lineEdit_pwd, &ClickedLineEdit::clicked, this, &LoginForm::GetCurrLineEdit);
    connect(ui->lineEdit_posno, &ClickedLineEdit::clicked, this, &LoginForm::GetCurrLineEdit);
    connect(ui->lineEdit_storeid, &ClickedLineEdit::clicked, this, &LoginForm::GetCurrLineEdit);

    connect(ui->pushButton_0, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_1, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_2, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_3, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_4, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_5, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_6, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_7, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_8, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_9, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_clear, &QPushButton::clicked, this, &LoginForm::number_btn_click);
    connect(ui->pushButton_del, &QPushButton::clicked, this, &LoginForm::number_btn_click);

    _curr_lineedit = ui->lineEdit_partnerid;
    _curr_lineedit->setFocus();

    setWindowFlags(Qt::FramelessWindowHint);


    m_alertForm = new AlertForm(this);



    FMApplication::subscibeEvent(this, PosEvent::s_login_status);
    FMApplication::subscibeEvent(this, PosEvent::s_opt_status);
    FMApplication::subscibeEvent(this, PosEvent::s_show_login);

}

void LoginForm::onHideAlert()
{
    m_alertForm->hide();
}


void LoginForm::onShowAlert(AlertForm::Type type, const QString &msg)
{

    if(this->isVisible())
    {
        m_alertForm->SetContent(type, msg);
        m_alertForm->show();
    }
}


LoginForm::~LoginForm()
{
    delete ui;
}

void LoginForm::SetStoreInfo()
{
    QString configfile = qApp->applicationDirPath() + "/" + STOREINFO_NAME;

    QString storeid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_STOREID).toString();
    QString partnerid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_PARNETID).toString();
    QString userid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_USERID).toString();
    QString pwd = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_PWD).toString();
    QString stationid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_STATIONIID).toString();

    if(storeid.isEmpty() || partnerid.isEmpty() || userid.isEmpty() || pwd.isEmpty() || stationid.isEmpty())
        return ;

    ui->lineEdit_partnerid->setText(partnerid);
    ui->lineEdit_storeid->setText(storeid);
    ui->lineEdit_posno->setText(stationid);
    ui->lineEdit_account->setText(userid);
    ui->lineEdit_pwd->setText(pwd);
}

void LoginForm::showfull()
{
    if(!is_login)
    {
        SetStoreInfo();
        this->showFullScreen();
        return ;
    }

    this->hide();
    //emit showmainform();
    DEFAULTPOSTEVENT(PosEvent::s_show_mainform, "");
}

bool LoginForm::event(QEvent *e)
{

    if(e->type() == PosEvent::s_opt_status)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_ORDERSTATUS) && value[EVENT_KEY_ORDERSTATUS].toInt() == 0)
        {
            if(!this->isHidden())
                onShowAlert(AlertForm::LOADING, value[EVENT_KEY_MSG].toString());
            return true;
        }

        if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == false)
        {
            QLOG_INFO() << value[EVENT_KEY_MSG].toString();
            if(!this->isHidden())
                onShowAlert(AlertForm::ERROR, value[EVENT_KEY_MSG].toString());
        }
        else if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == true)
        {
            if(!this->isHidden())
                onShowAlert(AlertForm::SUCCESS, value[EVENT_KEY_MSG].toString());
        }
        return true;
    }

    if(e->type() == PosEvent::s_show_login)
    {
        this->showfull();
        return true;
    }

    if(e->type() == PosEvent::s_login_status)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == false)
        {
            QLOG_INFO() << value[EVENT_KEY_MSG].toString();
            if(!this->isHidden())
                onShowAlert(AlertForm::ERROR, value[EVENT_KEY_MSG].toString());
        }
        else if(value.contains(EVENT_KEY_STATUS) && value[EVENT_KEY_STATUS].toBool() == true)
        {
            this->hide();
            onHideAlert();
            is_login = true;
            //emit showmainform();
            DEFAULTPOSTEVENT(PosEvent::s_show_mainform, "");
        }
        return true;
    }

    return QDialog::event(e);
}

void LoginForm::GetCurrLineEdit()
{
    _curr_lineedit = qobject_cast<ClickedLineEdit*>(sender());
}

void LoginForm::on_pushButton_login_clicked()
{
    QVariantMap map;

    if(ui->lineEdit_account->text().isEmpty() ||
       ui->lineEdit_pwd->text().isEmpty() ||
       ui->lineEdit_partnerid->text().isEmpty() ||
       ui->lineEdit_posno->text().isEmpty() ||
       ui->lineEdit_storeid->text().isEmpty() )
    {
        onShowAlert(AlertForm::ERROR, QString::fromLocal8Bit("商户号/门店号/POS编号/账号/密码均不能为空"));
        return ;
    }

    map.insert(JSON_STOREID, ui->lineEdit_storeid->text());
    map.insert(JSON_STATIONID, ui->lineEdit_posno->text());
    map.insert(JSON_KEY_USERID, ui->lineEdit_account->text());
    map.insert(JSON_KEY_PWD, ui->lineEdit_pwd->text());
    map.insert(JSON_KEY_PARTNERID, ui->lineEdit_partnerid->text());

    POSTEVENTTYPE(PosEvent::s_login_storeinfo, map, QVariantMap);
}

void LoginForm::number_btn_click()
{
    QPushButton *btn = qobject_cast<QPushButton*>(sender());

    if(btn == ui->pushButton_clear)
    {
        _curr_lineedit->clear();
    }
    else if(btn == ui->pushButton_del)
    {
        QString text = _curr_lineedit->text();

        _curr_lineedit->setText(text.left(text.size() - 1));

    }
    else
    {
        _curr_lineedit->setText(_curr_lineedit->text() + btn->property("number").toString());
    }
}

void LoginForm::on_pushButton_close_clicked()
{
    this->hide();
    //emit showfloat();
    DEFAULTPOSTEVENT(PosEvent::s_show_float, "");
}
