﻿#ifndef DETAILFORM_H
#define DETAILFORM_H

#include <QDialog>
#include <QTableWidget>
#include "Model/orderObject.h"
#include "Model/deliverObject.h"
#include "RejectForm.h"
#include "alertForm.h"

namespace Ui {
class DetailForm;
}

class DetailForm : public QDialog
{
    Q_OBJECT

public:
    explicit DetailForm(QWidget *parent = 0);
    ~DetailForm();

    /* 功能:初始化数据
     * 参数:[1]订单对象 [2]扫码取餐或普通订单展示
     * 返回:NULL
     * */
    void InitData(OrderObject* orderObject, bool flag = false);
private:
    Ui::DetailForm *ui;

    OrderObject *m_orderObject;
    RejectForm* m_rejectForm ;
    QString _orderid;

    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();

signals:
    void showAlert(AlertForm::Type type, const QString& msg);
    /* 功能:处理订单
     * 参数:[1]操作动作名[2]订单编号[3]配送员信息
     * 返回:NULL
     * */
    void processOrder(const QString& operation, const QString& orderId, const DeliverObject& deliverObj);
    /* 功能:通知补录订单
     * 参数:[1]订单
     * 返回:NULL
     * */
    void doReEntry(OrderObject*);
    /* 功能:通知退款相关操作
     * 参数:[1]单号[2]退款理由[3]退款类型
     * 返回:NULL
     * */
    void processRejectOrder(const QString& orderId,const int& reasonCode,const QString& reason,const int& reasontype);
    //void processReportOrder(const QString &orderId, const QString &business, const int &status, const QString &reason, const int &bill_fee);

private slots:
    /* 功能:处理订单按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void onOperaBtnClicked();
    /* 功能:处理重新打印按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void on_detailBtn1_clicked();
    /* 功能:处理补录按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void on_detailBtn0_clicked();
    /* 功能:获取订单操作和操作名称
     * 参数:[1]订单[2]操作名称[3]按钮名称
     * 返回：
     * */
    bool getOrderOptAndName(OrderObject *order, QString &optname, QString &name);
    /* 功能:获取订单其他操作和操作名称
     * 参数:[1]订单[2]操作名称[3]按钮名称
     * 返回：
     * */
    bool getOtherOrderOptAndName(OrderObject *order, QString &optname, QString &name);
};

#endif // DETAILFORM_H
