﻿#ifndef ALERTFORM_H
#define ALERTFORM_H

// 通知窗口
#include <QDialog>
#include <QMovie>

namespace Ui {
class AlertForm;
}

class AlertForm : public QDialog
{
    Q_OBJECT

public:
    explicit AlertForm(QWidget *parent = 0);
    ~AlertForm();

    typedef enum
    {
        SUCCESS=0,
        ERROR,
        LOADING,
        WARNING
    }Type;


    /* 功能:设置显示内容
     * 参数:[1]窗体类型[2]信息内容
     * 返回:NULL
     * */
    void SetContent(AlertForm::Type type, const QString& msg);

private:
    Ui::AlertForm *ui;
    // 动画对象
    QMovie *m_movie;

    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();

private slots:
    void on_alertBtnOk_clicked();
};

#endif // ALERTFORM_H
