#include "alertForm.h"
#include "ui_alertForm.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "QsLog.h"

AlertForm::AlertForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AlertForm)
{
    ui->setupUi(this);

    _Init();
}

AlertForm::~AlertForm()
{
    delete ui;
}


void AlertForm::SetContent(AlertForm::Type type, const QString &msg)
{
    switch(type)
    {
    case SUCCESS:
        ui->alertBtnOk->show();
        ui->alertLabOk->show();
        ui->alertLabIng->hide();
        ui->alertLabError->hide();
        ui->alertLabWarn->hide();
        break;
    case ERROR:
        ui->alertBtnOk->show();
        ui->alertLabOk->hide();
        ui->alertLabIng->hide();
        ui->alertLabError->show();
        ui->alertLabWarn->hide();
        break;
    case LOADING:
        ui->alertBtnOk->hide();
        ui->alertLabOk->hide();
        ui->alertLabIng->show();
        ui->alertLabError->hide();
        ui->alertLabWarn->hide();
        break;
    case WARNING:
        ui->alertBtnOk->show();
        ui->alertLabOk->hide();
        ui->alertLabIng->hide();
        ui->alertLabError->hide();
        ui->alertLabWarn->show();


    }
    ui->alertLabMsg->setText(msg);
    ui->alertLabMsg->setWordWrap(true);

    return;
}

void AlertForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);

    // 初始化Gif动画
    m_movie = new QMovie(this);
    m_movie->setFileName(":loading.gif");
    ui->alertLabIng->setMovie(m_movie);
    ui->alertLabIng->setScaledContents(true);
    m_movie->start();

    ui->alertLabOk->hide();
    ui->alertLabIng->hide();
    ui->alertLabError->hide();
}

void AlertForm::on_alertBtnOk_clicked()
{
    this->accept();
    return;
}
