﻿#include "RejectForm.h"
#include "ui_RejectForm.h"
#include "preDefine.h"
#include <QRadioButton>

RejectForm::RejectForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RejectForm)
{
    ui->setupUi(this);

    this->setWindowFlags(windowFlags()|Qt::FramelessWindowHint|Qt::Dialog);

    this->move(parent->pos().x()+(parent->width()-this->width())/2,
               parent->pos().y()+(parent->height()-this->height())/2);

    m_rejectCode = 5;
    m_rejectReason=ui->rejectRbtn0->text();
    ui->rejectRbtn0->toggle();
}

RejectForm::~RejectForm()
{
    delete ui;
}

int RejectForm::GetReasonCode()
{
    return m_rejectCode;
}

QString RejectForm::GetReason()
{
    return m_rejectReason;
}

void RejectForm::InitUi(int rejecttype)
{
    switch (rejecttype) {
    case REJECTUITYPE_REFUSEREFUND:
        ui->rejectLabHead->setText(QString::fromLocal8Bit("请选择拒绝理由"));
        ui->rejectRbtn0->setText(QString::fromLocal8Bit("顾客已经收到商品"));
        ui->rejectRbtn1->setText(QString::fromLocal8Bit("顾客要求不合理"));
        ui->rejectRbtn2->setText(QString::fromLocal8Bit("平台问题"));
        ui->rejectRbtn3->setText(QString::fromLocal8Bit("其他原因"));
        ui->rejectBtnOk->setText(QString::fromLocal8Bit("拒绝"));
        ui->rejectRbtn4->hide();
        ui->rejectRbtn5->hide();
        break;
    case REJECTUITYPE_AGREEREFUND:
        ui->rejectLabHead->setText(QString::fromLocal8Bit("请选择同意理由"));
        ui->rejectRbtn0->setText(QString::fromLocal8Bit("骑手超时未送达"));
        ui->rejectRbtn1->setText(QString::fromLocal8Bit("骑手送达饮料渗漏破损"));
        ui->rejectRbtn2->setText(QString::fromLocal8Bit("骑手超时未来取餐"));
        ui->rejectRbtn3->setText(QString::fromLocal8Bit("骑手错送或遗漏"));
        ui->rejectBtnOk->setText(QString::fromLocal8Bit("同意"));
        ui->rejectRbtn4->hide();
        ui->rejectRbtn5->hide();
        break;
    case REJECTUITYPE_REFUSEORDER:
        ui->rejectLabHead->setText(QString::fromLocal8Bit("请选择拒单理由"));
        ui->rejectRbtn0->setText(QString::fromLocal8Bit("不在配送范围"));
        ui->rejectRbtn1->setText(QString::fromLocal8Bit("餐厅已打烊"));
        ui->rejectRbtn2->setText(QString::fromLocal8Bit("已售完"));
        ui->rejectRbtn3->setText(QString::fromLocal8Bit("菜品价格发生变化"));
        ui->rejectRbtn4->setText(QString::fromLocal8Bit("餐厅太忙"));
        ui->rejectRbtn5->setText(QString::fromLocal8Bit("联系不上用户"));
        ui->rejectBtnOk->setText(QString::fromLocal8Bit("拒单"));
        break;
    case REJECTUITYPE_CANCLEORDER:
        ui->rejectLabHead->setText(QString::fromLocal8Bit("请选择退单理由"));
        ui->rejectRbtn0->setText(QString::fromLocal8Bit("不在配送范围"));
        ui->rejectRbtn1->setText(QString::fromLocal8Bit("餐厅已打烊"));
        ui->rejectRbtn2->setText(QString::fromLocal8Bit("已售完"));
        ui->rejectRbtn3->setText(QString::fromLocal8Bit("菜品价格发生变化"));
        ui->rejectRbtn4->setText(QString::fromLocal8Bit("餐厅太忙"));
        ui->rejectRbtn5->setText(QString::fromLocal8Bit("联系不上用户"));
        ui->rejectBtnOk->setText(QString::fromLocal8Bit("退单"));
        break;
    default:
        break;
    }
}

void RejectForm::on_rejectBtnOk_clicked()
{

    this->accept();
}

void RejectForm::on_rejectBtnCancle_clicked()
{

    this->reject();
}

void RejectForm::on_rejectRbtn0_toggled(bool)
{
    QRadioButton *btn=(QRadioButton*)sender();
    m_rejectReason=btn->text();
    m_rejectCode = 1;
}

void RejectForm::on_rejectRbtn1_toggled(bool)
{
    QRadioButton *btn=(QRadioButton*)sender();
    m_rejectReason=btn->text();
    m_rejectCode = 2;
}

void RejectForm::on_rejectRbtn2_toggled(bool)
{
    QRadioButton *btn=(QRadioButton*)sender();
    m_rejectReason=btn->text();
    m_rejectCode = 3;
}

void RejectForm::on_rejectRbtn3_toggled(bool)
{
    QRadioButton *btn=(QRadioButton*)sender();
    m_rejectReason=btn->text();
    m_rejectCode = 4;
}

void RejectForm::on_rejectRbtn4_toggled(bool)
{
    QRadioButton *btn=(QRadioButton*)sender();
    m_rejectReason=btn->text();
    m_rejectCode = 5;
}

void RejectForm::on_rejectRbtn5_toggled(bool )
{
    QRadioButton *btn=(QRadioButton*)sender();
    m_rejectReason=btn->text();
    m_rejectCode = 6;
}
