#ifndef PRTMODELPOOL_H
#define PRTMODELPOOL_H

#include <QObject>
#include <QJsonObject>
#include <QMap>

class PrtModelPool : public QObject
{
    Q_OBJECT
private:
    explicit PrtModelPool(QObject *parent = 0);

public:
    static void InitPrtModelPool();

    bool event(QEvent *e);

    static bool GetPrtModel(int printType, QString &prtModel);

    static bool GetPrtLogo(int printType, QString &prtLogo);

    static bool GetPrtQrCode(int printType, QString &prtQrCode);

signals:

public slots:

private:
    static void prasePrtModel(QJsonObject prtModel);

private:
    static QMap<int, QString> _prtType_prtModel_map;

    static QMap<int, QString> _prtType_logo_map;

    static QMap<int, QString> _prtType_qrCode_map;

};

#endif // PRTMODELPOOL_H
