#include "prtmodelpool.h"
#include "preDefine.h"
#include "QsLog.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonArray>


QMap<int, QString> PrtModelPool::_prtType_prtModel_map;
QMap<int, QString> PrtModelPool::_prtType_logo_map;
QMap<int, QString> PrtModelPool::_prtType_qrCode_map;

PrtModelPool::PrtModelPool(QObject *parent) : QObject(parent)
{
    FMApplication::subscibeEvent(this,PosEvent::s_get_prtmodel);
}

void PrtModelPool::InitPrtModelPool()
{
    static PrtModelPool prtmodelpool;
}

bool PrtModelPool::event(QEvent *e)
{
    if(e->type() == PosEvent::s_get_prtmodel)
    {
        QLOG_DEBUG() << "PosEvent::s_get_prtmodel : " << QThread::currentThreadId();

        QJsonObject json;

        GETEVENTINFO(json,e,QJsonObject);

        QLOG_DEBUG() << "PrtModelPool : " << json;

        //解析打印模板
        prasePrtModel(json);

        return true;
    }
}

bool PrtModelPool::GetPrtModel(int printType, QString &prtModel)
{
    if(_prtType_prtModel_map.contains(printType)) {
        prtModel = _prtType_prtModel_map[printType];
        return true;
    }
    return false;
}

bool PrtModelPool::GetPrtLogo(int printType, QString &prtLogo)
{
    if(_prtType_logo_map.contains(printType)) {
        prtLogo = _prtType_logo_map[printType];
        return true;
    }
    return false;
}

bool PrtModelPool::GetPrtQrCode(int printType, QString &prtQrCode)
{
    if(_prtType_qrCode_map.contains(printType)) {
        prtQrCode = _prtType_qrCode_map[printType];
        return true;
    }
    return false;
}

void PrtModelPool::prasePrtModel(QJsonObject prtModel)
{
    QJsonArray array;
    if(prtModel.contains("result")) {
        QJsonObject result = prtModel["result"].toObject();
        if(result.contains("printTicketList")) {
            array = result["printTicketList"].toArray();
        }
    }

    for(int i = 0;i != array.size(); ++i) {
        if(array.at(i).toObject().contains("template") && array.at(i).toObject().contains("print_type")) {
            _prtType_prtModel_map.insert(array.at(i).toObject()["print_type"].toInt(), array.at(i).toObject()["template"].toString());
        } else {
            return;
        }

        if(array.at(i).toObject().contains("qr_Code") && array.at(i).toObject().contains("print_type")) {
            _prtType_qrCode_map.insert(array.at(i).toObject()["print_type"].toInt(), array.at(i).toObject()["qr_Code"].toString());
        } else {
            return;
        }

        if(array.at(i).toObject().contains("logo") && array.at(i).toObject().contains("print_type")) {
            _prtType_logo_map.insert(array.at(i).toObject()["print_type"].toInt(), array.at(i).toObject()["logo"].toString());
        } else {
            return;
        }
    }
}
