﻿#include "productObject.h"
#include <QJsonArray>


ProductObject::ProductObject(const ProductObject &p, QObject *parent):BaseObject(parent)
{
    qDeleteAll(sub_products);
    sub_products.clear();
    const QMetaObject *m = p.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, p.sub_products) {
        ProductObject *product=new ProductObject(*ptr,this);
        this->sub_products.append(product);
    }
}

ProductObject &ProductObject::operator =(const ProductObject &p)
{
    qDeleteAll(sub_products);
    sub_products.clear();
    const QMetaObject *m = p.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    foreach (auto ptr, p.sub_products) {
        ProductObject *product=new ProductObject(*ptr,this);
        this->sub_products.append(product);
    }
    return *this;
}

void ProductObject::FromJson(const QJsonObject &json)
{
    qDeleteAll(sub_products);
    sub_products.clear();
    FetchDataFromJson(json);
    QJsonArray products = json["sub_products"].toArray();
    foreach(QJsonValue product, products)
    {
        QJsonObject proJson = product.toObject();
        ProductObject *proObject = new ProductObject(this);
        proObject->FetchDataFromJson(proJson);
        sub_products.append(proObject);
    }
}

QString ProductObject::getPid() const
{
    return pid;
}
void ProductObject::setPid(const QString &v)
{
    pid = v;
}

QString ProductObject::getproperty_tags() const
{
    return property_tags;
}

void ProductObject::setproperty_tags(const QString &v)
{
    property_tags = v;
}

QString ProductObject::getName() const
{
    return name;
}
void ProductObject::setName(const QString &v)
{
    name = v;
}

QString ProductObject::getupc() const
{
    return upc;
}
void ProductObject::setupc(const QString &v)
{
    upc = v;
}

int ProductObject::getprice() const
{
    return price;
}
void ProductObject::setprice(const int &v)
{
    price = v;
}

int ProductObject::getProductAmount() const
{
    return product_amount;
}
void ProductObject::setProductAmount(const int &v)
{
    product_amount = v;
}

QString ProductObject::getstock_barcode() const
{
    return stock_barcode;
}

void ProductObject::setstock_barcode(const QString &v)
{
    stock_barcode = v;
}

QString ProductObject::getproduct_code() const
{
    return product_code;
}

void ProductObject::setproduct_code(const QString &v)
{
    product_code = v;
}
