#ifndef POSSTALLSPOOL_H
#define POSSTALLSPOOL_H

#include <QObject>
#include <QVariantMap>
#include <QJsonObject>

class PosStallsPool : public QObject
{
    Q_OBJECT
private:
    explicit PosStallsPool(QObject *parent = 0);

public:
    static void InitPosStallsPool();

    bool event(QEvent *e);

    static bool GetProdNameList(QString stallsid, QStringList &prodnames);

    static bool GetProdIDList(QString stallsid, QStringList &prodids);

    static bool GetStallsName(QString stallsid, QString &stallsname);

    static bool GetStallsArgv(QString stallsid, int &pagedepart, int &proddepart, int &pagenum);
signals:

public slots:

private:
    //解析订阅档口改变事件中拿到的档口信息
    static void praseGetStallsInfo(QJsonArray array);
    //获取商品列表
    static void praseGetProdInfo(QJsonArray array, QStringList &prodidlist, QStringList &prodnames);

private:
    //档口id对应的商品id列表
    static QMap<QString, QStringList> _stallsid_prodids_map;

    //档口id对应的商品名称集合
    static QMap<QString, QStringList> _stallsid_prodnames_map;

    //档口ID对应的档口名称
    static QVariantMap _stallsid_stallsname_map;

    //档口对应打印页数
    static QVariantMap _stalls_pagenum_map;

    //档口对应打印商品页是否独立
    static QVariantMap _stalls_pagedepart_map;

    //档口对应商品是否独占一行
    static QVariantMap _stalls_proddepart_map;
};

#endif // POSSTALLSPOOL_H
