#include "posstallspool.h"
#include "preDefine.h"
#include "QsLog.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonArray>

QMap<QString, QStringList> PosStallsPool::_stallsid_prodids_map;
QMap<QString, QStringList> PosStallsPool::_stallsid_prodnames_map;
QVariantMap PosStallsPool::_stallsid_stallsname_map;
QVariantMap PosStallsPool::_stalls_pagenum_map;
QVariantMap PosStallsPool::_stalls_pagedepart_map;
QVariantMap PosStallsPool::_stalls_proddepart_map;

PosStallsPool::PosStallsPool(QObject *parent) : QObject(parent)
{
    FMApplication::subscibeEvent(this,PosEvent::s_change_stalls);
}

void PosStallsPool::InitPosStallsPool()
{
    static PosStallsPool stallspool;
}

bool PosStallsPool::event(QEvent *e)
{
    if(e->type() == PosEvent::s_change_stalls)
    {
        QLOG_DEBUG() << "PosEvent::s_change_stalls : " << QThread::currentThreadId();

        QJsonArray list;

        GETEVENTINFO(list,e,QJsonArray);

        QLOG_DEBUG() << "PosStallsPoollist : " << list;

        //解析档口信息
        praseGetStallsInfo(list);

        return true;
    }
}

bool PosStallsPool::GetProdNameList(QString stallsid, QStringList &prodnames)
{
    if(_stallsid_prodnames_map.contains(stallsid))
    {
        prodnames = _stallsid_prodnames_map[stallsid];
        return true;
    }
    return false;
}

bool PosStallsPool::GetProdIDList(QString stallsid, QStringList &prodids)
{
    if(_stallsid_prodids_map.contains(stallsid))
    {
        prodids = _stallsid_prodids_map[stallsid];
        return true;
    }
    return false;
}

bool PosStallsPool::GetStallsName(QString stallsid, QString &stallsname)
{
    if(_stallsid_stallsname_map.contains(stallsid))
    {
        stallsname = _stallsid_stallsname_map[stallsid].toString();
        return true;
    }
    return false;
}

bool PosStallsPool::GetStallsArgv(QString stallsid, int &pagedepart, int &proddepart, int &pagenum)
{
    if(_stalls_pagedepart_map.contains(stallsid) &&
            _stalls_pagenum_map.contains(stallsid) &&
            _stalls_proddepart_map.contains(stallsid))
    {
        pagedepart = _stalls_pagedepart_map[stallsid].toInt();
        proddepart = _stalls_proddepart_map[stallsid].toInt();
        pagenum = _stalls_pagenum_map[stallsid].toInt();
        return true;
    }
    return false;
}

void PosStallsPool::praseGetStallsInfo(QJsonArray array)
{
    _stallsid_prodids_map.clear();
    _stallsid_prodnames_map.clear();
    _stallsid_stallsname_map.clear();
    _stalls_pagenum_map.clear();
    _stalls_pagedepart_map.clear();
    _stalls_proddepart_map.clear();

    //QLOG_DEBUG() << "PosStallsPool::praseGetStallsInfo" << array;

    foreach (auto v, array)
    {
        QJsonObject obj = v.toObject();

        QString stallsid, stallsname;
        int pagedepart = 0, pagenum = 0, proddepart = 0;
        QStringList prodids, prodnames;

        //QLOG_DEBUG() << "---obj---" << obj;

        if(obj.contains(STALLS_KEY_FILEID) && obj.contains(STALLS_KEY_FILENAME) && obj.contains(STALLS_KEY_PRODUCTLIST))
        {

            //QLOG_DEBUG() << "---obj" << obj;

            stallsid = QString::number(obj[STALLS_KEY_FILEID].toInt());
            stallsname = obj[STALLS_KEY_FILENAME].toString();
            QJsonArray prodarray = obj[STALLS_KEY_PRODUCTLIST].toArray();
            praseGetProdInfo(prodarray, prodids, prodnames);

            //0默认 1新加
            int isdefault = 1;

            if(obj.contains(STALLS_KEY_DEFAULT))
                isdefault = obj[STALLS_KEY_DEFAULT].toInt();

            if(!prodids.empty() && !prodnames.isEmpty() && isdefault == 1)
            {
                if(obj.contains(STALLS_KEY_PAGEDEPART) && obj.contains(STALLS_KEY_PORDDEPART) && obj.contains(STALLS_KEY_PAGENUM))
                {
                    pagedepart = obj[STALLS_KEY_PAGEDEPART].toInt();
                    proddepart = obj[STALLS_KEY_PORDDEPART].toInt();
                    pagenum = obj[STALLS_KEY_PAGENUM].toInt();

                    pagenum = (pagenum == 0 ? 1 : pagenum);

                    _stalls_pagenum_map.insert(stallsid, pagenum);
                    _stalls_pagedepart_map.insert(stallsid, pagedepart);
                    _stalls_proddepart_map.insert(stallsid, proddepart);
                }

                _stallsid_prodids_map.insert(stallsid, prodids);
                _stallsid_prodnames_map.insert(stallsid, prodnames);
                _stallsid_stallsname_map.insert(stallsid, stallsname);
            }
            else if(isdefault == 0)
            {
                if(obj.contains(STALLS_KEY_PAGEDEPART) && obj.contains(STALLS_KEY_PORDDEPART) && obj.contains(STALLS_KEY_PAGENUM))
                {
                    pagedepart = obj[STALLS_KEY_PAGEDEPART].toInt();
                    proddepart = obj[STALLS_KEY_PORDDEPART].toInt();
                    pagenum = obj[STALLS_KEY_PAGENUM].toInt();

                    pagenum = (pagenum == 0 ? 1 : pagenum);

                    _stalls_pagenum_map.insert(stallsid, pagenum);
                    _stalls_pagedepart_map.insert(stallsid, pagedepart);
                    _stalls_proddepart_map.insert(stallsid, proddepart);
                }

                QStringList tmplist1,tmplist2;

                tmplist2.append(QString::fromUtf8("\xE6\x89\x80\xE6\x9C\x89\xE5\x95\x86\xE5\x93\x81"));
                tmplist1.append("DEFAULT");

                _stallsid_prodids_map.insert(stallsid, tmplist1);
                _stallsid_prodnames_map.insert(stallsid, tmplist2);
                _stallsid_stallsname_map.insert(stallsid, stallsname);
            }
        }
    }

    QLOG_DEBUG() << "_stallsid_prodid_map:" << _stallsid_prodids_map;
    QLOG_DEBUG() << "_stallsid_prodnames_map:" << _stallsid_prodnames_map;
    QLOG_DEBUG() << "_stallsid_stallsname_map:" << _stallsid_stallsname_map;
    QLOG_DEBUG() << "_stalls_pagenum_map:" << _stalls_pagenum_map;
    QLOG_DEBUG() << "_stalls_pagedepart_map:" << _stalls_pagedepart_map;
    QLOG_DEBUG() << "_stalls_proddepart_map:" << _stalls_proddepart_map;

    if(!_stallsid_stallsname_map.empty())
        POSTEVENTTYPE(PosEvent::s_show_stalls, _stallsid_stallsname_map, QVariantMap);
}

void PosStallsPool::praseGetProdInfo(QJsonArray array, QStringList &prodids, QStringList &prodnames)
{
    foreach (auto v, array)
    {
        QJsonObject obj = v.toObject();

        if(obj.contains(STALLS_KEY_FILEPRODUCT) && obj.contains(STALLS_KEY_FILEPRODUCTID))
        {
            prodids.append(obj[STALLS_KEY_FILEPRODUCTID].toString());
            prodnames.append(obj[STALLS_KEY_FILEPRODUCT].toString());
        }
    }
}

