#ifndef POSPRTPOOL_H
#define POSPRTPOOL_H

#include <QObject>
#include <QVariantMap>

class PosPrtPool : public QObject
{
    Q_OBJECT
private:
    explicit PosPrtPool(QObject *parent = 0);

public:
    QVariantMap prtMap() const;

    static bool GetPrtConfig(QString prtid, QVariantMap &prtconfig);
    static bool GetPrtStalls(QString prtid, QString &stallsname);
    static bool GetPrtType(QString prtid, int &prttype);
    static bool GetPrtInfo(QString prtid, QVariantMap &map);
    static QStringList prtlist();
    static void InitPrtPool();

    bool event(QEvent *e);
signals:

public slots:

private:
    void loadOrders();

    static bool SavaPrtInfo(const QVariantMap &prtinfo);

    static void DeletePrtInfo(const QString &prt);
private:
    //<打印机编号, 打印>
    static QMap<QString, QVariantMap> _prtMap;
    //打印机列表
    static QStringList _prtList;
};

#endif // POSPRTPOOL_H
