#include "posprtpool.h"
#include "preDefine.h"
#include "base/DB/fm_database.h"
#include "QsLog.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include <QSqlQuery>
#include <QJsonDocument>
#include <QJsonObject>

QMap<QString, QVariantMap> PosPrtPool::_prtMap;
QStringList PosPrtPool::_prtList;

PosPrtPool::PosPrtPool(QObject *parent) : QObject(parent)
{
    loadOrders();

    FMApplication::subscibeEvent(this,PosEvent::s_change_prt);
    FMApplication::subscibeEvent(this,PosEvent::s_delete_prt);
}

void PosPrtPool::InitPrtPool()
{
    static PosPrtPool prtpool;
}


bool PosPrtPool::event(QEvent *e)
{
    if(e->type() == PosEvent::s_change_prt)
    {
        QLOG_DEBUG() << "PosEvent::s_save_prt : " << QThread::currentThreadId();

        QVariantMap info;

        GETEVENTINFO(info,e,QVariantMap);

        QLOG_DEBUG() << "info : " << info;

        SavaPrtInfo(info);

        return true;
    }

    if(e->type() == PosEvent::s_delete_prt)
    {
        QLOG_DEBUG() << "PosEvent::s_delete_prt : " << QThread::currentThreadId();

        QString prtid;

        QLOG_DEBUG() << "prtid:" << prtid;

        GETEVENTINFO(prtid, e, QString);

        DeletePrtInfo(prtid);

        QLOG_DEBUG() << "_prtList:" << _prtList;
        QLOG_DEBUG() << "_prtMap:" << _prtMap;


        return true;
    }

    return QObject::event(e);
}

void PosPrtPool::loadOrders()
{
    FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_PRTDBNAME);

    QStringList list;

    list.append(DB_KEY_PRTID);
    list.append(DB_KEY_PRTNAME);
    list.append(DB_KEY_PRTTYPE);
    list.append(DB_KEY_PRTCONFIG);
    list.append(DB_KEY_PRTSTALLS);

    QSqlQuery query;

    db.find(DEFAULT_PRTFORM, query, list);

    while(query.next())
    {

        QVariantMap map;

        map.insert(DB_KEY_PRTID, query.value(0).toString());
        map.insert(DB_KEY_PRTNAME, query.value(1).toString());
        map.insert(DB_KEY_PRTTYPE, query.value(2).toInt());
        map.insert(DB_KEY_PRTCONFIG, query.value(3).toString());
        map.insert(DB_KEY_PRTSTALLS, query.value(4).toString());

        _prtMap.insert(query.value(0).toString(), map);
        _prtList.append(query.value(0).toString());
    }
}

bool PosPrtPool::SavaPrtInfo(const QVariantMap &prtinfo)
{
    if(!(prtinfo.contains(DB_KEY_PRTID) || prtinfo.contains(DB_KEY_PRTNAME) ||
       prtinfo.contains(DB_KEY_PRTCONFIG) || prtinfo.contains(DB_KEY_PRTTYPE) ||
         prtinfo.contains(DB_KEY_PRTSTALLS)))
    {
        QLOG_DEBUG() << "PosPrtPool::SavaPrtInfo failed : " << prtinfo;
        return false;
    }

    QString tmpprtid = prtinfo[DB_KEY_PRTID].toString();

    _prtMap[tmpprtid] = prtinfo;


    if(!_prtList.contains(tmpprtid))
        _prtList.append(tmpprtid);

    return true;
}

void PosPrtPool::DeletePrtInfo(const QString &prt)
{
    _prtMap.remove(prt);
    _prtList.removeOne(prt);
    return ;
}

QStringList PosPrtPool::prtlist()
{
    return _prtList;
}

bool PosPrtPool::GetPrtConfig(QString prtid, QVariantMap &prtconfig)
{
    if(_prtMap.isEmpty() || !_prtMap.contains(prtid))
        return false;

    QString config = _prtMap[prtid][DB_KEY_PRTCONFIG].toString();

    QLOG_DEBUG() << "config" << config << _prtMap;

    QJsonDocument doc = QJsonDocument::fromJson(config.toUtf8().data());
    if(doc.isNull())
    {
        QLOG_DEBUG() << "PosPrtPool::GetPrtConfig json to string failed";
        return false;
    }

    QJsonObject json= doc.object();
    prtconfig = json.toVariantMap();

    return true;
}

bool PosPrtPool::GetPrtStalls(QString prtid, QString &stallsname)
{
    if(_prtMap.isEmpty() || !_prtMap.contains(prtid))
        return false;

    stallsname = _prtMap[prtid][DB_KEY_PRTSTALLS].toString();

    return true;
}

bool PosPrtPool::GetPrtType(QString prtid, int &prttype)
{
    if(_prtMap.isEmpty() || !_prtMap.contains(prtid))
        return false;

    prttype = _prtMap[prtid][DB_KEY_PRTTYPE].toInt();

    return true;
}

bool PosPrtPool::GetPrtInfo(QString prtid, QVariantMap &map)
{
    if(_prtMap.isEmpty() || !_prtMap.contains(prtid))
        return false;
    map = _prtMap[prtid];
    return true;
}

