#ifndef DISCOUNTOBJECT_H
#define DISCOUNTOBJECT_H

#include "baseObject.h"

class DiscountObject : public BaseObject
{
    Q_OBJECT
public:  
    DiscountObject(QObject *parent=0)
        :BaseObject(parent){price = 0;}
    DiscountObject(const DiscountObject& d,QObject *parent=0);
    DiscountObject &operator =(const DiscountObject& d);
    void FromJson(const QJsonObject& json);

    Q_PROPERTY (int price READ getPrice WRITE setPrice)
    Q_PROPERTY (QString name READ getName WRITE setName)
    Q_PROPERTY (QString accountId READ getAccountId WRITE setAccountId)
    Q_PROPERTY (int number READ getNumber WRITE setNumber)
    Q_PROPERTY (QString oaid READ getOaid WRITE setOaid)
    Q_PROPERTY (QString orderId READ getOrderId WRITE setOrderId)
    Q_PROPERTY (int sequence READ getSequence WRITE setSequence)
    Q_PROPERTY (int type READ getType WRITE setType)

    int price;
    QString name;
    QString accountId;
    int number;
    QString oaid;
    QString orderId;
    int sequence;
    int type;

    int getPrice() const;
    void setPrice(int value);
    QString getName() const;
    void setName(const QString &value);
    QString getAccountId() const;
    void setAccountId(const QString &value);
    int getNumber() const;
    void setNumber(int value);
    QString getOaid() const;
    void setOaid(const QString &value);
    QString getOrderId() const;
    void setOrderId(const QString &value);
    int getSequence() const;
    void setSequence(int value);
    int getType() const;
    void setType(int value);
};

#endif // DISCOUNTS_H
