#include "discountObject.h"

QString DiscountObject::getName() const
{
    return name;
}

void DiscountObject::setName(const QString &value)
{
    name = value;
}

QString DiscountObject::getAccountId() const
{
    return accountId;
}

void DiscountObject::setAccountId(const QString &value)
{
    accountId = value;
}

int DiscountObject::getNumber() const
{
    return number;
}

void DiscountObject::setNumber(int value)
{
    number = value;
}

QString DiscountObject::getOaid() const
{
    return oaid;
}

void DiscountObject::setOaid(const QString &value)
{
    oaid = value;
}

QString DiscountObject::getOrderId() const
{
    return orderId;
}

void DiscountObject::setOrderId(const QString &value)
{
    orderId = value;
}

int DiscountObject::getSequence() const
{
    return sequence;
}

void DiscountObject::setSequence(int value)
{
    sequence = value;
}

int DiscountObject::getType() const
{
    return type;
}

void DiscountObject::setType(int value)
{
    type = value;
}

DiscountObject::DiscountObject(const DiscountObject &d, QObject *parent):BaseObject(parent)
{
    const QMetaObject *m = d.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = d.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
}

DiscountObject &DiscountObject::operator =(const DiscountObject &d)
{
    const QMetaObject *m = d.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = d.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    return *this;
}

void DiscountObject::FromJson(const QJsonObject &json)
{
    price = 0;
    FetchDataFromJson(json);
}

int DiscountObject::getPrice() const
{
    return price;
}

void DiscountObject::setPrice(int value)
{
    price = value;
}
