﻿#include "baseObject.h"
#include <QStringList>
#include <QVariant>
#include "preDefine.h"
#include <QDateTime>

BaseObject::BaseObject(const BaseObject &p, QObject *parent):QObject(parent)
{
    const QMetaObject *m = p.metaObject();
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
}

BaseObject &BaseObject::operator =(const BaseObject &p)
{
    const QMetaObject *m = p.metaObject();
    //BaseObject np;
    for( int i=m->propertyOffset(); i<m->propertyCount(); i++)
    {
        QMetaProperty qmp = m->property(i);
        QString key = QString::fromLatin1(qmp.name());
        QVariant value = p.property(key.toUtf8());
        this->setProperty(key.toUtf8(), value);
    }
    return *this;
}

void BaseObject::FetchDataFromJson(const QJsonObject &json)
{
    QStringList keys = json.keys();
    foreach(QString key, keys)
    {
        setProperty(key.toUtf8(), json[key].toVariant());

        //对服务端传过来的delivery_time进行解析，如果为0表示为“我已到店”，则将送达时间改为当前时间
        if(key == JSON_KEY_DELIVERTIME)
        {
            if(json[JSON_KEY_DELIVERTIME].toInt() == 0)
            {
               setProperty(key.toUtf8(), (int)QDateTime::currentDateTime().toTime_t());
            }
        }

    }

    return;
}
