﻿#include <QApplication>
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "control/ordergetwork.h"
#include "model/posorderpool.h"
#include "model/posprtpool.h"
#include "model/posstallspool.h"
#include "view/mainForm.h"
#include "view/floatForm.h"
#include "view/newfloatform.h"
#include "view/newmainform.h"
#include "control/orderlocalizework.h"
#include "control/orderpushwork.h"
#include "control/orderprintwork.h"
#include "control/pickuporderwork.h"
#include "control/prtlocalizework.h"
#include "control/prtmodelgetwork.h"
#include "control/stallsgetwork.h"
#include "control/networkcheckwork.h"
#include "control/driverinfogetwork.h"
#include "control/orderentrywork.h"
#include "control/drivercancelordergetwork.h"
#include "base/Dump/dump.h"
#include "base/DB/fm_database.h"
//#include "view/loginform.h"
#include "view/newloginform.h"
#include <QVariantMap>
#include <QThread>
#include <QDir>
#include <QsLog.h>
#include <QResource>
#include <QSettings>
#include <QSqlQuery>
#include <QJsonObject>
#include <Windows.h>

#ifdef FM_MAIN_TEST



void LoadTheme(const QString& theme)
{
    QString rccPath = QString("%1/skin/%2.rcc").arg(qApp->applicationDirPath()).arg(theme);
    if(!QFile(rccPath).exists())
    {
        return;
    }
    QResource::registerResource(rccPath);

    QFile qssFile(QString(":/%1.qss").arg(theme));
    if(!qssFile.open(QFile::ReadOnly))
    {
        qDebug() << "failed";
        return;
    }

    qDebug() << "success";

    qApp->setStyleSheet(qssFile.readAll());
    qssFile.close();
}

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    LoadTheme(QString("deaufult"));

    LoginForm form;

    form.show();

    return a.exec();
}

//int main(int argc, char *argv[])
//{
//     QApplication a(argc, argv);

//     QsLogging::Logger &logger = QsLogging::Logger::instance();
//     logger.setLoggingLevel(QsLogging::TraceLevel);
//     QsLogging::DestinationPtr consleDest(QsLogging::DestinationFactory::MakeDebugOutputDestination());
//     logger.addDestination(consleDest);

//     OrderPushWork pwork;
//     QThread thread;

//     pwork.setToken("fff72b80-e745-4a2e-8ecb-9c184999d01c");
//     //pwork.setToken("1");

//     QVariantMap map;

//     map.insert(JSON_STOREID, "1036");
//     map.insert(JSON_STATIONID, "saas_bf_pos");
//     map.insert(JSON_KEY_USERID, "beiguo_saas");
//     map.insert(JSON_KEY_PWD, "beiguo_saas");
//     map.insert(JSON_KEY_PARTNERID, "1585");

//     //map.insert(JSON_KEY_PARTNERID, "song_test");
//     //map.insert(JSON_STOREID, "test");

//     pwork.setStoreinfo(map);

//     //QStringList list;

//     //list.append("118.89.167.51:9083");

//     //pwork.setServicelist(list);
//     pwork.setSerurl("http://118.89.167.51:9100/gateway?redirect_url=http://10.20.10.106:9140/queryIdleServer&access_token=7705bf51-0832-49e3-8a3d-ac9a57ff0d4b&bf_ver=1");

//     QObject::connect(&thread, &QThread::started, &pwork, &OrderPushWork::workStart);

//     pwork.moveToThread(&thread);

//     thread.start();

//     return a.exec();
//}

#else

using namespace QsLogging;

int  CheckOnly();
void LoadTheme(const QString& theme);
void InitLog();
void InitCfgInfo(QString &geturl, QString &pushurl, QString &autoconf);
void InitPtr();

//判断数据库是否存在，不存在且配置文件配置了打印机则将配置转成db
void ConfigToDB();

int main(int argc, char *argv[])
{
    SetUnhandledExceptionFilter(FMExcpHandler);

    if(CheckOnly() != 0)
        return -1;


    QApplication a(argc, argv);

    QDir::setCurrent(a.applicationDirPath());

    InitLog();
    LoadTheme(QString("deaufult"));

    //判断数据库是否存在，如果不存在，而且配置了打印机和小票机，将配置转成db
    QString printIni = QString(qApp->applicationDirPath() + "/" + DEFAULT_PRTDBNAME);
    QFile printIniFile;
    printIniFile.setFileName(printIni);
    if(!printIniFile.exists()) {
//        ConfigToDB();
    }

    QLOG_INFO() << "--------------------------------takeout start------------------------------------";
    //线程必须定义
    QThread thread;
    QThread threadt;
    QThread prtthreadt;
    QThread prtthreadpickup;
    QThread checkipthread;

    //获取档口线程
    QThread stallsThread;
    //获取打印模板线程
    QThread prtModelThread;
    //获取骑手信息线程
    QThread driverInfoThread;
    //获取骑手拒单信息线程
    QThread driverCancelThread;
    QLOG_INFO() << "Thread List :" << &thread << &threadt << QThread::currentThread();
    //初始化打印文件
    InitPtr();
    //初始化全局订单池主线程中工作
    PosOrderPool::InitOrderPool();
    PosPrtPool::InitPrtPool();
    PosStallsPool::InitPosStallsPool();
    //读取配置文件
    QString geturl;
    QString pushurl;
    QString autoconf;
    InitCfgInfo(geturl, pushurl, autoconf);
    //定义子工作流及工作流初始化
    //拉单
    OrderGetWork work;
    //打印
    orderprintwork printwork;
    //订单数据本地化
    OrderLocalizeWork loac;
    //订单入机
    OrderEntryWork entrywork;
    //心跳长良介
    OrderPushWork pwork;
    //预约单打印
    PickUpOrderWork pickuporderwork;
    //打印机数据本地化
    PrtLocalizeWork prtlocalizework;
    //档口获取
    StallsGetWork stallsgetwork;
    //获取打印模板
    prtModelGetWork  prtmodelgetwork;
    //拉取骑手信息
    DriverInfoGetWork driverinfogetwork;

    DriverCancelOrderGetWork drivercancelordergetwork;

    //网络超时工作
    NetworkCheckWork networkcheckwork;

    driverinfogetwork.setUrl(geturl);
    drivercancelordergetwork.setUrl(geturl);
    prtmodelgetwork.setUrl(geturl);
    stallsgetwork.setUrl(geturl);
    pickuporderwork.setUrl(geturl);
    work.setUrl(geturl);
    work.setAutoconfirm(autoconf);
    work.setTimeout(180000);
    pwork.setSerurl(pushurl);
    //移动子工作流到线程
    loac.moveToThread(&thread, false);
    entrywork.moveToThread(&thread, false);
    work.moveToThread(&thread, true);
    printwork.moveToThread(&prtthreadt, true);
    pwork.moveToThread(&threadt, true);
    pickuporderwork.moveToThread(&prtthreadpickup, true);
    prtlocalizework.moveToThread(&prtthreadpickup, false);

    networkcheckwork.moveToThread(&checkipthread, true);

    stallsgetwork.moveToThread(&stallsThread, true);
    prtmodelgetwork.moveToThread(&prtModelThread, true);
//    entrywork.moveToThread(&prtModelThread, false);
    driverinfogetwork.moveToThread(&driverInfoThread, true);
    drivercancelordergetwork.moveToThread(&driverCancelThread, true);
    //启动tcp长链接和拉单工作流
    thread.start();
    threadt.start();
    prtthreadt.start();
    prtthreadpickup.start();

    checkipthread.start();
    stallsThread.start();
    prtModelThread.start();
    driverInfoThread.start();
    driverCancelThread.start();
    //界面类定义及初始化
 #ifndef FM_NEW_UI
    MainForm mainform;
    LoginForm loginform;
    FloatForm floatform;
    //开始展示界面
    mainform.MyShow();
    loginform.showfull();
#else

    NewLoginForm loginform;
    NewMainForm mainform;
//    FloatForm floatform;
    NewFloatForm floatform;
    mainform.MyShow();
    loginform.showfull();
#endif
    //回归事件循环
    return a.exec();
}

void InitPtr()
{
    QFile tmpfile(qApp->applicationDirPath() + "/" + PREINTER_NEED);

    if(!tmpfile.exists())
    {
        if(tmpfile.open(QFile::ReadWrite))
            tmpfile.close();
    }
}

void InitCfgInfo(QString &geturl, QString &pushurl, QString &autoconf)
{
    QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    QString storefile = qApp->applicationDirPath() + "/" + STOREINFO_NAME;

    QLOG_DEBUG() << "config file name : " << configfile;
    QLOG_DEBUG() << "store file name : " << storefile;

    QString tmpstoreid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_STOREID).toString();
    QString tmppartnerid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_PARNETID).toString();
    QString tmpuserid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_USERID).toString();
    QString tmppwd = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_PWD).toString();
    QString tmpstationid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_STATIONIID).toString();


    QFile file(storefile);
    if(!file.exists())
    {
        QLOG_INFO() << "Not found " << storefile;
        file.open(QFile::ReadWrite);
        file.close();

        if(!tmpstoreid.isEmpty() && !tmppartnerid.isEmpty() && !tmpuserid.isEmpty() && !tmppwd.isEmpty() && !tmpstationid.isEmpty())
        {
            QSettings(storefile, QSettings::IniFormat).setValue(INI_BASE_PARNETID, tmppartnerid);
            QSettings(storefile, QSettings::IniFormat).setValue(INI_BASE_STOREID, tmpstoreid);
            QSettings(storefile, QSettings::IniFormat).setValue(INI_BASE_STATIONIID, tmpstationid);
            QSettings(storefile, QSettings::IniFormat).setValue(INI_BASE_USERID, tmpuserid);
            QSettings(storefile, QSettings::IniFormat).setValue(INI_BASE_PWD, tmppwd);
        }
    }

    QString storeid = QSettings(storefile, QSettings::IniFormat).value(INI_BASE_STOREID).toString();
    QString partnerid = QSettings(storefile, QSettings::IniFormat).value(INI_BASE_PARNETID).toString();
    QString userid = QSettings(storefile, QSettings::IniFormat).value(INI_BASE_USERID).toString();
    QString pwd = QSettings(storefile, QSettings::IniFormat).value(INI_BASE_PWD).toString();
    QString stationid = QSettings(storefile, QSettings::IniFormat).value(INI_BASE_STATIONIID).toString();

    autoconf = QSettings(configfile, QSettings::IniFormat).value(INI_AUTOCONFIRM).toString();
    pushurl = QSettings(configfile, QSettings::IniFormat).value(INI_PUSHSERVER).toString();
    geturl = QSettings(configfile, QSettings::IniFormat).value(INI_GETSERVER).toString();


    QLOG_DEBUG() << "storeid" << storeid << "partnerid" << partnerid << "userid" << userid;
    QLOG_DEBUG() << "pwd" << pwd << "stationid" << stationid << "autoconf" << autoconf;
    QLOG_DEBUG() << "pushurl" << pushurl << "geturl" << geturl;
}

void InitLog()
{
    QString logDir = QString("%1/log").arg(QCoreApplication::applicationDirPath());
    QDir().mkdir(logDir);

    QsLogging::Logger &logger = QsLogging::Logger::instance();
    logger.setLoggingLevel(QsLogging::DebugLevel);
    QString logPath = QString("%1/%2").arg(logDir, "takeout.log");
    QsLogging::DestinationPtr fileDst(QsLogging::DestinationFactory::MakeFileDestination(
    logPath, QsLogging::EnableLogRotation, QsLogging::MaxSizeBytes(10*1024*1024), QsLogging::MaxOldLogCount(10)));
    logger.addDestination(fileDst);
    QsLogging::DestinationPtr consleDest(QsLogging::DestinationFactory::MakeDebugOutputDestination());
    logger.addDestination(consleDest);
}

void LoadTheme(const QString& theme)
{
    QString rccPath = QString("%1/skin/%2.rcc").arg(qApp->applicationDirPath()).arg(theme);
    if(!QFile(rccPath).exists())
    {
        return;
    }
    QResource::registerResource(rccPath);

    QFile qssFile(QString(":/%1.qss").arg(theme));
    if(!qssFile.open(QFile::ReadOnly))
    {
        return;
    }
    qApp->setStyleSheet(qssFile.readAll());
    qssFile.close();
}

int CheckOnly()
{
    HANDLE m_hMutex  =  CreateMutex(NULL, FALSE,  L"Global\\fmtakeout");

    if(m_hMutex != NULL)
    {
        if  (GetLastError()  ==  ERROR_ALREADY_EXISTS||GetLastError()  ==  ERROR_ACCESS_DENIED)  {
            CloseHandle(m_hMutex);
            m_hMutex  =  NULL;
            return  -1;
        }
    }
    else{
        return -1;
    }

    return 0;
}

void ConfigToDB()
{
    FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_PRTDBNAME);

    db.creat(QString("create table prtlist (prt_id varchar(80) primary key,"
                     "prt_name text,prt_type int(1),prt_config text,prt_stalls text)"), DEFAULT_PRTFORM);

    QString filename = qApp->applicationDirPath() + "/" + PREINTER_CONSS;

    QString strtime = QDateTime::currentDateTime().toString("yyyyMMddhhmmss");
    QString prtId = QString::fromUtf8("\xE5\xB0\x8F\xE7\xA5\xA8") + strtime;
    QString prtName = QSettings(filename, QSettings::IniFormat).value(PRT_INI_NAME).toString();
    QString prtType = "0";                //小票打印机
    QJsonObject prtConfig;
    int type = QSettings(filename, QSettings::IniFormat).value(PRT_INI_TYPE).toInt();
    switch(type) {
    case 0:
        prtConfig.insert(PRT_CONF_COM, QSettings(filename, QSettings::IniFormat).value(PRT_INI_COMDEF_COM).toString());
        prtConfig.insert(PRT_CONF_BAUDRATE, QSettings(filename, QSettings::IniFormat).value(PRT_INI_COMDEF_BAUDRATE).toString());
        prtConfig.insert(PRT_CONF_DATABITS, QSettings(filename, QSettings::IniFormat).value(PRT_INI_COMDEF_DATABITS).toString());
        prtConfig.insert(PRT_CONF_STOPBITS, QSettings(filename, QSettings::IniFormat).value(PRT_INI_COMDEF_STOPBITS).toString());
        prtConfig.insert(PRT_CONF_PARITY, QSettings(filename, QSettings::IniFormat).value(PRT_INI_COMDEF_PARITY).toString());
        prtConfig.insert(PRT_CONF_FLOWCONTROL, QSettings(filename, QSettings::IniFormat).value(PRT_INI_COMDEF_FLOWCONTROL).toString());
        break;
    case 1:
        prtConfig.insert(PRT_CONF_LPTNAME, QSettings(filename, QSettings::IniFormat).value(PRT_INI_PARALLEL).toString());
        prtConfig.insert(PRT_CONF_PAPERWIDTH, QSettings(filename, QSettings::IniFormat).value(PRT_INI_PAPERWIDTH).toString());
        break;
    case 3:
        prtConfig.insert(PRT_CONF_IP, QSettings(filename, QSettings::IniFormat).value(PRT_INI_IP).toString());
        prtConfig.insert(PRT_CONF_PAPERWIDTH, QSettings(filename, QSettings::IniFormat).value(PRT_INI_PAPERWIDTH).toString());
        break;
    case 4:
        prtConfig.insert(PRT_CONF_NAME, QSettings(filename, QSettings::IniFormat).value(PRT_INI_NAME).toString());
        prtConfig.insert(PRT_CONF_PAPERWIDTH, QSettings(filename, QSettings::IniFormat).value(PRT_INI_PAPERWIDTH).toString());
        break;
    default:
        break;
    }

    QString prtStr = QString(QJsonDocument(prtConfig).toJson());
    QVariantMap map;
    map.insert(DB_KEY_PRTID, prtId);
    map.insert(DB_KEY_PRTNAME, prtName);
    map.insert(DB_KEY_PRTTYPE, prtType);
    map.insert(DB_KEY_PRTCONFIG, prtStr);

    QSqlQuery query;

    QStringList list;
    list.append(EVENT_KEY_PRTID);

    if(!db.find(DEFAULT_PRTFORM, query, list, QString(DB_KEY_PRTID).append("='%1'").arg(prtId)))
        return ;

    if(!query.next())
    {
        QLOG_DEBUG() << "insert new prt" << map;
        bool flag = db.insert(DEFAULT_PRTFORM, map);
        QLOG_DEBUG() << "insert new prt : " << prtId << "(" << flag << ")";
    }
    else
    {
        QLOG_DEBUG() << "update prt" << map;
        bool flag = db.update(DEFAULT_PRTFORM, map, QString(DB_KEY_PRTID).append("='%1'").arg(prtId));
        QLOG_DEBUG() << "update prt : " << prtId << "(" << flag << ")";
    }

    //判断配置文件中是否需要杯贴合后厨打印机字段，如果需要再将配置插入到数据库
    // INI_NEEDLABEL INI_NEEDPTR
    if(QSettings(filename, QSettings::IniFormat).value(INI_NEEDLABEL).toInt()) {
        //杯贴配置写db
        QString labelstrtime = QDateTime::currentDateTime().toString("yyyyMMddhhmmss");
        QString labelprtId = QString::fromUtf8("\xE6\x9D\xAF\xE8\xB4\xB4") + labelstrtime;
        QString labelprtName = QSettings(filename, QSettings::IniFormat).value(PRT_INI_PRINTLABEL).toString();
        QString labelprtType = "1";                //小票打印机
        QJsonObject labelprtConfig;
        int labeltype = QSettings(filename, QSettings::IniFormat).value(PRT_INI_LABELPRTTYPE).toInt();
        switch(labeltype) {
        case 0:
            break;
        case 1:
            break;
        case 3:
            break;
        case 4:
            labelprtConfig.insert(PRT_CONF_NAME, QSettings(filename, QSettings::IniFormat).value(PRT_INI_PRINTLABEL).toString());
            labelprtConfig.insert(PRT_CONF_PAPERWIDTH, QSettings(filename, QSettings::IniFormat).value(PRT_INI_WIGTH).toString());
            break;
        default:
            break;
        }

        QString labelprtStr = QString(QJsonDocument(labelprtConfig).toJson());
        QVariantMap labelmap;
        labelmap.insert(DB_KEY_PRTID, labelprtId);
        labelmap.insert(DB_KEY_PRTNAME, labelprtName);
        labelmap.insert(DB_KEY_PRTTYPE, labelprtType);
        labelmap.insert(DB_KEY_PRTCONFIG, labelprtStr);

        QSqlQuery labelquery;

        QStringList labellist;
        labellist.append(EVENT_KEY_PRTID);

        if(!db.find(DEFAULT_PRTFORM, labelquery, labellist, QString(DB_KEY_PRTID).append("='%1'").arg(labelprtId)))
            return ;

        if(!labelquery.next())
        {
            QLOG_DEBUG() << "insert new prt" << labelmap;
            bool flag = db.insert(DEFAULT_PRTFORM, labelmap);
            QLOG_DEBUG() << "insert new prt : " << labelprtId << "(" << flag << ")";
        }
        else
        {
            QLOG_DEBUG() << "update prt" << labelmap;
            bool flag = db.update(DEFAULT_PRTFORM, labelmap, QString(DB_KEY_PRTID).append("='%1'").arg(labelprtId));
            QLOG_DEBUG() << "update prt : " << labelprtId << "(" << flag << ")";
        }
    }

    if(QSettings(filename, QSettings::IniFormat).value(INI_NEEDPTR).toInt()) {
        //杯贴配置写db
        QString otherstrtime = QDateTime::currentDateTime().toString("yyyyMMddhhmmss");
        QString otherprtId = QString::fromUtf8("\xE5\x90\x8E\xE5\x8E\xA8") + otherstrtime;
        QString otherprtName = QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_NAME).toString();
        QString otherprtType = "2";                //小票打印机
        QJsonObject otherprtConfig;
        int othertype = QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_TYPE).toInt();
        switch(othertype) {
        case 0:
            otherprtConfig.insert(PRT_CONF_COM, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERCOMDEF_COM).toString());
            otherprtConfig.insert(PRT_CONF_BAUDRATE, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERCOMDEF_BAUDRATE).toString());
            otherprtConfig.insert(PRT_CONF_DATABITS, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERCOMDEF_DATABITS).toString());
            otherprtConfig.insert(PRT_CONF_STOPBITS, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERCOMDEF_STOPBITS).toString());
            otherprtConfig.insert(PRT_CONF_PARITY, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERCOMDEF_PARITY).toString());
            otherprtConfig.insert(PRT_CONF_FLOWCONTROL, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERCOMDEF_FLOWCONTROL).toString());
            break;
        case 1:
            otherprtConfig.insert(PRT_CONF_LPTNAME, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_PARALLEL).toString());
            otherprtConfig.insert(PRT_CONF_PAPERWIDTH, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_PAPERWIDTH).toString());
            break;
        case 3:
            otherprtConfig.insert(PRT_CONF_IP, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_IP).toString());
            otherprtConfig.insert(PRT_CONF_PAPERWIDTH, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_PAPERWIDTH).toString());
            break;
        case 4:
            otherprtConfig.insert(PRT_CONF_NAME, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_NAME).toString());
            otherprtConfig.insert(PRT_CONF_PAPERWIDTH, QSettings(filename, QSettings::IniFormat).value(PRT_INI_OTHERPRT_PAPERWIDTH).toString());
            break;
        default:
            break;
        }

        QString otherprtStr = QString(QJsonDocument(otherprtConfig).toJson());
        QVariantMap othermap;
        othermap.insert(DB_KEY_PRTID, otherprtId);
        othermap.insert(DB_KEY_PRTNAME, otherprtName);
        othermap.insert(DB_KEY_PRTTYPE, otherprtType);
        othermap.insert(DB_KEY_PRTCONFIG, otherprtStr);

        QSqlQuery otherquery;

        QStringList otherlist;
        otherlist.append(EVENT_KEY_PRTID);

        if(!db.find(DEFAULT_PRTFORM, otherquery, otherlist, QString(DB_KEY_PRTID).append("='%1'").arg(otherprtId)))
            return ;

        if(!otherquery.next())
        {
            QLOG_DEBUG() << "insert new prt" << othermap;
            bool flag = db.insert(DEFAULT_PRTFORM, othermap);
            QLOG_DEBUG() << "insert new prt : " << otherprtId << "(" << flag << ")";
        }
        else
        {
            QLOG_DEBUG() << "update prt" << othermap;
            bool flag = db.update(DEFAULT_PRTFORM, othermap, QString(DB_KEY_PRTID).append("='%1'").arg(otherprtId));
            QLOG_DEBUG() << "update prt : " << otherprtId << "(" << flag << ")";
        }
    }


}

#endif
