﻿#include "posevent.h"
#include <QDebug>
#include <QMutexLocker>

QEvent::Type PosEvent::s_change_order = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_delete_order = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_opt_change_order = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_need_get_order = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_login_status = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_opt_status = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_get_order_status = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_opt_order = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_order_location = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_token_change = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_inset_orderpool = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_change_orderpool = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_location_orderpool = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_login_storeinfo = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_show_float = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_hide_float = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_show_mainform = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_hide_mainform = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_show_prtform = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_show_login = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_network_outtime = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_pickuporder_opt = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_pickuporder_remind = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_change_prt = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_delete_prt = static_cast<QEvent::Type>(QEvent::registerEventType());

QEvent::Type PosEvent::s_change_stalls = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_show_stalls = static_cast<QEvent::Type>(QEvent::registerEventType());

QEvent::Type PosEvent::s_get_prtmodel = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_driver_order_status = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_get_driver_info = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_need_get_driver_info = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_driver_cancel_order = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_driver_cancel_reason = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_show_driver_cancel = static_cast<QEvent::Type>(QEvent::registerEventType());

QEvent::Type PosEvent::s_show_pickup = static_cast<QEvent::Type>(QEvent::registerEventType());
QEvent::Type PosEvent::s_hide_loading = static_cast<QEvent::Type>(QEvent::registerEventType());

PosEvent::PosEvent(Type e):QEvent(e)
{
    //qDebug() << "------event : " << this;

    _info = NULL;
    _info_call_bk = NULL;
    _copy_info_call_bk = NULL;
}

PosEvent::~PosEvent()
{
    if(_info != NULL && _info_call_bk != NULL)
        _info_call_bk(_info);

    _info = NULL;
    _info_call_bk = NULL;

    //qDebug() << "PosEvent Over" << this;
}

void *PosEvent::info() const
{
    return _info;
}

void PosEvent::setInfo(void *info)
{
    _info = info;
}

void PosEvent::setInfo_call_bk(const std::function<void (void *)> &info_call_bk)
{
    _info_call_bk = info_call_bk;
}

void PosEvent::setCopy_info_call_bk(const std::function<void (void *&, void *)> &copy_info_call_bk)
{
    _copy_info_call_bk = copy_info_call_bk;
}

PosEvent &PosEvent::operator =(PosEvent const& e)
{
    this->_info_call_bk = e._info_call_bk;
    this->_copy_info_call_bk = e._copy_info_call_bk;

    if(_copy_info_call_bk != NULL)
        this->_copy_info_call_bk(this->_info, e._info);

    //qDebug() << "operator =" << this << _info;

    return *this;
}



