﻿#ifndef FMAPPLICATION_H
#define FMAPPLICATION_H

#include <QApplication>
#include <QObject>
#include <QEvent>
#include <QMap>
#include <QSet>
#include <QMutex>

class FMApplication : public QApplication
{
public:
    FMApplication(int &argc, char **argv);

    //重写postEvent方法event必须在堆中分配,不同与QApplication::postEvent的是receiver可以为NULL
    static void postEvent(QObject *receiver, QEvent *event, int priority = Qt::NormalEventPriority);

    //订阅事件
    static bool subscibeEvent(QObject *listener, QEvent::Type type);

    //取消订阅事件
    static void logoutEvent(QObject *listener, QEvent::Type type);

    //程序退出
    static void exit(int rlt = 0);

private:
    //自定义事件池,key事件类型;value订阅该类型事件指针的集合
    static QMap< int, QSet<QObject *> > s_user_event_pool;
    //自定义事件池操作事件锁
    static QMutex s_mutex;
    //停止事件推送
    static bool s_stop_flag;
};

#endif // FMCOREAPPLICATION_H
