﻿#ifndef WORKOBJECT_H
#define WORKOBJECT_H

#include <QObject>
#include <QEventLoop>
#include <QJsonObject>
#include <QTimer>

#define EVENTWAIT(timer) do{                                \
        QEventLoop loop;                                    \
        QTimer::singleShot(timer, &loop, SLOT(quit()));     \
        loop.exec();                                        \
    } while(0)

class WorkObject : public QObject
{
    Q_OBJECT
public:
    explicit WorkObject(QObject *parent = 0);

    ~WorkObject();
    /* 功能:重载移动到线程的方法
     * 参数:[1]线程编号[2]是否在退出时触发线程退出
     * 返回:void
     * */
    void moveToThread(QThread *thread, bool with_thread_start);

    bool S_Request(const QJsonObject &requestJson, QJsonObject &recvJson, QString url, QString &error, QByteArray contentype = QByteArray("text/json"));
signals:
    /* 功能:触发QThread退出的信号
     * 参数:NULL
     * 返回:void
     * */
    void workclose();

    void quit();

public slots:
    virtual void workstart();

protected:
    bool _stopflag;

    bool _stoped;

};

#endif // WORKOBJECT_H
