#ifndef STALLSGETWORK_H
#define STALLSGETWORK_H

#include <QEvent>
#include <QString>
#include <QJsonObject>
#include <QTimer>
#include <QEventLoop>
#include "workobject.h"
#include "preDefine.h"
#include "base/Arithmetic/cretopt.h"

#define ADVANCEORDER 0

class  StallsGetWork : public WorkObject
{
    Q_OBJECT
public:
    explicit StallsGetWork(WorkObject *parent = 0);

    ~StallsGetWork();

    bool event(QEvent *e);

    void setUrl(const QString &url);

signals:

public slots:
    void workstart();

private:
    bool GetStalls();

    bool CheckStallsInfo(QJsonObject &json);

private:
    QJsonObject getStallsInfo();

    QVariantMap _storeinfo;

    QString _token;

    QString _url;
};

class GetStallsDataProcess
{
public:
    friend class StallsGetWork;
private:
    static bool getAction(int REQ, QString &action)
    {
#ifndef USE_QAACTION
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("saas.printFile.query");
                return true;
            default:
                return false;
        }
#else
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("qasaas.printFile.query");
                return true;
            default:
                return false;
        }
#endif
    }

    static bool getAccess_Token(QString &access_toekn)
    {
        access_toekn = DEFAULT_ACCESS_TOKEN;
        return true;
    }

    static bool getVer(QString &ver)
    {
        ver = "1";
        return true;
    }

    static bool getRealUrl(int reqtype, const QJsonObject &json, const QString &url, QString &realurl)
    {

        QString action, access_token, ver, sign;

        if(!GetStallsDataProcess::requestGetRSASign(reqtype, json, sign, action, access_token, ver))
            return false;

        QString tmpurl = url;

        realurl = tmpurl.arg(action, access_token, ver, sign);

        return true;
    }

    static bool requestGetRSASign(int reqtype, const QJsonObject &json, QString &sign, QString &action, QString &access_token, QString &ver)
    {
        QJsonObject tmpjson;

        if(!GetStallsDataProcess::getAction(reqtype, action) ||
            !GetStallsDataProcess::getAccess_Token(access_token) ||
                !GetStallsDataProcess::getVer(ver))
            return false;

        GetStallsDataProcess::getComplateJson(action, access_token, ver, json, tmpjson);
        return CretOperate::GetSign(tmpjson, sign);
    }

    static void getComplateJson(QString action, QString access_token, QString ver, const QJsonObject &json, QJsonObject &complatejson)
    {
        complatejson = json;

        complatejson.insert(JSON_KEY_ACTION, action);
        complatejson.insert(JSON_KEY_ACCESS_TOKEN, access_token);
        complatejson.insert(JSON_KEY_VER, ver);
    }

    static bool getStallsOptRequest(QJsonObject &data, QString partnerid)
    {
        data.insert(JSON_KEY_PARTNERID, partnerid);
        return true;
    }

};

#endif // STALLSGETWORK_H
