#include "stallsgetwork.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "QsLog.h"
#include <QJsonArray>

StallsGetWork::StallsGetWork(WorkObject *parent) : WorkObject(parent)
{
    FMApplication::subscibeEvent(this, PosEvent::s_token_change);
    FMApplication::subscibeEvent(this, PosEvent::s_login_storeinfo);
}

StallsGetWork::~StallsGetWork()
{
    qDebug() << "";
    while(!_stoped)
    {
        _stopflag = true;
        emit quit();
        EVENTWAIT(10);
    }
}

bool StallsGetWork::event(QEvent *e)
{
    if(e->type() == PosEvent::s_token_change)
    {
        QString token;

        GETEVENTINFO(token, e, QString);

        QLOG_DEBUG() << "StallsGetWork::event::PosEvent::s_token_chang:" << token;

        _token = token;

        emit quit();

        return true;
    }

    if(e->type() == PosEvent::s_login_storeinfo)
    {
        QVariantMap storeinfo;

        GETEVENTINFO(storeinfo,e,QVariantMap);

        QLOG_DEBUG() << "StallsGetWork::event::PosEvent::s_login_storeinfo:" << storeinfo;

        _storeinfo = storeinfo;

        return true;
    }

    return WorkObject::event(e);
}

void StallsGetWork::setUrl(const QString &url)
{
    _url = url;
}

void StallsGetWork::workstart()
{
    if(_token.isEmpty())
    {
        QEventLoop loop;
        connect(this, &StallsGetWork::quit, &loop, &QEventLoop::quit);
        loop.exec();
    }

    QLOG_DEBUG() << "StallsGetWork::workstart loop start";

    while(!_stopflag)
    {

        if(!GetStalls())
        {
            QLOG_WARN() << "StallsGetWork::GetStalls failed wait " << DEFAULT_STALLS_TIMEOUT;
            QTimer timer;
            QEventLoop loop;
            connect(this, &StallsGetWork::quit, &loop, &QEventLoop::quit);
            connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
            timer.start(DEFAULT_STALLS_TIMEOUT);
            loop.exec();
            continue;
        }

        //获取档口信息完成后检擦是否退出表示
        if(_stopflag)
            break;

        QEventLoop loop;
        connect(this, &StallsGetWork::quit, &loop, &QEventLoop::quit);
        loop.exec();
    }
    _stoped = true;
}

bool StallsGetWork::GetStalls()
{
    //获取档口信息
    QJsonObject json, recvjson;
    QString realurl;
    QString error;

    if(!GetStallsDataProcess::getStallsOptRequest(json, _storeinfo[JSON_KEY_PARTNERID].toString()))
    {
        QLOG_ERROR() << "getStallsOptRequest failed";
        return false;
    }

    QLOG_INFO() << "getStallsOptRequest request json : " << json;

    if(!GetStallsDataProcess::getRealUrl(ADVANCEORDER, json, _url, realurl))
    {
        QLOG_ERROR() << "getStallsOptRequest getRealUrl failed";
        return false;
    }

    QLOG_INFO() << "getStallsOptRequest request url :" << realurl;

    if(!this->S_Request(json, recvjson, realurl, error))
    {
        QLOG_ERROR() << "getStallsOptRequest failed : " << error;
        return false;
    }

    QLOG_INFO() << "getStallsOptRequest return json : " << recvjson;

    return CheckStallsInfo(recvjson);

}

bool StallsGetWork::CheckStallsInfo(QJsonObject &json)
{
    if(!json.contains(JSON_KEY_CODE) || QString("ok").compare(json[JSON_KEY_CODE].toString(), Qt::CaseInsensitive) != 0)
    {
        QLOG_ERROR() << "StallsGetWork::CheckStallsInfo failed";
        return false;
    }

    if(json.contains(STALLS_KEY_RESULT) && json[STALLS_KEY_RESULT].isObject() &&
            json[STALLS_KEY_RESULT].toObject().contains(STALLS_KEY_FILEPRODUCTLIST) &&
            json[STALLS_KEY_RESULT].toObject()[STALLS_KEY_FILEPRODUCTLIST].isArray())
    {
        QLOG_DEBUG() << "StallsGetWork::CheckStallsInfo file_list";

        QJsonArray array = json[STALLS_KEY_RESULT].toObject()[STALLS_KEY_FILEPRODUCTLIST].toArray();

        if(array.size() > 0)
            POSTEVENTTYPE(PosEvent::s_change_stalls, array, QJsonArray);
        else
            QLOG_WARN() << "file_list is empty";
    }

    return true;
}

