﻿#include "rpainterface.h"
#include "QsLog.h"
#include <QJsonObject>
#include <QJsonDocument>
#include <QJsonParseError>
#include "event/posevent.h"
#include "event/fmapplication.h"

#define BUFFER_SIZE             1024     //缓冲区大小
#define SEND_PORT               30001    //socket发送端口
#define SERVER_PORT             30002    //socket接收端口
RpaInterface::RpaInterface()
    :    QTcpServer(),
         socket(nullptr)
{
    FMApplication::subscibeEvent(this, PosEvent::s_show_float);
    FMApplication::subscibeEvent(this, PosEvent::s_hide_mainform);
    FMApplication::subscibeEvent(this, PosEvent::s_hide_float);

    QLOG_INFO()<<"listen port:"<<SERVER_PORT;
    if(!this->listen(QHostAddress::Any, SERVER_PORT)) {
        QLOG_INFO() << "Listen error: " << this->errorString();
    }
    connect(this, &QTcpServer::newConnection, this, &RpaInterface::onNewConnection);
}

RpaInterface &RpaInterface::Instance()
{
    static RpaInterface rpa;
    return rpa;
}

void RpaInterface::onNewConnection()
{
    socket = nextPendingConnection();

    connect(socket, &QTcpSocket::disconnected, this, &RpaInterface::onDisconnected);
    connect(socket, &QTcpSocket::readyRead, this, &RpaInterface::onReadyRead);
}

void RpaInterface::onDisconnected()
{
    QLOG_INFO() << "Socket disconnected.";
    socket->close();
}

void RpaInterface::onReadyRead()
{
    QLOG_INFO() << "onReadyRead.";
    char* recvBuf=new char[BUFFER_SIZE*10];
    if(socket->isOpen()){
        int length = socketRecvData(recvBuf, BUFFER_SIZE*10, socket);
        if(length>0){
            QLOG_INFO() << "onReadyRead data:"<<recvBuf;
            QJsonObject recvObj = QJsonDocument::fromJson(recvBuf).object();
            if(recvObj.contains("show_window")){
                bool show=recvObj["show_window"].toBool();
                if(show){
                    QLOG_INFO() << "s_show_float show";
                    DEFAULTPOSTEVENT(PosEvent::s_show_float, "");
                }else{
                    QLOG_INFO() << "s_show_float hide";
                    DEFAULTPOSTEVENT(PosEvent::s_hide_mainform, "");
                    DEFAULTPOSTEVENT(PosEvent::s_hide_float, "");
                }
            }
        }
    }

    socket->waitForDisconnected();
}

//socket 数据接收
//返回值   成功：接收长度
//         失败：  -1
int RpaInterface::socketRecvData(char * recvBuf, int bufSize, QTcpSocket *sockClient)
{
    int rcvedLength = 0;
    int rcvFlag = 0; //firstly, to rcv header
    int needLength = sizeof(FMSOCKEHEADER);
    int rlt = 0;
    QLOG_INFO() << "start recv data";

    FMSOCKEHEADER headx;
    char * pcRcvBufer = (char *)(&headx);

    while(0 < needLength)
    {
        //接收并打印客户端数据
        int length = sockClient->read(pcRcvBufer + rcvedLength,needLength);
        if (0 < length)
        {
            needLength -= length;
            rcvedLength += length;

            if (0 == needLength)
            {
                if (0 == rcvFlag)
                {//header rcved complete
                    rcvFlag = 1;//to rcv payload

                    int flag = headx.flag;
                    int len  = headx.len;
                    int ver  = headx.ver;

                    if(len > bufSize)
                    {
                        rlt = -1;
                        QLOG_INFO() << "socket recv 接收数据长度大于接收缓冲区："<< len;
                        break;
                    }
                    needLength = len;
                    pcRcvBufer = recvBuf;
                    rcvedLength = 0;
                    continue;
                }
                else
                {
                    rlt = rcvedLength;
                    break;
                }
            }
        }
        else if(length == 0)
        {//socket error
            rlt = -1;
            QLOG_INFO() << "socket recv:" << length;
            break;
        }
    }
    recvBuf[rcvedLength]='\0';
    return rlt;
}

bool RpaInterface::sendToRPA(const QByteArray &orderData,QString& error)
{
    bool result=true;
    QTcpSocket client;

    qDebug() << "SendToMonitor to pos: " << orderData;
    int jsonLength=orderData.length();
    char* m_pFmPackage = new char[jsonLength + sizeof(FMSOCKEHEADER)];
    FMSOCKEHEADER header = { 0, 0, 0 };
    header.flag = 0x4d46;
    header.len = jsonLength;
    header.ver = 0x1;

    memcpy(m_pFmPackage, &header, sizeof(FMSOCKEHEADER));
    memcpy(m_pFmPackage+sizeof(FMSOCKEHEADER), orderData, jsonLength);


    int toSendLength = jsonLength + sizeof(FMSOCKEHEADER);
    int curSendLength = 0;

    client.connectToHost("127.0.0.1", SEND_PORT);
    if (client.waitForConnected()){
        while(curSendLength < toSendLength)
        {
            int rlt= client.write(m_pFmPackage+curSendLength,toSendLength - curSendLength);
            client.waitForBytesWritten();
            if(rlt==-1){
                error="socket send error";
                result=false;
                break;
            }
            curSendLength += rlt;
        }
    }
    else{
        error="socket connect failed";
        result=false;
    }
    client.close();
    delete[] m_pFmPackage;
    return result;
}
