#ifndef PRTMODELGETWORK_H
#define PRTMODELGETWORK_H

#include <QEvent>
#include <QString>
#include <QJsonObject>
#include <QTimer>
#include <QEventLoop>
#include <QFile>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QObject>
#include <QUrl>
#include "workobject.h"
#include "preDefine.h"
#include "base/Arithmetic/cretopt.h"

#define ADVANCEORDER 0

class prtModelGetWork : public WorkObject
{
    Q_OBJECT
public:
    explicit prtModelGetWork(WorkObject *parent = 0);

    ~prtModelGetWork();

    bool event(QEvent *e);

    void setUrl(const QString &url);

public slots:
    void workstart();

private:
    bool GetPrtModel();

    bool CheckPrtModelInfo(QJsonObject &json);

    bool prtModelLocalize();

    bool logoImageLocalize();

    bool qrCodeImageLocalize();

    bool tableHeadLocalize();

    bool downloadImage(QString url, QString fileName);

    bool mapIntoFile(QString key, QString value);

    bool praseXmlPrtModel(QString str);

    void img_rgb2gray();

private:

    QVariantMap _storeinfo;

    QString _token;

    QString _url;

    QStringList _templateList;

    QMap<int, QString> _templateMap;
    QMap<int, QString> _qrCodeMap;
    QMap<int, QString> _logoMap;
    QMap<int, QString> _tableHeadMap;
};

class GetPrtModelDataProcess
{
public:
    friend class prtModelGetWork;
private:
    static bool getAction(int REQ, QString &action)
    {
#ifndef USE_QAACTION
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("saas.ticketSet.query");
                return true;
            default:
                return false;
        }
#else
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("qasaas.ticketSet.query");
                return true;
            default:
                return false;
        }
#endif
    }

    static bool getAccess_Token(QString &access_toekn)
    {
        access_toekn = DEFAULT_ACCESS_TOKEN;
        return true;
    }

    static bool getVer(QString &ver)
    {
        ver = "1";
        return true;
    }

    static bool getRealUrl(int reqtype, const QJsonObject &json, const QString &url, QString &realurl)
    {

        QString action, access_token, ver, sign;

        if(!GetPrtModelDataProcess::requestGetRSASign(reqtype, json, sign, action, access_token, ver))
            return false;

        QString tmpurl = url;

        realurl = tmpurl.arg(action, access_token, ver, sign);

        return true;
    }

    static bool requestGetRSASign(int reqtype, const QJsonObject &json, QString &sign, QString &action, QString &access_token, QString &ver)
    {
        QJsonObject tmpjson;

        if(!GetPrtModelDataProcess::getAction(reqtype, action) ||
            !GetPrtModelDataProcess::getAccess_Token(access_token) ||
                !GetPrtModelDataProcess::getVer(ver))
            return false;

        GetPrtModelDataProcess::getComplateJson(action, access_token, ver, json, tmpjson);
        return CretOperate::GetSign(tmpjson, sign);
    }

    static void getComplateJson(QString action, QString access_token, QString ver, const QJsonObject &json, QJsonObject &complatejson)
    {
        complatejson = json;

        complatejson.insert(JSON_KEY_ACTION, action);
        complatejson.insert(JSON_KEY_ACCESS_TOKEN, access_token);
        complatejson.insert(JSON_KEY_VER, ver);
    }

    static bool getPrtModelOptRequest(QJsonObject &data, QString partnerid)
    {
        data.insert(JSON_KEY_PARTNERID, partnerid);
        data.insert(JSON_KEY_REQUESTRESOURCE, 1);
        return true;
    }

};


#endif // PRTMODELGETWORK_H
