#include "prtmodelgetwork.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "base/System/downloader.h"
#include "base/DB/fm_database.h"
#include "QsLog.h"
#include <QJsonArray>
#include <QDomDocument>
#include <QApplication>
#include <QDir>
#include <Windows.h>
#include <QSettings>

prtModelGetWork::prtModelGetWork(WorkObject *parent) : WorkObject(parent)
{
//    FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_PRTMODEL);

//    db.creat(QString("create table prtmodellist (prt_type int(1) primary key,"
//                     "prt_logo text,prt_qrcode text,prt_model text)"), DEFAULT_PRTMODELFORM);

    FMApplication::subscibeEvent(this, PosEvent::s_token_change);
    FMApplication::subscibeEvent(this, PosEvent::s_login_storeinfo);
}

prtModelGetWork::~prtModelGetWork()
{
    qDebug() << "";
    while(!_stoped)
    {
        _stopflag = true;
        emit quit();
        EVENTWAIT(10);
    }
}

bool prtModelGetWork::event(QEvent *e)
{
    if(e->type() == PosEvent::s_token_change)
    {
        QString token;

        GETEVENTINFO(token, e, QString);

        QLOG_DEBUG() << "prtModelGetWork::event::PosEvent::s_token_chang:" << token;

        _token = token;

        emit quit();

        return true;
    }

    if(e->type() == PosEvent::s_login_storeinfo)
    {
        QVariantMap storeinfo;

        GETEVENTINFO(storeinfo,e,QVariantMap);

        QLOG_DEBUG() << "prtModelGetWork::event::PosEvent::s_login_storeinfo:" << storeinfo;

        _storeinfo = storeinfo;

        return true;
    }

    return WorkObject::event(e);
}

void prtModelGetWork::setUrl(const QString &url)
{
    _url = url;
}

void prtModelGetWork::workstart()
{
    if(_token.isEmpty())
    {
        QEventLoop loop;
        connect(this, &prtModelGetWork::quit, &loop, &QEventLoop::quit);
        loop.exec();
    }

    QLOG_DEBUG() << "prtModelGetWork::workstart loop quit";

    while(!_stopflag)
    {

        if(!GetPrtModel())
        {
            QLOG_WARN() << "prtModelGetWork::GetPrtModel failed wait " << DEFAULT_STALLS_TIMEOUT;
            QTimer timer;
            QEventLoop loop;
            connect(this, &prtModelGetWork::quit, &loop, &QEventLoop::quit);
            connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
            timer.start(DEFAULT_STALLS_TIMEOUT);
            loop.exec();
            continue;
        }

        //获取档口信息完成后检擦是否退出表示
        if(_stopflag)
            break;

        QEventLoop loop;
        connect(this, &prtModelGetWork::quit, &loop, &QEventLoop::quit);
        loop.exec();
    }
    _stoped = true;
}


bool prtModelGetWork::GetPrtModel()
{
    //获取档口信息
    QJsonObject json, recvjson;
    QString realurl;
    QString error;

    if(!GetPrtModelDataProcess::getPrtModelOptRequest(json, _storeinfo[JSON_KEY_PARTNERID].toString()))
    {
        QLOG_ERROR() << "getPrtModelOptRequest failed";
        return false;
    }

    QLOG_INFO() << "getPrtModelOptRequest request json : " << json;

    if(!GetPrtModelDataProcess::getRealUrl(ADVANCEORDER, json, _url, realurl))
    {
        QLOG_ERROR() << "getPrtModelOptRequest getRealUrl failed";
        return false;
    }

    QLOG_INFO() << "getPrtModelOptRequest request url :" << realurl;

    if(!this->S_Request(json, recvjson, realurl, error))
    {
        QLOG_ERROR() << "getPrtModelOptRequest failed : " << error;
        return false;
    }

    QLOG_INFO() << "getPrtModelOptRequest return json : " << recvjson;

    return CheckPrtModelInfo(recvjson);

}

bool prtModelGetWork::CheckPrtModelInfo(QJsonObject &json)
{
    _templateMap.clear();
    _qrCodeMap.clear();
    _logoMap.clear();

    if(!json.contains(JSON_KEY_CODE) || QString("ok").compare(json[JSON_KEY_CODE].toString(), Qt::CaseInsensitive) != 0)
    {
        QLOG_ERROR() << "prtModelGetWork::CheckPrtModelInfo failed";
        return false;
    }

//    QVariantMap map;
//    map.insert(EVENT_KEY_PRTMODEL, json);
//    POSTEVENTTYPE(PosEvent::s_get_prtmodel,map,QVariantMap);

    QJsonArray array;
    if(json.contains("result")) {
        QJsonObject result = json["result"].toObject();
        if(result.contains("printTicketList")) {
            array = result["printTicketList"].toArray();
        }
    }

    for(int i = 0;i != array.size(); ++i) {
        if(array.at(i).toObject().contains("template") && array.at(i).toObject().contains("print_type")) {
            if(array.at(i).toObject()["template"].toString() != 0) {
                QString str = array.at(i).toObject()["template"].toString();
                QLOG_DEBUG() << array.at(i).toObject()["print_type"].toInt();
                if(praseXmlPrtModel(str)) {
                    _templateMap.insert(array.at(i).toObject()["print_type"].toInt(), array.at(i).toObject()["template"].toString());
                }
            }
        } else {
            return false;
        }

        if(array.at(i).toObject().contains("qr_Code") && array.at(i).toObject().contains("print_type")) {
            if(array.at(i).toObject()["qr_Code"].toString() != 0) {
                _qrCodeMap.insert(array.at(i).toObject()["print_type"].toInt(), array.at(i).toObject()["qr_Code"].toString());
            }
        } else {
            return false;
        }

        if(array.at(i).toObject().contains("logo") && array.at(i).toObject().contains("print_type")) {
            if(array.at(i).toObject()["logo"].toString() != 0) {
                _logoMap.insert(array.at(i).toObject()["print_type"].toInt(), array.at(i).toObject()["logo"].toString());
            }
        } else {
            return false;
        }

        if(array.at(i).toObject().contains("table_head") && array.at(i).toObject().contains("print_type")) {
//            if(array.at(i).toObject()["table_head"].toString() != 0) {
                _tableHeadMap.insert(array.at(i).toObject()["print_type"].toInt(), array.at(i).toObject()["table_head"].toString());
//            }
        }
    }
    QLOG_DEBUG() << "_tableHeadMap:" << _tableHeadMap;


    prtModelLocalize();
    logoImageLocalize();
    qrCodeImageLocalize();
    tableHeadLocalize();

    return true;
}

bool prtModelGetWork::prtModelLocalize()
{
    qDebug() << "-------------------------------4040---------------------" << _templateMap;
    // 检查目录是否存在，若不存在则新建
    QString dir_str = QApplication::applicationDirPath() + QString("/prtinfo");
    QDir dir;
    if (!dir.exists(dir_str))
    {
        bool res = dir.mkpath(dir_str);
        qDebug() << "新建目录是否成功" << res;
    }

    QMap<int, QString>::iterator it;
    for(it = _templateMap.begin(); it != _templateMap.end(); ++it) {
        QFile file(QApplication::applicationDirPath() + QString("/prtinfo/%1.xml").arg(it.key()));
        if(file.open(QFile::WriteOnly|QFile::Truncate)) {
            file.write(QString(it.value()).toUtf8());
            file.close();
        } else {
            return false;
        }

    }
    return true;
}

bool prtModelGetWork::logoImageLocalize()
{
    if(_logoMap.size() == 0)
    {
        return false;
    }
    QMap<int, QString>::iterator it;
    for(it = _logoMap.begin(); it != _logoMap.end(); ++it) {
        downloadImage(it.value(), QApplication::applicationDirPath() + QString("/prtinfo/%1.bmp").arg(it.key()));
    }

    //将图片二值化
//    img_rgb2gray();
    return true;
}

bool prtModelGetWork::qrCodeImageLocalize()
{
    if(_qrCodeMap.size() == 0)
    {
        return false;
    }
    QMap<int, QString>::iterator it;
    for(it = _qrCodeMap.begin(); it != _qrCodeMap.end(); ++it) {
        downloadImage(it.value(), QApplication::applicationDirPath() + QString("/prtinfo/%1p.bmp").arg(it.key()));
    }
    return true;
}

bool prtModelGetWork::tableHeadLocalize()
{
    QMap<int, QString>::iterator it;
    for(it = _tableHeadMap.begin(); it != _tableHeadMap.end(); ++it) {
        bool res = mapIntoFile(QString::number(it.key()), it.value());
    }
    return true;
}

bool prtModelGetWork::downloadImage(QString url, QString fileName)
{
    QNetworkAccessManager m_networkManger;

    if(QNetworkAccessManager::Accessible != m_networkManger.networkAccessible())
    {
        m_networkManger.setNetworkAccessible(QNetworkAccessManager::Accessible);
    }

    QNetworkRequest networkRequest;
    networkRequest.setUrl(url);

    QEventLoop eventLoop;
    QNetworkReply *reply = m_networkManger.get(networkRequest);
    connect(&m_networkManger, SIGNAL(networkAccessibleChanged(QNetworkAccessManager::NetworkAccessibility)), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(finished()), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)), &eventLoop, SLOT(quit()));
    // 加用定时器防止网络出现异常长时间不返回导致的阻塞
    QTimer::singleShot(JSON_LOGIN_TIMEOUT, &eventLoop, &QEventLoop::quit);
    eventLoop.exec();

   if(reply->error() != QNetworkReply::NoError)
   {
       QLOG_ERROR() << "reply->errorString:" << reply->errorString();
       return false;
   }

   reply->deleteLater();
   QFile file(fileName);
   if(!file.open(QFile::WriteOnly|QFile::Truncate))
       return false;
   file.write(reply->readAll());
   file.close();

   return true;
}

bool prtModelGetWork::mapIntoFile(QString key, QString value)
{
    QString tableheadname = QApplication::applicationDirPath() + QString("/prtinfo/tablehead.ini");
    QSettings m_setting(tableheadname,QSettings::IniFormat);
    m_setting.setIniCodec("UTF-8");

    m_setting.setValue(key,value);

    return true;
}

bool prtModelGetWork::praseXmlPrtModel(QString str)
{
    QDomDocument doc;
    QString errorMsg;
    int errorLine;
    int errorColumn;
    if(!doc.setContent(str, &errorMsg, &errorLine, &errorColumn)) {
        QLOG_ERROR() << "xml prtmodel prase failed!" << errorMsg;
        return false;
    }
    return true;
}

void prtModelGetWork::img_rgb2gray()
{
    int threshold=200;
    FILE* stream=fopen("D:\\6.bmp","rb");
    if(stream==NULL)
    {
        QLOG_ERROR() << "FILE didn't exist!";
        return;
    }

    int sizeFileHeader=sizeof(BITMAPFILEHEADER);
    int sizeInfoHeader=sizeof(BITMAPINFOHEADER);

    BITMAPFILEHEADER* bitmapFileHeader=new BITMAPFILEHEADER[sizeFileHeader+1];

    BITMAPINFOHEADER* bitmapInfoHeader=new BITMAPINFOHEADER[sizeInfoHeader+1];

    memset(bitmapFileHeader,0,sizeFileHeader+1);
    memset(bitmapInfoHeader,0,sizeInfoHeader+1);
    fread(bitmapFileHeader,sizeof(char),sizeFileHeader,stream);
    fseek(stream,sizeFileHeader,0);
    fread(bitmapInfoHeader,sizeof(char),sizeInfoHeader,stream);
    fseek(stream,sizeInfoHeader+sizeFileHeader,0);
    RGBQUAD* pRgbQuards=new RGBQUAD[256];
    for (int k=0;k<256;k++)
    {
        fread(&pRgbQuards[k],sizeof(RGBQUAD),1,stream);
    }

    int count=(((bitmapInfoHeader->biWidth)*8+31)/32)*4-bitmapInfoHeader->biWidth*(bitmapInfoHeader->biBitCount/8);
    BYTE* tempData=new BYTE[count+1];
    memset(tempData,0,count+1);
    fseek(stream,sizeFileHeader+sizeInfoHeader+256*sizeof(RGBQUAD),0);
    BYTE** data=new BYTE*[bitmapInfoHeader->biHeight];
    for(int i=0;i<bitmapInfoHeader->biHeight;i++)
    {
        data[i]=new BYTE[bitmapInfoHeader->biWidth];
        for (int j=0;j<bitmapInfoHeader->biWidth;j++)
        {
            fread(&data[i][j],sizeof(char),1,stream);
            if(data[i][j]>threshold)
                data[i][j]=255;
            else
                data[i][j]=0;
        }
        for (int n=0;n<count;n++)
        {
            fread(&tempData[n],sizeof(char),1,stream);
        }
    }

    fclose(stream);



    //写入。。
    FILE* fileWrite=fopen("D:\\9.bmp","a+");
    fwrite(bitmapFileHeader,sizeof(char),sizeof(BITMAPFILEHEADER),fileWrite);
    fwrite(bitmapInfoHeader,sizeof(char),sizeof(BITMAPINFOHEADER),fileWrite);
    fwrite(pRgbQuards,sizeof(RGBQUAD),256,fileWrite);

    for(int i=0;i<bitmapInfoHeader->biHeight;i++)
    {
        for(int j=0;j<bitmapInfoHeader->biWidth;j++)
        {
            fwrite(&data[i][j],sizeof(BYTE),1,fileWrite);
        }
        for(int m=0;m<count;m++)
            fwrite(&tempData[m],sizeof(char),1,fileWrite);
    }
    fclose(fileWrite);

}


